/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v2;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.console.model.Namespace;
import com.alibaba.nacos.console.model.NamespaceAllInfo;
import com.alibaba.nacos.console.model.form.NamespaceForm;
import com.alibaba.nacos.console.service.NamespaceOperationService;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(path={"/v2/console/namespace"})
public class NamespaceControllerV2 {
    private final NamespaceOperationService namespaceOperationService;
    private final Pattern namespaceIdCheckPattern = Pattern.compile("^[\\w-]+");
    private static final int NAMESPACE_ID_MAX_LENGTH = 128;

    public NamespaceControllerV2(NamespaceOperationService namespaceOperationService) {
        this.namespaceOperationService = namespaceOperationService;
    }

    @GetMapping(value={"/list"})
    public Result<List<Namespace>> getNamespaceList() {
        return Result.success((Object)this.namespaceOperationService.getNamespaceList());
    }

    @GetMapping
    @Secured(resource="console/namespaces", action=ActionTypes.READ, signType="console")
    public Result<NamespaceAllInfo> getNamespace(@RequestParam(value="namespaceId") String namespaceId) throws NacosException {
        return Result.success((Object)this.namespaceOperationService.getNamespace(namespaceId));
    }

    @PostMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE, signType="console")
    public Result<Boolean> createNamespace(NamespaceForm namespaceForm) throws NacosException {
        namespaceForm.validate();
        String namespaceId = namespaceForm.getNamespaceId();
        String namespaceName = namespaceForm.getNamespaceName();
        String namespaceDesc = namespaceForm.getNamespaceDesc();
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = UUID.randomUUID().toString();
        } else {
            if (!this.namespaceIdCheckPattern.matcher(namespaceId = namespaceId.trim()).matches()) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_NAMESPACE, "namespaceId [" + namespaceId + "] mismatch the pattern");
            }
            if (namespaceId.length() > 128) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_NAMESPACE, "too long namespaceId, over 128");
            }
        }
        return Result.success((Object)this.namespaceOperationService.createNamespace(namespaceId, namespaceName, namespaceDesc));
    }

    @PutMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE, signType="console")
    public Result<Boolean> editNamespace(NamespaceForm namespaceForm) throws NacosException {
        namespaceForm.validate();
        return Result.success((Object)this.namespaceOperationService.editNamespace(namespaceForm.getNamespaceId(), namespaceForm.getNamespaceName(), namespaceForm.getNamespaceDesc()));
    }

    @DeleteMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE, signType="console")
    public Result<Boolean> deleteNamespace(@RequestParam(value="namespaceId") String namespaceId) {
        return Result.success((Object)this.namespaceOperationService.removeNamespace(namespaceId));
    }
}

