/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.system.service.impl;

import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.SpringUtils;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.bean.BeanValidators;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.system.api.domain.SysRole;
import gz.lp.system.api.domain.SysUser;
import gz.lp.system.api.domain.vo.UserVo;
import gz.lp.system.domain.SysUserRole;
import gz.lp.system.domain.vo.StoreSelectVo;
import gz.lp.system.mapper.SysRoleMapper;
import gz.lp.system.mapper.SysUserMapper;
import gz.lp.system.mapper.SysUserRoleMapper;
import gz.lp.system.service.ISysConfigService;
import gz.lp.system.service.ISysUserService;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysUserServiceImpl
implements ISysUserService {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @Autowired
    private SysUserMapper userMapper;
    @Autowired
    private SysRoleMapper roleMapper;
    @Autowired
    private SysUserRoleMapper userRoleMapper;
    @Autowired
    private ISysConfigService configService;
    @Autowired
    protected Validator validator;

    public List<SysUser> selectUserList(SysUser user) {
        return this.userMapper.selectUserList(user);
    }

    public List<UserVo> queryUserList() {
        return this.userMapper.queryUserList();
    }

    public List<SysUser> selectAllocatedList(SysUser user) {
        return this.userMapper.selectAllocatedList(user);
    }

    public List<SysUser> selectUnallocatedList(SysUser user) {
        return this.userMapper.selectUnallocatedList(user);
    }

    public SysUser selectUserByUserName(String userName) {
        return this.userMapper.selectUserByUserName(userName);
    }

    public SysUser selectUserById(Long userId) {
        return this.userMapper.selectUserById(userId);
    }

    public String selectUserRoleGroup(String userName) {
        List list = this.roleMapper.selectRolesByUserName(userName);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return "";
        }
        return list.stream().map(SysRole::getRoleName).collect(Collectors.joining(","));
    }

    public boolean checkUserNameUnique(SysUser user) {
        Long userId = StringUtil.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        SysUser info = this.userMapper.checkUserNameUnique(user.getUserName());
        return !StringUtil.isNotNull((Object)info) || info.getUserId().longValue() == userId.longValue();
    }

    public boolean checkPhoneUnique(SysUser user) {
        Long userId = StringUtil.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        SysUser info = this.userMapper.checkPhoneUnique(user.getPhonenumber());
        return !StringUtil.isNotNull((Object)info) || info.getUserId().longValue() == userId.longValue();
    }

    public boolean checkEmailUnique(SysUser user) {
        Long userId = StringUtil.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        SysUser info = this.userMapper.checkEmailUnique(user.getEmail());
        return !StringUtil.isNotNull((Object)info) || info.getUserId().longValue() == userId.longValue();
    }

    public boolean checkPassword(SysUser user) {
        String password = user.getPassword();
        return password.matches(".*[a-z].*") && password.matches(".*\\d.*") && password.matches(".*[A-Z].*") && password.matches(".*[!@#$%^&*}].*");
    }

    public void checkUserAllowed(SysUser user) {
        if (StringUtil.isNotNull((Object)user.getUserId()) && user.isAdmin()) {
            throw new ServiceException("\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8d85\u7ea7\u7ba1\u7406\u5458\u7528\u6237");
        }
    }

    public void checkUserDataScope(Long userId) {
        if (!SysUser.isAdmin((Long)SecurityUtils.getUserId())) {
            SysUser user = new SysUser();
            user.setUserId(userId);
            List users = ((SysUserServiceImpl)SpringUtils.getAopProxy((Object)this)).selectUserList(user);
            if (StringUtil.isEmpty((Collection)users)) {
                throw new ServiceException("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u7528\u6237\u6570\u636e\uff01");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertUser(SysUser user) {
        int rows = this.userMapper.insertUser(user);
        SysUser sysUser = this.userMapper.selectUserByUserName(user.getUserName());
        user.setUserId(sysUser.getUserId());
        this.insertUserRole(user);
        return rows;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateUser(SysUser user) {
        Long userId = user.getUserId();
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        this.insertUserRole(user);
        return this.userMapper.updateUser(user);
    }

    @Transactional(rollbackFor={Exception.class})
    public void insertUserAuth(Long userId, Long[] roleIds) {
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        this.insertUserRole(userId, roleIds);
    }

    public int updateUserStatus(SysUser user) {
        return this.userMapper.updateUser(user);
    }

    public int updateUserProfile(SysUser user) {
        return this.userMapper.updateUser(user);
    }

    public boolean updateUserAvatar(String userName, String avatar) {
        return this.userMapper.updateUserAvatar(userName, avatar) > 0;
    }

    public int resetPwd(SysUser user) {
        return this.userMapper.updateUser(user);
    }

    public List<StoreSelectVo> getStoreList() {
        if (SecurityUtils.isAdmin((Long)SecurityUtils.getUserId())) {
            return this.userMapper.selectStoreList(null);
        }
        return this.userMapper.selectStoreList(SecurityUtils.getLoginUser().getDeptId());
    }

    public int resetUserPwd(String userName, String password) {
        return this.userMapper.resetUserPwd(userName, password);
    }

    public void insertUserRole(SysUser user) {
        this.insertUserRole(user.getUserId(), user.getRoleIds());
    }

    public void insertUserRole(Long userId, Long[] roleIds) {
        if (StringUtil.isNotEmpty((Object[])roleIds)) {
            ArrayList<SysUserRole> list = new ArrayList<SysUserRole>();
            for (Long roleId : roleIds) {
                SysUserRole ur = new SysUserRole();
                ur.setUserId(userId);
                ur.setRoleId(roleId);
                list.add(ur);
            }
            this.userRoleMapper.batchUserRole(list);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteUserById(Long userId) {
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        return this.userMapper.deleteUserById(userId);
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteUserByIds(Long[] userIds) {
        for (Long userId : userIds) {
            this.checkUserAllowed(new SysUser(userId));
            this.checkUserDataScope(userId);
        }
        this.userRoleMapper.deleteUserRole(userIds);
        return this.userMapper.deleteUserByIds(userIds);
    }

    public String importUser(List<SysUser> userList, Boolean isUpdateSupport, String operName) {
        if (StringUtil.isNull(userList) || userList.size() == 0) {
            throw new ServiceException("\u5bfc\u5165\u7528\u6237\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        String password = this.configService.selectConfigByKey("sys.user.initPassword");
        for (SysUser user : userList) {
            try {
                SysUser u = this.userMapper.selectUserByUserName(user.getUserName());
                if (StringUtil.isNull((Object)u)) {
                    BeanValidators.validateWithException((Validator)this.validator, (Object)user, (Class[])new Class[0]);
                    user.setPassword(SecurityUtils.encryptPassword((String)password));
                    user.setCreateBy(operName);
                    this.userMapper.insertUser(user);
                    successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getUserName() + " \u5bfc\u5165\u6210\u529f");
                    continue;
                }
                if (isUpdateSupport.booleanValue()) {
                    BeanValidators.validateWithException((Validator)this.validator, (Object)user, (Class[])new Class[0]);
                    this.checkUserAllowed(u);
                    this.checkUserDataScope(u.getUserId());
                    user.setUserId(u.getUserId());
                    user.setUpdateBy(operName);
                    this.userMapper.updateUser(user);
                    successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getUserName() + " \u66f4\u65b0\u6210\u529f");
                    continue;
                }
                failureMsg.append("<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getUserName() + " \u5df2\u5b58\u5728");
            }
            catch (Exception e) {
                String msg = "<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getUserName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                failureMsg.append(msg + e.getMessage());
                log.error(msg, (Throwable)e);
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "\u5f88\u62b1\u6b49\uff0c\u5bfc\u5165\u5931\u8d25\uff01\u5171 " + failureNum + " \u6761\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9519\u8bef\u5982\u4e0b\uff1a");
            throw new ServiceException(failureMsg.toString());
        }
        successMsg.insert(0, "\u606d\u559c\u60a8\uff0c\u6570\u636e\u5df2\u5168\u90e8\u5bfc\u5165\u6210\u529f\uff01\u5171 " + successNum + " \u6761\uff0c\u6570\u636e\u5982\u4e0b\uff1a");
        return successMsg.toString();
    }

    public boolean registerUser(SysUser user) {
        return this.userMapper.insertUser(user) > 0;
    }

    public boolean freezing(String username) {
        int freezing = this.userMapper.freezing(username);
        return freezing > 0;
    }

    public boolean loginDate(String username) {
        int freezing = this.userMapper.loginDate(username, new Date());
        return freezing > 0;
    }
}

