/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.system.controller;

import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.poi.ExcelUtil;
import gz.lp.common.core.web.controller.BaseController;
import gz.lp.common.core.web.domain.AjaxResult;
import gz.lp.common.core.web.page.TableDataInfo;
import gz.lp.common.log.annotation.Log;
import gz.lp.common.log.enums.BusinessType;
import gz.lp.common.security.annotation.InnerAuth;
import gz.lp.common.security.annotation.RequiresPermissions;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.system.api.domain.SysRole;
import gz.lp.system.api.domain.SysUser;
import gz.lp.system.api.domain.vo.UserVo;
import gz.lp.system.api.model.LoginUser;
import gz.lp.system.domain.vo.PasswordVo;
import gz.lp.system.domain.vo.StoreSelectVo;
import gz.lp.system.service.ISysConfigService;
import gz.lp.system.service.ISysPermissionService;
import gz.lp.system.service.ISysRoleService;
import gz.lp.system.service.ISysUserService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/user"})
public class SysUserController
extends BaseController {
    @Autowired
    private ISysUserService userService;
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysPermissionService permissionService;
    @Autowired
    private ISysConfigService configService;

    @RequiresPermissions(value={"system:user:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysUser user) {
        this.startPage();
        List list = this.userService.selectUserList(user);
        return this.getDataTable(list);
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"system:user:export"})
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysUser user) {
        List list = this.userService.selectUserList(user);
        ExcelUtil util = new ExcelUtil(SysUser.class);
        util.exportExcel(response, list, "\u7528\u6237\u6570\u636e");
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.IMPORT)
    @RequiresPermissions(value={"system:user:import"})
    @PostMapping(value={"/importData"})
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception {
        ExcelUtil util = new ExcelUtil(SysUser.class);
        List userList = util.importExcel(file.getInputStream());
        String operName = SecurityUtils.getUsername();
        String message = this.userService.importUser(userList, Boolean.valueOf(updateSupport), operName);
        return this.success(message);
    }

    @PostMapping(value={"/importTemplate"})
    public void importTemplate(HttpServletResponse response) throws IOException {
        ExcelUtil util = new ExcelUtil(SysUser.class);
        util.importTemplateExcel(response, "\u7528\u6237\u6570\u636e");
    }

    @InnerAuth
    @GetMapping(value={"/info/{username}"})
    public R<LoginUser> info(@PathVariable(value="username") String username) {
        SysUser sysUser = this.userService.selectUserByUserName(username);
        if (StringUtil.isNull((Object)sysUser)) {
            return R.failed((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        Set roles = this.permissionService.getRolePermission(sysUser);
        Set permissions = this.permissionService.getMenuPermission(sysUser);
        LoginUser sysUserVo = new LoginUser();
        sysUserVo.setSysUser(sysUser);
        sysUserVo.setRoles(roles);
        sysUserVo.setPermissions(permissions);
        return R.ok((Object)sysUserVo);
    }

    @InnerAuth
    @GetMapping(value={"/queryUserList"})
    public R<List<UserVo>> queryUserList() {
        return R.success((Object)this.userService.queryUserList());
    }

    @InnerAuth
    @PostMapping(value={"/register"})
    public R<Boolean> register(@RequestBody SysUser sysUser) {
        String username = sysUser.getUserName();
        if (!"true".equals(this.configService.selectConfigByKey("sys.account.registerUser"))) {
            return R.failed((String)"\u5f53\u524d\u7cfb\u7edf\u6ca1\u6709\u5f00\u542f\u6ce8\u518c\u529f\u80fd\uff01");
        }
        if (!this.userService.checkUserNameUnique(sysUser)) {
            return R.failed((String)("\u4fdd\u5b58\u7528\u6237'" + username + "'\u5931\u8d25\uff0c\u6ce8\u518c\u8d26\u53f7\u5df2\u5b58\u5728"));
        }
        return R.ok((Object)this.userService.registerUser(sysUser));
    }

    @GetMapping(value={"getInfo"})
    public AjaxResult getInfo() {
        SysUser user = this.userService.selectUserById(SecurityUtils.getUserId());
        Set roles = this.permissionService.getRolePermission(user);
        Set permissions = this.permissionService.getMenuPermission(user);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("user", (Object)user);
        ajax.put("roles", (Object)roles);
        ajax.put("permissions", (Object)permissions);
        return ajax;
    }

    @RequiresPermissions(value={"system:user:query"})
    @GetMapping(value={"/", "/{userId}"})
    public AjaxResult getInfo(@PathVariable(value="userId", required=false) Long userId) {
        this.userService.checkUserDataScope(userId);
        AjaxResult ajax = AjaxResult.success();
        List roles = this.roleService.selectRoleAll();
        ajax.put("roles", (Object)(SysUser.isAdmin((Long)userId) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList())));
        if (StringUtil.isNotNull((Object)userId)) {
            SysUser sysUser = this.userService.selectUserById(userId);
            ajax.put("data", (Object)sysUser);
            ajax.put("roleIds", sysUser.getRoles().stream().map(SysRole::getRoleId).collect(Collectors.toList()));
        }
        return ajax;
    }

    @RequiresPermissions(value={"system:user:add"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysUser user) {
        if (!this.userService.checkUserNameUnique(user)) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (StringUtil.isNotEmpty((String)user.getPhonenumber()) && !this.userService.checkPhoneUnique(user)) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtil.isNotEmpty((String)user.getEmail()) && !this.userService.checkEmailUnique(user)) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (!this.userService.checkPassword(user)) {
            return this.error("\u5bc6\u7801\u5fc5\u987b\u62e5\u6709\u540c\u65f6\u5927\u5199\u5c0f\u5199\u5b57\u6bcd\uff0c\u4e14\u542b\u7279\u6b8a\u5b57\u7b26\u548c\u6570\u5b57");
        }
        user.setCreateBy(SecurityUtils.getUsername());
        user.setPassword(SecurityUtils.encryptPassword((String)user.getPassword()));
        user.setPassUpdate(DateUtils.getTime());
        return this.toAjax(this.userService.insertUser(user));
    }

    @RequiresPermissions(value={"system:user:edit"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        this.userService.checkUserDataScope(user.getUserId());
        if (!this.userService.checkUserNameUnique(user)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (StringUtil.isNotEmpty((String)user.getPhonenumber()) && !this.userService.checkPhoneUnique(user)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtil.isNotEmpty((String)user.getEmail()) && !this.userService.checkEmailUnique(user)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        user.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.userService.updateUser(user));
    }

    @RequiresPermissions(value={"system:user:remove"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{userIds}"})
    public AjaxResult remove(@PathVariable Long[] userIds) {
        if (ArrayUtils.contains((Object[])userIds, (Object)SecurityUtils.getUserId())) {
            return this.error("\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u5220\u9664");
        }
        return this.toAjax(this.userService.deleteUserByIds(userIds));
    }

    @RequiresPermissions(value={"system:user:edit"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/resetPwd"})
    public AjaxResult resetPwd(@RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        this.userService.checkUserDataScope(user.getUserId());
        if (!this.userService.checkPassword(user)) {
            return this.error("\u5bc6\u7801\u5fc5\u987b\u62e5\u6709\u540c\u65f6\u5927\u5199\u5c0f\u5199\u5b57\u6bcd\uff0c\u4e14\u542b\u7279\u6b8a\u5b57\u7b26\u548c\u6570\u5b57");
        }
        user.setPassword(SecurityUtils.encryptPassword((String)user.getPassword()));
        user.setUpdateBy(SecurityUtils.getUsername());
        user.setPassUpdate(DateUtils.getTime());
        return this.toAjax(this.userService.resetPwd(user));
    }

    @PostMapping(value={"/updatePassword"})
    public AjaxResult updatePassword(@RequestBody PasswordVo passwordVo) {
        SysUser sysUser = this.userService.selectUserByUserName(passwordVo.getSysUser());
        SysUser user = new SysUser();
        user.setPassword(passwordVo.getNewPassword());
        if (!this.userService.checkPassword(user)) {
            return AjaxResult.error((String)"\u5bc6\u7801\u5fc5\u987b\u62e5\u6709\u540c\u65f6\u5927\u5199\u5c0f\u5199\u5b57\u6bcd\uff0c\u4e14\u542b\u7279\u6b8a\u5b57\u7b26\u548c\u6570\u5b57");
        }
        if (!SecurityUtils.matchesPassword((String)passwordVo.getOldPassword(), (String)sysUser.getPassword())) {
            return AjaxResult.error((String)"\u65e7\u5bc6\u7801\u9519\u8bef");
        }
        user.setUserId(sysUser.getUserId());
        user.setPassword(SecurityUtils.encryptPassword((String)passwordVo.getNewPassword()));
        return AjaxResult.success((Object)this.userService.resetPwd(user));
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/resetPassword"})
    public AjaxResult resetPassword(@RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        this.userService.checkUserDataScope(user.getUserId());
        if (!this.userService.checkPassword(user)) {
            return this.error("\u5bc6\u7801\u5fc5\u987b\u62e5\u6709\u540c\u65f6\u5927\u5199\u5c0f\u5199\u5b57\u6bcd\uff0c\u4e14\u542b\u7279\u6b8a\u5b57\u7b26\u548c\u6570\u5b57");
        }
        user.setPassword(SecurityUtils.encryptPassword((String)user.getPassword()));
        user.setUpdateBy(SecurityUtils.getUsername());
        user.setPassUpdate(DateUtils.getTime());
        return this.toAjax(this.userService.resetPwd(user));
    }

    @RequiresPermissions(value={"system:user:edit"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changeStatus"})
    public AjaxResult changeStatus(@RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        this.userService.checkUserDataScope(user.getUserId());
        user.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.userService.updateUserStatus(user));
    }

    @RequiresPermissions(value={"system:user:query"})
    @GetMapping(value={"/authRole/{userId}"})
    public AjaxResult authRole(@PathVariable(value="userId") Long userId) {
        AjaxResult ajax = AjaxResult.success();
        SysUser user = this.userService.selectUserById(userId);
        List roles = this.roleService.selectRolesByUserId(userId);
        ajax.put("user", (Object)user);
        ajax.put("roles", (Object)(SysUser.isAdmin((Long)userId) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList())));
        return ajax;
    }

    @RequiresPermissions(value={"system:user:edit"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PutMapping(value={"/authRole"})
    public AjaxResult insertAuthRole(Long userId, Long[] roleIds) {
        this.userService.checkUserDataScope(userId);
        this.userService.insertUserAuth(userId, roleIds);
        return this.success();
    }

    @InnerAuth
    @GetMapping(value={"/status/{username}"})
    public R<Boolean> status(@PathVariable(value="username") String username) {
        boolean ok = this.userService.freezing(username);
        return R.ok((Object)ok);
    }

    @InnerAuth
    @GetMapping(value={"/logindate/{username}"})
    public R<Boolean> loginDate(@PathVariable(value="username") String username) {
        boolean ok = this.userService.loginDate(username);
        return R.ok((Object)ok);
    }

    @PostMapping(value={"/storeList"})
    public R<List<StoreSelectVo>> getStoreList() {
        return R.ok((Object)this.userService.getStoreList());
    }
}

