/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.system.controller;

import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.file.FileTypeUtils;
import gz.lp.common.core.utils.file.MimeTypeUtils;
import gz.lp.common.core.web.controller.BaseController;
import gz.lp.common.core.web.domain.AjaxResult;
import gz.lp.common.log.annotation.Log;
import gz.lp.common.log.enums.BusinessType;
import gz.lp.common.security.service.TokenService;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.system.api.RemoteFileService;
import gz.lp.system.api.domain.FileUrl;
import gz.lp.system.api.domain.SysUser;
import gz.lp.system.api.model.LoginUser;
import gz.lp.system.service.ISysUserService;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/user/profile"})
public class SysProfileController
extends BaseController {
    @Autowired
    private ISysUserService userService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private RemoteFileService remoteFileService;

    @GetMapping
    public AjaxResult profile() {
        String username = SecurityUtils.getUsername();
        SysUser user = this.userService.selectUserByUserName(username);
        AjaxResult ajax = AjaxResult.success((Object)user);
        ajax.put("roleGroup", (Object)this.userService.selectUserRoleGroup(username));
        return ajax;
    }

    @Log(title="\u4e2a\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult updateProfile(@RequestBody SysUser user) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        SysUser currentUser = loginUser.getSysUser();
        currentUser.setNickName(user.getNickName());
        currentUser.setEmail(user.getEmail());
        currentUser.setPhonenumber(user.getPhonenumber());
        if (StringUtil.isNotEmpty((String)user.getPhonenumber()) && !this.userService.checkPhoneUnique(currentUser)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtil.isNotEmpty((String)user.getEmail()) && !this.userService.checkEmailUnique(currentUser)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (this.userService.updateUserProfile(currentUser) > 0) {
            this.tokenService.setLoginUser(loginUser);
            return this.success();
        }
        return this.error("\u4fee\u6539\u4e2a\u4eba\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @Log(title="\u4e2a\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/updatePwd"})
    public AjaxResult updatePwd(String oldPassword, String newPassword) {
        String username = SecurityUtils.getUsername();
        SysUser user = this.userService.selectUserByUserName(username);
        String password = user.getPassword();
        if (!SecurityUtils.matchesPassword((String)oldPassword, (String)password)) {
            return this.error("\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff0c\u65e7\u5bc6\u7801\u9519\u8bef");
        }
        if (SecurityUtils.matchesPassword((String)newPassword, (String)password)) {
            return this.error("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c");
        }
        if (this.userService.resetUserPwd(username, SecurityUtils.encryptPassword((String)newPassword)) > 0) {
            LoginUser loginUser = SecurityUtils.getLoginUser();
            loginUser.getSysUser().setPassword(SecurityUtils.encryptPassword((String)newPassword));
            this.tokenService.setLoginUser(loginUser);
            return this.success();
        }
        return this.error("\u4fee\u6539\u5bc6\u7801\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @Log(title="\u7528\u6237\u5934\u50cf", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/avatar"})
    public AjaxResult avatar(@RequestParam(value="avatarfile") MultipartFile file) {
        if (!file.isEmpty()) {
            LoginUser loginUser = SecurityUtils.getLoginUser();
            String extension = FileTypeUtils.getExtension((MultipartFile)file);
            if (!StringUtil.equalsAnyIgnoreCase((CharSequence)extension, (CharSequence[])MimeTypeUtils.IMAGE_EXTENSION)) {
                return this.error("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0a\u4f20" + Arrays.toString(MimeTypeUtils.IMAGE_EXTENSION) + "\u683c\u5f0f");
            }
            R fileResult = this.remoteFileService.upload(file);
            if (StringUtil.isNull((Object)fileResult) || StringUtil.isNull((Object)fileResult.getData())) {
                return this.error("\u6587\u4ef6\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            String url = ((FileUrl)fileResult.getData()).getLocalURL();
            if (this.userService.updateUserAvatar(loginUser.getUsername(), url)) {
                AjaxResult ajax = AjaxResult.success();
                ajax.put("imgUrl", (Object)url);
                this.tokenService.setLoginUser(loginUser);
                return ajax;
            }
        }
        return this.error("\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }
}

