/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.system.controller;

import gz.lp.common.core.utils.poi.ExcelUtil;
import gz.lp.common.core.web.controller.BaseController;
import gz.lp.common.core.web.domain.AjaxResult;
import gz.lp.common.core.web.page.TableDataInfo;
import gz.lp.common.log.annotation.Log;
import gz.lp.common.log.enums.BusinessType;
import gz.lp.common.redis.util.RedisUtil;
import gz.lp.common.security.annotation.InnerAuth;
import gz.lp.common.security.annotation.RequiresPermissions;
import gz.lp.system.api.domain.SysLogininfor;
import gz.lp.system.service.ISysLogininforService;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logininfor"})
public class SysLogininforController
extends BaseController {
    @Autowired
    private ISysLogininforService logininforService;

    @RequiresPermissions(value={"system:logininfor:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysLogininfor logininfor) {
        this.startPage();
        List list = this.logininforService.selectLogininforList(logininfor);
        return this.getDataTable(list);
    }

    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysLogininfor logininfor) {
        List list = this.logininforService.selectLogininforList(logininfor);
        ExcelUtil util = new ExcelUtil(SysLogininfor.class);
        util.exportExcel(response, list, "\u767b\u5f55\u65e5\u5fd7");
    }

    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{infoIds}"})
    public AjaxResult remove(@PathVariable Long[] infoIds) {
        return this.toAjax(this.logininforService.deleteLogininforByIds(infoIds));
    }

    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/clean"})
    public AjaxResult clean() {
        this.logininforService.cleanLogininfor();
        return this.success();
    }

    @Log(title="\u8d26\u6237\u89e3\u9501", businessType=BusinessType.OTHER)
    @GetMapping(value={"/unlock/{userName}"})
    public AjaxResult unlock(@PathVariable(value="userName") String userName) {
        RedisUtil.del((String[])new String[]{"pwd_err_cnt:" + userName});
        return this.success();
    }

    @InnerAuth
    @PostMapping
    public AjaxResult add(@RequestBody SysLogininfor logininfor) {
        return this.toAjax(this.logininforService.insertLogininfor(logininfor));
    }
}

