/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.service.file.service;

import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.file.FileTypeUtils;
import gz.lp.common.core.utils.file.MimeTypeUtils;
import gz.lp.common.core.utils.keyword.SensitiveWordFilter;
import gz.lp.system.api.RemoteFileService;
import gz.lp.system.api.domain.FileUrl;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileService {
    @Autowired
    private RemoteFileService remoteFileService;

    public R uploadPicture(MultipartFile file) {
        if (!file.isEmpty()) {
            String fileName;
            SensitiveWordFilter sensitiveWordFilter = SensitiveWordFilter.getSensitiveWordFilter();
            boolean containtSensitiveWord = sensitiveWordFilter.isContaintSensitiveWord(fileName = file.getOriginalFilename().substring(0, file.getOriginalFilename().indexOf(".")), 1);
            if (!containtSensitiveWord) {
                String extension = FileTypeUtils.getExtension((MultipartFile)file);
                if (!StringUtil.equalsAnyIgnoreCase((CharSequence)extension, (CharSequence[])MimeTypeUtils.DEFAULT_ALLOWED_PICTURE)) {
                    return R.failed((String)("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0a\u4f20" + Arrays.toString(MimeTypeUtils.DEFAULT_ALLOWED_PICTURE) + "\u683c\u5f0f"));
                }
                R fileResult = this.remoteFileService.upload(file);
                if (StringUtil.isNull((Object)fileResult) || StringUtil.isNull((Object)fileResult.getData())) {
                    return R.failed((String)"\u6587\u4ef6\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                return R.success((Object)((FileUrl)fileResult.getData()).getLocalURL());
            }
            return R.failed((String)"\u56fe\u7247\u540d\u79f0\u5305\u542b\u654f\u611f\u8bcd\uff0c\u8bf7\u4fee\u6539\u540e\u4e0a\u4f20");
        }
        return R.failed((String)"\u4e0a\u4f20\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }
}

