/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.service.advertisement.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.service.advertisement.domain.Advertisement;
import gz.lp.service.advertisement.mapper.AdvertisementMapper;
import gz.lp.service.advertisement.service.IAdvertisementService;
import gz.lp.service.advertisement.vo.AdvertisementListVo;
import gz.lp.system.api.domain.QueryAdvertisementVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertisementServiceImpl
extends ServiceImpl<AdvertisementMapper, Advertisement>
implements IAdvertisementService {
    @Autowired
    private AdvertisementMapper advertisementMapper;

    public Advertisement selectAdvertisementByAdvertisementId(Integer advertisementId) {
        return (Advertisement)this.advertisementMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)advertisementId));
    }

    public Page<Advertisement> selectAdvertisementList(AdvertisementListVo vo) {
        Page page = new Page();
        page.setCurrent((long)vo.getPageNum().intValue());
        page.setSize((long)vo.getPageSize().intValue());
        QueryWrapper query = new QueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)vo.getAdTitle())) {
            query.like((Object)"ad_title", (Object)vo.getAdTitle());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getStartTime()) && StrUtil.isNotBlank((CharSequence)vo.getEndTime())) {
            query.between((Object)"start_date", (Object)vo.getStartTime(), (Object)vo.getEndTime());
        }
        if (vo.getStatus() != null) {
            query.eq((Object)"status", (Object)vo.getStatus());
        }
        if (vo.getAdPosition() != null) {
            query.eq((Object)"ad_position", (Object)vo.getAdPosition());
        }
        query.orderByAsc((Object)"sort_order");
        return (Page)this.advertisementMapper.selectPage((IPage)page, (Wrapper)query);
    }

    public R insertAdvertisement(Advertisement advertisement) {
        advertisement.setCreateTime(DateUtils.getNowDate());
        advertisement.setIsDel(0);
        boolean save = this.save((Object)advertisement);
        if (save) {
            return R.success((Object)"\u65b0\u589e\u6210\u529f");
        }
        return R.failed((String)"\u65b0\u589e\u5931\u8d25");
    }

    public boolean updateAdvertisement(Advertisement advertisement) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(Advertisement.class).set(Advertisement::getStartDate, (Object)advertisement.getStartDate())).set(Advertisement::getEndDate, (Object)advertisement.getEndDate())).eq(Advertisement::getId, (Object)advertisement.getId());
        return this.advertisementMapper.update((Object)advertisement, (Wrapper)wrapper) > 0;
    }

    public int deleteAdvertisementByAdvertisementIds(Long[] advertisementIds) {
        return this.advertisementMapper.deleteAdvertisementByAdvertisementIds(advertisementIds);
    }

    public int deleteAdvertisementByAdvertisementId(Long advertisementId) {
        return this.advertisementMapper.deleteAdvertisementByAdvertisementId(advertisementId);
    }

    public IPage<Advertisement> queryAdvertisement(QueryAdvertisementVo vo) {
        Page page = new Page();
        page.setCurrent((long)vo.getPageNo().intValue());
        page.setSize((long)vo.getPageSize().intValue());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"is_del", (Object)0);
        query.eq((Object)"status", (Object)"1");
        if (vo.getAdPosition() != null) {
            query.eq((Object)"ad_position", (Object)vo.getAdPosition());
        }
        return this.advertisementMapper.selectPage((IPage)page, (Wrapper)query);
    }
}

