/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.store.service.impl;

import com.alibaba.nacos.api.utils.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.tools;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.mall.cache.CacheTools;
import gz.lp.mall.product.entity.GoodsCategory;
import gz.lp.mall.product.mapper.GoodsCategoryMapper;
import gz.lp.mall.store.entity.Store;
import gz.lp.mall.store.mapper.StoreMapper;
import gz.lp.mall.store.param.StoreNameParam;
import gz.lp.mall.store.service.StoreService;
import gz.lp.mall.tool.DistanceUtils;
import gz.lp.system.api.domain.param.AddAndEditStoreParam;
import gz.lp.system.api.domain.param.DeleteStoreParam;
import gz.lp.system.api.domain.param.QueryStoreParam;
import gz.lp.system.api.domain.param.QueryStoreParamForApplet;
import gz.lp.system.api.domain.vo.CategoryNode;
import gz.lp.system.api.domain.vo.InventoryCategoryVo;
import gz.lp.system.api.domain.vo.InventoryGoodsForAppletVo;
import gz.lp.system.api.domain.vo.QueryStoreVO;
import gz.lp.system.api.domain.vo.StoreVo;
import gz.lp.system.api.vo.PriceWithPointsVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoreServiceImpl
extends ServiceImpl<StoreMapper, Store>
implements StoreService {
    @Autowired
    private StoreMapper storeMapper;
    @Autowired
    GoodsCategoryMapper goodsCategoryMapper;

    public List<QueryStoreVO> queryStore(QueryStoreParam queryStoreParam) {
        Long userId;
        MPJLambdaWrapper storeMPJLambdaWrapper = new MPJLambdaWrapper(Store.class).select(new SFunction[]{Store::getStoreId, Store::getStoreName, Store::getStoreImage, Store::getStoreIntroduction});
        if (!StringUtils.isEmpty((CharSequence)queryStoreParam.getStoreName())) {
            storeMPJLambdaWrapper.like(Store::getStoreName, (Object)queryStoreParam.getStoreName());
        }
        if ((userId = SecurityUtils.getLoginUser().getSysUser().getUserId()) != 1L) {
            storeMPJLambdaWrapper.eq(Store::getStoreManager, (Object)userId);
        } else if (queryStoreParam.getStoreManager() != null && queryStoreParam.getStoreManager() != 1) {
            storeMPJLambdaWrapper.eq(Store::getStoreManager, (Object)queryStoreParam.getStoreManager());
        }
        storeMPJLambdaWrapper.eq(Store::getIsDel, (Object)0);
        return this.storeMapper.selectJoinList(QueryStoreVO.class, (MPJBaseJoin)storeMPJLambdaWrapper);
    }

    public int insertStore(AddAndEditStoreParam addAndEditStoreParam) {
        Store store = new Store();
        store.setCreatedAt(DateUtils.formatDate((String)DateUtils.getTime()));
        try {
            tools.structure((Object)store, (Object)addAndEditStoreParam, (Boolean)true);
            return this.storeMapper.insert((Object)store);
        }
        catch (Exception e) {
            throw new ServiceException("\u51fa\u9519\u4e86\uff01");
        }
    }

    public int editStore(AddAndEditStoreParam addAndEditStoreParam) {
        Store store = (Store)this.storeMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"store_id", (Object)addAndEditStoreParam.getStoreId())).eq((Object)"is_del", (Object)0));
        try {
            tools.structure((Object)store, (Object)addAndEditStoreParam, (Boolean)false);
            store.setUpdatedAt(DateUtils.formatDate((String)DateUtils.getTime()));
            return this.storeMapper.updateById((Object)store);
        }
        catch (Exception e) {
            throw new ServiceException("\u51fa\u9519\u4e86\uff01");
        }
    }

    public int deleteStore(DeleteStoreParam deleteStoreParam) {
        Store store = (Store)this.storeMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"store_id", (Object)deleteStoreParam.getStoreId())).eq((Object)"is_del", (Object)0));
        store.setIsDel(Boolean.valueOf(true));
        store.setUpdatedAt(DateUtils.formatDate((String)DateUtils.getTime()));
        return this.storeMapper.updateById((Object)store);
    }

    public List<StoreNameParam> queryStoreNameAndId() {
        return this.storeMapper.getStoreNameAndId();
    }

    public AddAndEditStoreParam queryDetails(String id) {
        Store store = (Store)this.storeMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"store_id", (Object)id)).eq((Object)"is_del", (Object)0));
        AddAndEditStoreParam addAndEditStoreParam = new AddAndEditStoreParam();
        BeanUtils.copyProperties((Object)store, (Object)addAndEditStoreParam);
        return addAndEditStoreParam;
    }

    public List<Store> queryStoreForApplet(QueryStoreParamForApplet queryStoreParamForApplet) {
        if (StringUtils.isEmpty((CharSequence)queryStoreParamForApplet.getLongitudeLatitude())) {
            List list = this.storeMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"is_del", (Object)0));
            return list;
        }
        String[] inputParts = queryStoreParamForApplet.getLongitudeLatitude().split(",");
        if (inputParts.length != 2) {
            throw new IllegalArgumentException("\u7ecf\u7eac\u5ea6\u683c\u5f0f\u9519\u8bef");
        }
        double targetLat = Double.parseDouble(inputParts[0].trim());
        double targetLon = Double.parseDouble(inputParts[1].trim());
        QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"is_del", (Object)0);
        List stores = this.storeMapper.selectList((Wrapper)wrapper);
        for (Store store : stores) {
            String[] storeParts = store.getLongitudeLatitude().split(",");
            if (storeParts.length != 2) {
                store.setDistance(Double.valueOf(Double.MAX_VALUE));
                continue;
            }
            try {
                double storeLat = Double.parseDouble(storeParts[0].trim());
                double storeLon = Double.parseDouble(storeParts[1].trim());
                double distance = DistanceUtils.calculateDistance((double)targetLat, (double)targetLon, (double)storeLat, (double)storeLon);
                store.setDistance(Double.valueOf(distance));
            }
            catch (NumberFormatException e) {
                store.setDistance(Double.valueOf(Double.MAX_VALUE));
            }
        }
        stores.sort(Comparator.comparingDouble(Store::getDistance));
        return stores;
    }

    public InventoryGoodsForAppletVo getGoodsForStore(Integer id) {
        Store store = (Store)this.storeMapper.selectById((Serializable)id);
        StoreVo storeVo = new StoreVo();
        BeanUtils.copyProperties((Object)store, (Object)storeVo);
        List goods = this.storeMapper.getGoods(id);
        Integer isVip = SecurityUtils.getLoginUser().getMember().getIsVip();
        GoodsCategory goodsCategory = (GoodsCategory)this.goodsCategoryMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"code", (Object)"code123"));
        Integer pointId = goodsCategory.getId();
        goods.stream().filter(go -> go.getCategoryId().equals(pointId)).forEach(go -> {
            PriceWithPointsVo calculate = CacheTools.calculate((BigDecimal)go.getPrice(), (int)go.getIntegralRatio());
            go.setPriceWithPointsVo(calculate);
        });
        if (isVip == 1) {
            goods.stream().filter(vo -> vo.getVipRatio() != null && vo.getVipRatio() != 0).forEach(vo -> vo.setMinPrice(vo.getPrice().multiply(new BigDecimal(vo.getVipRatio()))));
        }
        Map<Integer, List<InventoryCategoryVo>> goodsByCategory = goods.stream().collect(Collectors.groupingBy(InventoryCategoryVo::getCategoryId));
        ArrayList categoryNodes = new ArrayList();
        goodsByCategory.forEach((categoryId, goodsList) -> {
            InventoryCategoryVo inventoryCategoryVo = (InventoryCategoryVo)goodsList.get(0);
            CategoryNode node = new CategoryNode();
            node.setCategoryId(categoryId);
            node.setCategoryName(inventoryCategoryVo.getCategoryName());
            node.setCategoryImage(inventoryCategoryVo.getCategoryImage());
            node.setGoodsList(goodsList);
            categoryNodes.add(node);
        });
        InventoryGoodsForAppletVo inventoryGoodsForAppletVo = new InventoryGoodsForAppletVo();
        inventoryGoodsForAppletVo.setStore(storeVo);
        inventoryGoodsForAppletVo.setCategoryNode(categoryNodes);
        return inventoryGoodsForAppletVo;
    }

    public List<StoreVo> CheckStoresByProducts(Integer SKUId) {
        return this.storeMapper.queryStoreInfo(SKUId);
    }
}

