/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.store.controller;

import gz.lp.common.core.api.R;
import gz.lp.common.security.annotation.InnerAuth;
import gz.lp.mall.store.service.StoreService;
import gz.lp.system.api.RemoteUserService;
import gz.lp.system.api.domain.param.AddAndEditStoreParam;
import gz.lp.system.api.domain.param.DeleteStoreParam;
import gz.lp.system.api.domain.param.IdPrams;
import gz.lp.system.api.domain.param.QueryDetailParam;
import gz.lp.system.api.domain.param.QueryStoreParam;
import gz.lp.system.api.domain.param.QueryStoreParamForApplet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/store"})
public class StoreController {
    @Autowired
    private StoreService storeService;
    @Autowired
    private RemoteUserService remoteUserService;
    @Autowired
    private StoreService service;

    @PostMapping(value={"/queryStore"})
    public R queryStore(@RequestBody QueryStoreParam queryStoreParam) {
        return R.success((Object)this.storeService.queryStore(queryStoreParam));
    }

    @GetMapping(value={"/queryUserList"})
    public R queryUserList() {
        return this.remoteUserService.queryUserList("inner");
    }

    @PostMapping(value={"/getStoreNameList"})
    public R getStoreNameList() {
        return R.success((Object)this.service.queryStoreNameAndId());
    }

    @PostMapping(value={"/addStore"})
    public R addStore(@RequestBody AddAndEditStoreParam addAndEditStoreParam) {
        return R.success((Object)this.storeService.insertStore(addAndEditStoreParam));
    }

    @PostMapping(value={"/deleteStore"})
    public R deleteStore(@RequestBody DeleteStoreParam deleteStoreParam) {
        return R.success((Object)this.storeService.deleteStore(deleteStoreParam));
    }

    @PostMapping(value={"/queryDetails"})
    public R queryDetails(@RequestBody QueryDetailParam queryDetailParam) {
        return R.success((Object)this.storeService.queryDetails(queryDetailParam.getId()));
    }

    @PostMapping(value={"/updateStore"})
    public R updateStore(@RequestBody AddAndEditStoreParam addAndEditStoreParam) {
        return R.success((Object)this.storeService.editStore(addAndEditStoreParam));
    }

    @InnerAuth
    @PostMapping(value={"/queryStoreForApplet"})
    public R queryStoreForApplet(@RequestBody QueryStoreParamForApplet queryStoreParamForApplet) {
        return R.success((Object)this.storeService.queryStoreForApplet(queryStoreParamForApplet));
    }

    @InnerAuth
    @PostMapping(value={"/queryStoreGoodsForApplet"})
    public R queryStoreGoodsForApplet(@RequestBody IdPrams idPrams) {
        return R.success((Object)this.storeService.getGoodsForStore(idPrams.getId()));
    }

    @InnerAuth
    @PostMapping(value={"/checkStoresByProducts"})
    public R checkStoresByProducts(@RequestBody IdPrams idPrams) {
        return R.success((Object)this.storeService.CheckStoresByProducts(idPrams.getId()));
    }
}

