/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.product.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import gz.lp.common.core.annotation.IDMust;
import gz.lp.common.core.api.R;
import gz.lp.mall.commons.IdsValidate;
import gz.lp.mall.commons.ProductIdValidate;
import gz.lp.mall.product.param.GoodsCreateValidate;
import gz.lp.mall.product.param.GoodsSearchValidate;
import gz.lp.mall.product.param.GoodsUpdateValidate;
import gz.lp.mall.product.service.GoodsSkuService;
import gz.lp.mall.product.service.IGoodsService;
import gz.lp.mall.product.vo.GetStoreGoodsVo;
import gz.lp.mall.product.vo.GoodsDetailVo;
import gz.lp.mall.product.vo.GoodsListedVo;
import gz.lp.system.api.domain.QueryByIdsVo;
import gz.lp.system.api.param.QueryGoodsDetailParam;
import gz.lp.system.api.param.QueryGoodsParam;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goods/product"})
public class GoodsProductController {
    @Autowired
    IGoodsService iGoodsService;
    @Autowired
    GoodsSkuService goodsSkuService;

    @PostMapping(value={"/list"})
    public R<IPage<GoodsListedVo>> list(@RequestBody GoodsSearchValidate goodsSearchValidate) {
        IPage list = this.iGoodsService.list(goodsSearchValidate);
        return R.success((Object)list);
    }

    @GetMapping(value={"/detail"})
    public R<Object> detail(@Validated @IDMust @RequestParam(value="id") Integer id) {
        GoodsDetailVo detail = this.iGoodsService.detail(id);
        return R.success((Object)detail);
    }

    @PostMapping(value={"/add"})
    public R<Object> add(@Validated @RequestBody GoodsCreateValidate goodsCreateValidate) {
        this.iGoodsService.add(goodsCreateValidate);
        return R.ok();
    }

    @PostMapping(value={"/edit"})
    public R<Object> edit(@Validated @RequestBody GoodsUpdateValidate goodsUpdateValidate) {
        boolean result = this.iGoodsService.edit(goodsUpdateValidate);
        if (result) {
            return R.ok();
        }
        return R.success((Object)"\u5546\u54c1\u4fe1\u606f\u4fee\u6539\u6210\u529f,\u8be5\u5546\u54c1\u5c5e\u4e8e\u5206\u9500\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5206\u9500\u4fe1\u606f\uff01");
    }

    @PostMapping(value={"/del"})
    public R<Object> del(@Validated @RequestBody ProductIdValidate idValidate) {
        this.iGoodsService.del(idValidate.getId());
        return R.ok();
    }

    @PostMapping(value={"/change"})
    public R<Object> change(@Validated @RequestBody ProductIdValidate idValidate) {
        this.iGoodsService.change(idValidate.getId());
        return R.ok();
    }

    @PostMapping(value={"/sort"})
    public R<Object> sort(@RequestBody Map<String, Integer> params) {
        Assert.notNull((Object)params.get("id"), (String)"id\u53c2\u6570\u7f3a\u5931", (Object[])new Object[0]);
        Assert.notNull((Object)params.get("sort"), (String)"sort\u53c2\u6570\u7f3a\u5931", (Object[])new Object[0]);
        this.iGoodsService.sort(params.get("id"), params.get("sort"));
        return R.ok();
    }

    @PostMapping(value={"/batchDelete"})
    public R<Object> batchDelete(@Validated @RequestBody IdsValidate idsValidate) {
        this.iGoodsService.batchDelete(idsValidate.getIds());
        return R.ok();
    }

    @PostMapping(value={"/batchUpper"})
    public R<Object> batchUpper(@Validated @RequestBody IdsValidate idsValidate) {
        this.iGoodsService.batchUpper(idsValidate.getIds());
        return R.ok();
    }

    @PostMapping(value={"/batchLower"})
    public R<Object> batchLower(@Validated @RequestBody IdsValidate idsValidate) {
        this.iGoodsService.batchLower(idsValidate.getIds());
        return R.ok();
    }

    @PostMapping(value={"/queryGoodsPage"})
    public R queryGoodsPage(@Validated @RequestBody QueryGoodsParam queryGoodsParam) {
        return R.success((Object)this.iGoodsService.queryPage(queryGoodsParam));
    }

    @PostMapping(value={"/queryGoodsDetailApplet"})
    public R queryGoodsDetailApplet(@Validated @RequestBody QueryGoodsDetailParam queryGoodsDetailParam) {
        return R.success((Object)this.iGoodsService.AppletQueryDetail(queryGoodsDetailParam));
    }

    @PostMapping(value={"/getListByIds"})
    public R getListByIds(@RequestBody QueryByIdsVo vo) {
        return R.success((Object)this.iGoodsService.getListByIds(vo.getIds()));
    }

    @GetMapping(value={"/getGoodsList"})
    public R getGoodsList() {
        return R.success((Object)this.iGoodsService.getGoodsList());
    }

    @PostMapping(value={"/getListByIdsAndSku"})
    public R getListByIdsAndSku(@RequestBody GetStoreGoodsVo vo) {
        return R.success((Object)this.iGoodsService.getListByIdsAndSku(vo));
    }

    @PostMapping(value={"/getStoreGoods"})
    public R getStoreGoods(@RequestBody GetStoreGoodsVo vo) {
        return R.success((Object)this.iGoodsService.getStoreGoods(vo));
    }
}

