/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.order.task;

import gz.lp.common.core.api.R;
import gz.lp.common.pay.service.WxPayService;
import gz.lp.mall.inventory.entity.Inventory;
import gz.lp.mall.inventory.mapper.InventoryMapper;
import gz.lp.mall.order.mapper.StoreOrderInfoMapper;
import gz.lp.mall.order.mapper.StoreOrderMapper;
import gz.lp.mall.order.service.StoreOrderInfoService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class OrderOvertime {
    @Autowired
    private StoreOrderInfoMapper orderMapper;
    @Autowired
    private StoreOrderMapper storeOrderMapper;
    @Autowired
    private StoreOrderInfoService storeOrderInfoService;
    @Autowired
    private InventoryMapper inventoryMapper;
    @Autowired
    private WxPayService wxPayService;

    @Scheduled(cron="*/30 * * * * ?")
    public void task() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put("is_pay", 0);
        List customerOrders = this.orderMapper.selectByMap(map);
        customerOrders.forEach(storeOrderInfo -> {
            LocalDateTime orderCreateTime = storeOrderInfo.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (orderCreateTime.plusMinutes(30L).isBefore(LocalDateTime.now())) {
                R payOrderInfo = this.wxPayService.queryOrderByOutTradeNo(storeOrderInfo.getOrderNo());
                LinkedHashMap res = (LinkedHashMap)payOrderInfo.getData();
                if (payOrderInfo.getCode() == 200L && !res.isEmpty() && "\u652f\u4ed8\u6210\u529f".equals(res.get("msg"))) {
                    this.storeOrderInfoService.orderPaySuccess(storeOrderInfo.getOrderNo(), (Map)payOrderInfo.getData());
                } else {
                    Inventory productInventory = this.inventoryMapper.selectForUpdate(storeOrderInfo.getInventoryId());
                    if (productInventory != null) {
                        productInventory.setStock(Integer.valueOf(productInventory.getStock() + storeOrderInfo.getPayNum()));
                        this.inventoryMapper.updateById((Object)productInventory);
                    }
                    storeOrderInfo.setIsPay(Integer.valueOf(-1));
                    storeOrderInfo.setStatus(Integer.valueOf(6));
                }
            }
        });
        this.storeOrderInfoService.saveOrUpdateBatch((Collection)customerOrders);
    }
}

