/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.order.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.common.core.api.R;
import gz.lp.common.core.enums.enumeration.PointChangeTypeEnum;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.IdUtils;
import gz.lp.common.pay.config.CreateOrderReq;
import gz.lp.common.pay.service.WxPayService;
import gz.lp.common.redis.util.RedisUtil;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.mall.cart.entity.ShoppingCart;
import gz.lp.mall.cart.service.ShoppingCartService;
import gz.lp.mall.coupon.domain.CouponUsage;
import gz.lp.mall.coupon.domain.dto.CouponUsageDto;
import gz.lp.mall.coupon.service.CouponService;
import gz.lp.mall.coupon.service.CouponUsageService;
import gz.lp.mall.inventory.service.InventoryService;
import gz.lp.mall.member.entity.Member;
import gz.lp.mall.member.entity.PointsLog;
import gz.lp.mall.member.mapper.MemberMapper;
import gz.lp.mall.member.service.MemberRentProductService;
import gz.lp.mall.member.service.MemberService;
import gz.lp.mall.member.service.PointsLogService;
import gz.lp.mall.order.entity.StoreOrder;
import gz.lp.mall.order.entity.StoreOrderInfo;
import gz.lp.mall.order.entity.vo.GoodsInfo;
import gz.lp.mall.order.mapper.StoreOrderMapper;
import gz.lp.mall.order.service.StoreOrderInfoService;
import gz.lp.mall.order.service.StoreOrderService;
import gz.lp.mall.product.entity.GoodsSku;
import gz.lp.mall.product.service.GoodsSkuService;
import gz.lp.system.api.domain.PaymentRespVo;
import gz.lp.system.api.domain.dto.OrderInfoDto;
import gz.lp.system.api.domain.param.CouponDetail;
import gz.lp.system.api.domain.param.CreateOrderParam;
import gz.lp.system.api.domain.param.IntegralBuyParam;
import gz.lp.system.api.domain.param.OrderComputedPriceParam;
import gz.lp.system.api.domain.param.PreOrderParams;
import gz.lp.system.api.domain.vo.ComputeOrderPriceRespVo;
import gz.lp.system.api.domain.vo.OrderInfoDetailVo;
import gz.lp.system.api.domain.vo.PreOrderRespVo;
import gz.lp.system.api.domain.vo.RecordVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class StoreOrderServiceImpl
extends ServiceImpl<StoreOrderMapper, StoreOrder>
implements StoreOrderService {
    private static final Logger log = LoggerFactory.getLogger(StoreOrderServiceImpl.class);
    @Autowired
    private ShoppingCartService shoppingCartService;
    @Autowired
    private StoreOrderMapper storeOrderMapper;
    @Autowired
    private StoreOrderInfoService storeOrderInfoService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CouponUsageService couponUsageService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberRentProductService memberRentProductService;
    @Autowired
    private GoodsSkuService goodsSkuService;
    @Autowired
    private InventoryService inventoryService;
    @Autowired
    private WxPayService wxPayService;
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private PointsLogService pointsLogService;

    public RecordVo preOrder(PreOrderParams params) {
        OrderInfoDto orderInfoVo = this.validatePreOrderRequest(params);
        BigDecimal totalPrice = orderInfoVo.getOrderDetailList().values().stream().flatMap(Collection::stream).map(e -> e.getVipPrice().multiply(new BigDecimal(e.getPayNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        orderInfoVo.setProTotalFee(totalPrice);
        int orderProNum = orderInfoVo.getOrderDetailList().values().stream().flatMap(Collection::stream).mapToInt(OrderInfoDetailVo::getPayNum).sum();
        orderInfoVo.setOrderProNum(Integer.valueOf(orderProNum));
        orderInfoVo.setPayFee(orderInfoVo.getProTotalFee());
        String key = SecurityUtils.getLoginUser().getMember().getMemberId() + DateUtils.dateTimeNow() + UUID.randomUUID();
        RedisUtil.set((String)("user_order:" + key), (Object)JSONObject.toJSONString((Object)orderInfoVo), (long)3600L);
        RecordVo record = new RecordVo();
        record.set("preOrderNo", (Object)key);
        return record;
    }

    public PreOrderRespVo loadPreOrder(String preOrderNo) {
        OrderInfoDto orderInfoVo = this.getCachedOrderInfo(preOrderNo);
        PreOrderRespVo preOrderResponse = new PreOrderRespVo();
        preOrderResponse.setOrderInfoVo(orderInfoVo);
        return preOrderResponse;
    }

    public ComputeOrderPriceRespVo computedOrderPrice(OrderComputedPriceParam request) {
        OrderInfoDto orderInfoVo = this.getCachedOrderInfo(request.getPreOrderNo());
        return this.computedPrice(request, orderInfoVo);
    }

    private ComputeOrderPriceRespVo computedPrice(OrderComputedPriceParam request, OrderInfoDto orderInfo) {
        ComputeOrderPriceRespVo response = new ComputeOrderPriceRespVo();
        BigDecimal totalCouponFee = BigDecimal.ZERO;
        this.resetAllCouponPrices(orderInfo);
        if (request.getCouponId() != null) {
            for (Map.Entry entry : request.getCouponId().entrySet()) {
                Integer product_id = (Integer)entry.getKey();
                Integer couponId = (Integer)entry.getValue();
                CouponUsageDto coupon = this.validateAndGetCoupon(couponId);
                totalCouponFee = totalCouponFee.add(this.applyProductCoupon(orderInfo, product_id, coupon));
            }
        }
        BigDecimal proTotalFee = orderInfo.getProTotalFee();
        response.setProTotalFee(proTotalFee);
        response.setPayFee(proTotalFee.subtract(totalCouponFee));
        response.setCouponFee(totalCouponFee);
        return response;
    }

    private CouponUsageDto validateAndGetCoupon(Integer couponId) {
        if (couponId == null || couponId <= 0) {
            throw new ServiceException("\u65e0\u6548\u7684\u4f18\u60e0\u5238ID");
        }
        CouponUsageDto coupon = this.couponService.getCouponUse(couponId);
        if (coupon == null) {
            throw new ServiceException("\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
        }
        Integer currentUserId = SecurityUtils.getLoginUser().getMember().getId();
        if (!currentUserId.equals(coupon.getUserId())) {
            throw new ServiceException("\u6b64\u4f18\u60e0\u5238\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237");
        }
        this.validateCouponStatus(coupon);
        if (coupon.getUsageScope() == 2) {
            if (StringUtils.isBlank((CharSequence)coupon.getLinkId())) {
                throw new ServiceException("\u95e8\u5e97\u5238\u672a\u914d\u7f6e\u9002\u7528\u95e8\u5e97");
            }
        } else if (coupon.getUsageScope() == 3 && StringUtils.isBlank((CharSequence)coupon.getLinkId())) {
            throw new ServiceException("\u5546\u54c1\u5238\u672a\u914d\u7f6e\u9002\u7528\u5546\u54c1");
        }
        if (coupon.getLimitAmount().compareTo(BigDecimal.ZERO) < 0) {
            throw new ServiceException("\u4f18\u60e0\u5238\u914d\u7f6e\u5f02\u5e38\uff1a\u6700\u4f4e\u6d88\u8d39\u91d1\u989d\u65e0\u6548");
        }
        return coupon;
    }

    private void resetAllCouponPrices(OrderInfoDto orderInfo) {
        orderInfo.getOrderDetailList().values().stream().flatMap(Collection::stream).forEach(d -> d.setCouponPrice(BigDecimal.ZERO));
    }

    private BigDecimal applyProductCoupon(OrderInfoDto orderInfo, Integer product_id, CouponUsageDto coupon) {
        AtomicReference<BigDecimal> totalCouponFee = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        orderInfo.getOrderDetailList().values().stream().flatMap(Collection::stream).filter(item -> item.getProductId().equals(product_id)).peek(item -> {
            if (coupon.getCouponType() == 1) {
                item.setCouponPrice(item.getVipPrice().multiply(new BigDecimal(item.getPayNum())).min(coupon.getFaceValue()));
            } else if (coupon.getCouponType() == 2) {
                item.setCouponPrice(item.getVipPrice().multiply(BigDecimal.valueOf(100 - coupon.getDiscount())).divide(BigDecimal.valueOf(100L)));
            }
            totalCouponFee.set(((BigDecimal)totalCouponFee.get()).add(item.getCouponPrice()));
        }).collect(Collectors.toList());
        return totalCouponFee.get();
    }

    private void validateCouponStatus(CouponUsageDto coupon) {
        if (coupon.getIsUse() == 1) {
            throw new ServiceException("\u6b64\u4f18\u60e0\u5238\u5df2\u4f7f\u7528\uff01");
        }
        if (coupon.getCouponStatus() == 0) {
            throw new ServiceException("\u6b64\u4f18\u60e0\u5238\u5df2\u5931\u6548\uff01");
        }
        Date now = DateUtils.getNowDate();
        if (coupon.getStartTime().after(now)) {
            throw new ServiceException("\u4f18\u60e0\u5238\u672a\u5230\u4f7f\u7528\u65f6\u95f4\uff01");
        }
        if (coupon.getEndTime().before(now)) {
            throw new ServiceException("\u4f18\u60e0\u5238\u5df2\u8fc7\u671f\uff01");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public R integralBuy(IntegralBuyParam request) {
        GoodsInfo goodsSku = this.goodsSkuService.getGoodsInfo(request.getSkuId(), request.getStoreId());
        if (goodsSku.getIntegralRatio() > 0) {
            if (goodsSku.getStock() < request.getNum()) {
                throw new ServiceException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
            }
            Integer integral = goodsSku.getPrice().multiply(new BigDecimal(request.getNum())).multiply(new BigDecimal(goodsSku.getIntegralRatio())).divide(new BigDecimal(10)).setScale(0, RoundingMode.HALF_UP).intValue();
            BigDecimal payPrice = goodsSku.getPrice().subtract(new BigDecimal(integral).divide(BigDecimal.TEN)).setScale(2, RoundingMode.HALF_UP);
            Member member = this.memberMapper.selectForUpdate(SecurityUtils.getLoginUser().getMember().getId());
            if (member.getPoints() < integral) {
                throw new ServiceException("\u79ef\u5206\u4e0d\u8db3");
            }
            StoreOrder storeOrder = StoreOrder.builder().orderId(IdUtil.getSnowflake().nextIdStr()).mid(member.getId()).createTime(new Date()).totalNum(request.getNum()).totalPrice(payPrice).payPrice(payPrice).build();
            this.storeOrderMapper.insert((Object)storeOrder);
            StoreOrderInfo storeOrderInfo = StoreOrderInfo.builder().orderId(storeOrder.getId()).memberId(member.getId()).productId(goodsSku.getGoodsId()).createTime(new Date()).updateTime(new Date()).orderNo(storeOrder.getOrderId()).productName(goodsSku.getGoodsName()).attrValueId(goodsSku.getSkuId()).image(goodsSku.getImageUrl()).specValue(goodsSku.getSpecValue()).price(goodsSku.getPrice()).payNum(request.getNum()).vipPrice(payPrice.divide(new BigDecimal(request.getNum())).setScale(2, RoundingMode.HALF_UP)).storeId(request.getStoreId()).verifyCode(this.generateVerifyCodes()).inventoryId(goodsSku.getId()).useIntegral(integral).isPay(Integer.valueOf(0)).userName(member.getNickname()).userPhone(member.getPhone()).productType(Integer.valueOf(2)).storeName(goodsSku.getStoreName()).build();
            this.storeOrderInfoService.save((Object)storeOrderInfo);
            Integer oldPoints = member.getPoints();
            member.setPoints(Integer.valueOf(member.getPoints() - integral));
            this.memberMapper.updateById((Object)member);
            PointsLog pointsLog = PointsLog.builder().oldPoints(oldPoints).newPoints(member.getPoints()).memberId(member.getId()).changeAmount(Integer.valueOf(integral * -1)).changeType(PointChangeTypeEnum.EXCHANGE.getCode()).build();
            this.pointsLogService.addPointsLog(pointsLog);
            CreateOrderReq createOrderReq = new CreateOrderReq();
            createOrderReq.setTotal(storeOrderInfo.getPayNum());
            createOrderReq.setWxOpenId(SecurityUtils.getLoginUser().getMember().getOpenId());
            createOrderReq.setDescription(storeOrderInfo.getProductName() + "\u5546\u54c1\u8d2d\u4e70");
            createOrderReq.setOutTradeNo(storeOrder.getOrderId());
            return this.wxPayService.createOrder(createOrderReq);
        }
        throw new ServiceException("\u6b64\u5546\u54c1\u4e0d\u652f\u6301\u79ef\u5206\u8d2d\u4e70");
    }

    public PaymentRespVo createOrder(CreateOrderParam request) {
        List storeOrderInfos;
        request.setPayType(Integer.valueOf(1));
        OrderInfoDto orderInfoVo = this.getCachedOrderInfo(request.getPreOrderNo());
        List skuRecordList = this.validateProductStock(orderInfoVo);
        OrderComputedPriceParam orderComputedPriceRequest = new OrderComputedPriceParam();
        if (ObjectUtil.isNotNull((Object)request.getCouponDetail())) {
            orderComputedPriceRequest.setCouponId(request.getCouponDetail().stream().collect(Collectors.toMap(CouponDetail::getProductId, CouponDetail::getCouponId)));
        }
        orderComputedPriceRequest.setPayType(request.getPayType());
        ComputeOrderPriceRespVo priceResponse = this.computedPrice(orderComputedPriceRequest, orderInfoVo);
        String orderNo = IdUtils.getInstance().nextId().toString();
        StoreOrder storeOrder = this.buildStoreOrder(orderInfoVo, priceResponse, request, orderNo);
        List finalStoreOrderInfos = storeOrderInfos = this.buildOrderDetails(orderInfoVo, orderNo);
        PaymentRespVo paymentRespVo = new PaymentRespVo();
        Boolean transactionResult = (Boolean)this.transactionTemplate.execute(status -> {
            Map<Integer, Integer> couponMap;
            this.memberService.buyGoodsAfter(SecurityUtils.getLoginUser().getMember().getId(), Integer.valueOf(0), priceResponse.getBalance(), storeOrder.getOrderId());
            if (request.getPayType() == 0) {
                storeOrder.setPayTime(new Date());
            }
            if (orderInfoVo.getRenew() == null) {
                skuRecordList.forEach(record -> {
                    if (!this.inventoryService.operationStock(record.getInt("inventoryId"), record.getInt("num"), "sub")) {
                        throw new ServiceException("\u66f4\u65b0\u5e93\u5b58\u5931\u8d25");
                    }
                });
            }
            this.save((Object)storeOrder);
            finalStoreOrderInfos.forEach(info -> {
                info.setOrderId(storeOrder.getId());
                info.setIsPay(storeOrder.getPaid());
                info.setStatus(Integer.valueOf(1));
                info.setPayTime(storeOrder.getPayTime());
            });
            this.storeOrderInfoService.saveBatch((Collection)finalStoreOrderInfos);
            if (ObjectUtil.isNotNull((Object)request.getCouponDetail()) && CollUtil.isNotEmpty(couponMap = request.getCouponDetail().stream().collect(Collectors.toMap(CouponDetail::getProductId, CouponDetail::getCouponId)))) {
                couponMap.values().stream().distinct().forEach(couponId -> {
                    CouponUsage couponUsage = this.handleCouponUsage(couponId);
                    this.couponUsageService.updateById((Object)couponUsage);
                });
            }
            if (CollUtil.isNotEmpty((Collection)orderInfoVo.getCartIdList())) {
                this.shoppingCartService.deleteCartByIds(orderInfoVo.getCartIdList());
            }
            paymentRespVo.setId(storeOrder.getId());
            paymentRespVo.setOutTradeNo(orderNo);
            paymentRespVo.setTotalPrice(Integer.valueOf(storeOrder.getPayPrice().multiply(BigDecimal.valueOf(100L)).intValue()));
            return true;
        });
        if (Boolean.FALSE.equals(transactionResult)) {
            log.error("\u8ba2\u5355\u521b\u5efa\u5931\u8d25\uff0c\u9884\u8ba2\u5355\u53f7\uff1a" + request.getPreOrderNo());
            throw new ServiceException("\u8ba2\u5355\u751f\u6210\u5931\u8d25");
        }
        RedisUtil.del((String[])new String[]{"user_order:" + request.getPreOrderNo()});
        paymentRespVo.setPayType(request.getPayType());
        return paymentRespVo;
    }

    private OrderInfoDto validatePreOrderRequest(PreOrderParams request) {
        OrderInfoDto orderInfoDto = new OrderInfoDto();
        HashMap<Integer, ArrayList<OrderInfoDetailVo>> detailVoList = null;
        if ("shoppingCart".equals(request.getPreOrderType())) {
            detailVoList = this.validatePreOrderShopping(request);
            List cartIdList = request.getShoppingCartId().stream().distinct().collect(Collectors.toList());
            orderInfoDto.setCartIdList(cartIdList);
        }
        if ("buyNow".equals(request.getPreOrderType())) {
            if (ObjectUtil.isNull((Object)request.getProductId())) {
                throw new ServiceException("\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            GoodsSku goodsSku = (GoodsSku)this.goodsSkuService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(GoodsSku.class).eq(GoodsSku::getSkuValueIds, (Object)request.getSkuValueIds())).eq(GoodsSku::getGoodsId, (Object)request.getProductId())).last(" limit 1"));
            if (goodsSku == null) {
                throw new ServiceException("\u5546\u54c1\u89c4\u683c\u4e0d\u5b58\u5728");
            }
            request.setSpecId(goodsSku.getId());
            if (ObjectUtil.isNull((Object)request.getSpecId())) {
                throw new ServiceException("\u5546\u54c1\u89c4\u683c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a [\u5546\u54c1:" + request.getProductId() + "]");
            }
            if (ObjectUtil.isNull((Object)request.getProductNum()) || request.getProductNum() < 0) {
                throw new ServiceException("\u8d2d\u4e70\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0 [\u5546\u54c1:" + request.getProductId() + "]");
            }
            GoodsInfo storeProduct = this.goodsSkuService.getGoodsInfo(request.getSpecId(), request.getStoreId());
            this.validateProduct(storeProduct, request);
            this.validateProductInventory(storeProduct, request.getProductNum());
            OrderInfoDetailVo detailVo = this.createOrderDetailVo(storeProduct, request.getProductNum());
            detailVo.setStoreId(request.getStoreId());
            ArrayList<OrderInfoDetailVo> detailList = new ArrayList<OrderInfoDetailVo>();
            detailList.add(detailVo);
            detailVoList = new HashMap<Integer, ArrayList<OrderInfoDetailVo>>();
            detailVoList.put(request.getStoreId(), detailList);
        }
        if ("again".equals(request.getPreOrderType())) {
            detailVoList = this.validatePreOrderAgain(request);
            orderInfoDto.setOrderDetailList((Map)detailVoList);
        }
        if ("renew".equals(request.getPreOrderType())) {
            detailVoList = this.validatePreOrderAgain(request);
            orderInfoDto.setRenew(Integer.valueOf(1));
        }
        orderInfoDto.setOrderDetailList((Map)detailVoList);
        return orderInfoDto;
    }

    private Map<Integer, List<OrderInfoDetailVo>> validatePreOrderShopping(PreOrderParams request) {
        return request.getShoppingCartId().stream().map(cartId -> {
            if (ObjectUtil.isNull((Object)cartId)) {
                throw new ServiceException("\u8d2d\u7269\u8f66\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ShoppingCart storeCart = this.shoppingCartService.getByIdAndMid(cartId, SecurityUtils.getLoginUser().getMember().getId());
            if (ObjectUtil.isNull((Object)storeCart)) {
                throw new ServiceException(String.format("\u672a\u627e\u5230\u8d2d\u7269\u8f66\u4fe1\u606f [ \u8d2d\u7269\u8f66ID:%d]", cartId));
            }
            GoodsInfo storeProduct = this.goodsSkuService.getGoodsInfo(storeCart.getSpecId(), storeCart.getStoreId());
            this.validateProduct(storeProduct, request);
            this.validateProductInventory(storeProduct, storeCart.getQuantity());
            OrderInfoDetailVo detailVo = this.createOrderDetailVo(storeProduct, storeCart.getQuantity());
            detailVo.setStoreId(storeCart.getStoreId());
            return detailVo;
        }).toList().stream().collect(Collectors.groupingBy(OrderInfoDetailVo::getStoreId));
    }

    private Map<Integer, List<OrderInfoDetailVo>> validatePreOrderAgain(PreOrderParams request) {
        String orderNo = request.getOrderNo();
        if (StrUtil.isBlank((CharSequence)orderNo)) {
            throw new ServiceException("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StoreOrder storeOrder = this.getByOrderId(orderNo);
        return this.storeOrderInfoService.getVoListByOrderId(storeOrder.getId()).stream().map(e -> {
            OrderInfoDetailVo detailVo = e.getInfo();
            GoodsInfo storeProduct = this.goodsSkuService.getGoodsInfo(detailVo.getProductId(), request.getStoreId());
            this.validateProduct(storeProduct, request);
            this.validateProductInventory(storeProduct, detailVo.getPayNum());
            OrderInfoDetailVo newDetail = this.createOrderDetailVo(storeProduct, detailVo.getPayNum());
            newDetail.setStoreId(e.getStoreId());
            return newDetail;
        }).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(OrderInfoDetailVo::getStoreId));
    }

    public StoreOrder getByOrderId(String orderId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(StoreOrder::getOrderId, (Object)orderId);
        StoreOrder storeOrder = (StoreOrder)this.storeOrderMapper.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)storeOrder)) {
            throw new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (storeOrder.getIsDel() == 1) {
            throw new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        return storeOrder;
    }

    private void validateProduct(GoodsInfo product, PreOrderParams request) {
        if (ObjectUtil.isNull((Object)product)) {
            throw new ServiceException("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        if (product.getIsDelete() == 1) {
            throw new ServiceException("\u5546\u54c1\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        if (product.getStatus() == 0) {
            throw new ServiceException("\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        if (product.getPeriodicityDay() > 0 && request != null && !"renew".equals(request.getPreOrderType()) && this.memberRentProductService.checkRentProductNoBack(SecurityUtils.getLoginUser().getMember().getId())) {
            throw new ServiceException("\u60a8\u6709\u4e00\u7b14\u79df\u8d41\u5546\u54c1\u672a\u5f52\u8fd8\uff0c\u8bf7\u5148\u5f52\u8fd8\u518d\u4e0b\u5355");
        }
    }

    private void validateProductInventory(GoodsInfo product, Integer requiredNum) {
        if (ObjectUtil.isNull((Object)product)) {
            throw new ServiceException("\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        if (product.getStock() < requiredNum) {
            throw new ServiceException("\u5546\u54c1\u89c4\u683c\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9");
        }
        if (product.getPeriodicityDay() > 0 && requiredNum > 1) {
            throw new ServiceException(product.getGoodsName() + "\u53ea\u5141\u8bb8\u4e0b\u5355\u4e00\u4ef6\uff01");
        }
    }

    private OrderInfoDetailVo createOrderDetailVo(GoodsInfo product, Integer payNum) {
        Member member;
        OrderInfoDetailVo detailVo = new OrderInfoDetailVo();
        detailVo.setProductId(product.getGoodsId());
        detailVo.setProductName(product.getGoodsName());
        detailVo.setSpecId(product.getSkuId());
        detailVo.setInventoryId(product.getId());
        detailVo.setPrice(product.getPrice());
        detailVo.setStoreId(product.getStoreId());
        detailVo.setVipPrice(product.getPrice());
        detailVo.setStoreName(product.getStoreName());
        if (product.getVipRatio() > 0 && (member = (Member)this.memberMapper.selectById((Serializable)SecurityUtils.getLoginUser().getMember().getId())).getIsVip() == 1) {
            detailVo.setVipPrice(product.getPrice().multiply(new BigDecimal(product.getVipRatio())).divide(BigDecimal.valueOf(100L)));
        }
        detailVo.setSpecValue(product.getSpecValue());
        detailVo.setPayNum(payNum);
        detailVo.setIsPeriodicity(Integer.valueOf(product.getPeriodicityDay() > 0 ? 1 : 0));
        detailVo.setPeriodicityDay(product.getPeriodicityDay());
        detailVo.setImage(product.getImageUrl());
        detailVo.setParticipate(Boolean.valueOf(product.getScaleRatio() > 0));
        detailVo.setPushType(product.getPushType());
        detailVo.setGiveIntegral(Integer.valueOf(this.calculateGiveIntegral(product, product.getPrice().multiply(BigDecimal.valueOf(payNum.intValue())))));
        return detailVo;
    }

    private int calculateGiveIntegral(GoodsInfo product, BigDecimal price) {
        if (product.getScaleRatio() == 0) {
            return 0;
        }
        return price.multiply(new BigDecimal(product.getScaleRatio())).divide(BigDecimal.valueOf(100L), 0, RoundingMode.HALF_UP).intValue();
    }

    private List<RecordVo> validateProductStock(OrderInfoDto orderInfoVo) {
        ArrayList recordList = CollUtil.newArrayList((Object[])new RecordVo[0]);
        orderInfoVo.getOrderDetailList().forEach((storeId, details) -> details.forEach(detail -> {
            GoodsInfo storeProduct = this.goodsSkuService.getGoodsInfo(detail.getSpecId(), storeId);
            this.validateProduct(storeProduct, null);
            this.validateProductInventory(storeProduct, detail.getPayNum());
            RecordVo record = new RecordVo();
            record.set("productId", (Object)detail.getProductId());
            record.set("num", (Object)detail.getPayNum());
            record.set("inventoryId", (Object)storeProduct.getId());
            record.set("attrValueId", (Object)detail.getSpecId());
            recordList.add(record);
        }));
        return recordList;
    }

    private OrderInfoDto getCachedOrderInfo(String preOrderNo) {
        String key = "user_order:" + preOrderNo;
        String orderJson = Optional.ofNullable(RedisUtil.get((String)key)).orElseThrow(() -> new ServiceException("\u9884\u8ba2\u5355\u4e0d\u5b58\u5728")).toString();
        return (OrderInfoDto)JSON.parseObject((String)orderJson, OrderInfoDto.class);
    }

    private StoreOrder buildStoreOrder(OrderInfoDto orderInfoVo, ComputeOrderPriceRespVo priceResponse, CreateOrderParam request, String orderNo) {
        StoreOrder order = new StoreOrder();
        order.setOrderId(orderNo);
        order.setMid(Integer.valueOf(1));
        order.setTotalNum(orderInfoVo.getOrderProNum());
        order.setTotalPrice(priceResponse.getProTotalFee());
        order.setPayPrice(priceResponse.getPayFee());
        order.setCreateTime(DateUtils.formatDate((String)DateUtils.getTime()));
        order.setPaid(Integer.valueOf(0));
        return order;
    }

    private List<StoreOrderInfo> buildOrderDetails(OrderInfoDto orderInfoVo, String orderNo) {
        return orderInfoVo.getOrderDetailList().entrySet().stream().flatMap(entry -> {
            Integer storeId = (Integer)entry.getKey();
            List details = (List)entry.getValue();
            return details.stream().map(detail -> {
                StoreOrderInfo info = new StoreOrderInfo();
                info.setProductId(detail.getProductId());
                info.setMemberId(SecurityUtils.getLoginUser().getMember().getId());
                info.setIsPeriodicity(detail.getIsPeriodicity());
                info.setInventoryId(detail.getInventoryId());
                info.setInfo(JSON.toJSONString((Object)detail));
                info.setOrderNo(orderNo);
                info.setIsPay(Integer.valueOf(0));
                info.setStatus(Integer.valueOf(1));
                info.setPeriodicityDay(detail.getPeriodicityDay());
                info.setProductName(detail.getProductName());
                info.setAttrValueId(detail.getSpecId());
                info.setSpecValue(detail.getSpecValue());
                info.setImage(detail.getImage());
                info.setCouponPrice(detail.getCouponPrice());
                info.setPrice(detail.getPrice());
                info.setStoreId(storeId);
                info.setStoreName(detail.getStoreName());
                info.setGiveIntegral(Optional.ofNullable(detail.getGiveIntegral()).orElse(0));
                info.setUseIntegral(Optional.ofNullable(detail.getUseIntegral()).orElse(0));
                info.setVerifyCode(this.generateVerifyCodes());
                info.setPayNum(detail.getPayNum());
                BigDecimal price = Optional.ofNullable(detail.getVipPrice()).orElse(detail.getPrice());
                info.setVipPrice(price);
                info.setPayPrice(price.multiply(BigDecimal.valueOf(detail.getPayNum().intValue())).subtract(detail.getCouponPrice()));
                return info;
            });
        }).collect(Collectors.toList());
    }

    private CouponUsage handleCouponUsage(Integer couponId) {
        if (couponId == null || couponId <= 0) {
            return CouponUsage.builder().build();
        }
        CouponUsage couponUsage = this.couponUsageService.getByCouponUsageId(couponId, SecurityUtils.getLoginUser().getMember().getId());
        if (couponUsage == null) {
            throw new ServiceException("\u4f18\u60e0\u5238\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        couponUsage.setIsUse(Integer.valueOf(1));
        couponUsage.setUseTime(DateUtils.getTime());
        return couponUsage;
    }

    private String generateVerifyCodes() {
        return UUID.randomUUID().toString().substring(0, 8);
    }
}

