/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.order.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.nacos.common.utils.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.wechat.pay.java.service.payments.model.Transaction;
import com.wechat.pay.java.service.refund.model.RefundNotification;
import gz.lp.common.core.api.R;
import gz.lp.common.core.enums.enumeration.PointChangeTypeEnum;
import gz.lp.common.core.enums.order.OrderRefundEnum;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.IdUtils;
import gz.lp.common.pay.config.CreateOrderReq;
import gz.lp.common.pay.service.WxPayService;
import gz.lp.common.pay.vo.RefundVo;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.mall.member.entity.Member;
import gz.lp.mall.member.entity.MemberPointsFrozen;
import gz.lp.mall.member.entity.MemberRentProduct;
import gz.lp.mall.member.entity.PointsLog;
import gz.lp.mall.member.mapper.MemberMapper;
import gz.lp.mall.member.service.MemberPointsFrozenService;
import gz.lp.mall.member.service.MemberRentProductService;
import gz.lp.mall.member.service.MemberService;
import gz.lp.mall.member.service.PointsLogService;
import gz.lp.mall.order.entity.OrderRefundInfo;
import gz.lp.mall.order.entity.StoreOrder;
import gz.lp.mall.order.entity.StoreOrderInfo;
import gz.lp.mall.order.entity.params.RefundListSearchParam;
import gz.lp.mall.order.entity.params.RefundParam;
import gz.lp.mall.order.entity.vo.RefundListVo;
import gz.lp.mall.order.entity.vo.StoreOrderInfoRespVo;
import gz.lp.mall.order.mapper.StoreOrderInfoMapper;
import gz.lp.mall.order.mapper.StoreOrderMapper;
import gz.lp.mall.order.service.OrderRefundInfoService;
import gz.lp.mall.order.service.StoreOrderInfoService;
import gz.lp.system.api.domain.QueryByIdVo;
import gz.lp.system.api.domain.param.IdPrams;
import gz.lp.system.api.domain.param.StoreOrderInfoListParams;
import gz.lp.system.api.domain.param.TypeParam;
import gz.lp.system.api.domain.vo.AppletOrderInfoDetailVo;
import gz.lp.system.api.domain.vo.OrderInfoDetailVo;
import gz.lp.system.api.domain.vo.StoreOrderInfoVo;
import gz.lp.system.api.vo.RefundStatusVo;
import gz.lp.system.api.vo.RejectRefundVo;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class StoreOrderInfoServiceImpl
extends ServiceImpl<StoreOrderInfoMapper, StoreOrderInfo>
implements StoreOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(StoreOrderInfoServiceImpl.class);
    @Autowired
    private StoreOrderInfoMapper mapper;
    @Autowired
    private StoreOrderMapper storeOrderMapper;
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private MemberRentProductService memberRentProductService;
    @Autowired
    private MemberPointsFrozenService memberPointsFrozenService;
    @Autowired
    private OrderRefundInfoService orderRefundInfoService;
    @Autowired
    private WxPayService wxPayService;
    @Autowired
    private StoreOrderInfoMapper storeOrderInfoMapper;
    @Autowired
    private MemberService memberService;
    @Autowired
    private PointsLogService pointsLogService;

    public List<StoreOrderInfoVo> getVoListByOrderId(Integer orderId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(StoreOrderInfo::getOrderId, (Object)orderId);
        List systemStoreStaffList = this.mapper.selectList((Wrapper)lambdaQueryWrapper);
        if (systemStoreStaffList.size() < 1) {
            return null;
        }
        ArrayList<StoreOrderInfoVo> storeOrderInfoVoList = new ArrayList<StoreOrderInfoVo>();
        for (StoreOrderInfo storeOrderInfo : systemStoreStaffList) {
            StoreOrderInfoVo storeOrderInfoVo = new StoreOrderInfoVo();
            BeanUtils.copyProperties((Object)storeOrderInfo, (Object)storeOrderInfoVo, (String[])new String[]{"info"});
            storeOrderInfoVo.setInfo((OrderInfoDetailVo)JSON.parseObject((String)storeOrderInfo.getInfo(), OrderInfoDetailVo.class));
            storeOrderInfoVoList.add(storeOrderInfoVo);
        }
        return storeOrderInfoVoList;
    }

    public Page<StoreOrderInfoRespVo> getOrderList(StoreOrderInfoListParams vo) {
        MPJLambdaWrapper wrapper = (MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper(StoreOrderInfo.class).selectAll(StoreOrderInfo.class)).eq(StringUtils.isNotBlank((String)vo.getOrder()), StoreOrderInfo::getOrderNo, (Object)vo.getOrder())).eq(StringUtils.isNotBlank((String)vo.getCode()), StoreOrderInfo::getVerifyCode, (Object)vo.getCode())).eq(StringUtils.isNotBlank((String)vo.getPhone()), StoreOrderInfo::getUserPhone, (Object)vo.getPhone())).eq(StoreOrderInfo::getIsPay, (Object)1)).orderByDesc(StoreOrderInfo::getCreateTime);
        if (!SecurityUtils.isAdmin((Long)SecurityUtils.getLoginUser().getUserid())) {
            wrapper.eq(StoreOrderInfo::getStoreId, (Object)SecurityUtils.getLoginUser().getSysUser().getDeptId());
        }
        return (Page)this.mapper.selectJoinPage((IPage)new Page((long)vo.getPageNo().intValue(), (long)vo.getPageSize().intValue()), StoreOrderInfoRespVo.class, (MPJBaseJoin)wrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public R takeOrder(IdPrams prams) {
        StoreOrderInfo storeOrderInfo = (StoreOrderInfo)this.mapper.selectById((Serializable)prams.getId());
        if (storeOrderInfo != null) {
            if (storeOrderInfo.getStatus() == 5) {
                return R.failed((String)"\u8be5\u5546\u54c1\u7533\u8bf7\u9000\u6b3e\u4e2d");
            }
            if (storeOrderInfo.getStatus() == 4) {
                return R.failed((String)"\u8be5\u5546\u54c1\u5df2\u9000\u8d27");
            }
            if (storeOrderInfo.getClerkId() != null) {
                return R.failed((String)"\u8be5\u5546\u54c1\u5df2\u53d6\u4ef6");
            }
            storeOrderInfo.setClerkId(Integer.valueOf(SecurityUtils.getLoginUser().getSysUser().getUserId().intValue()));
            storeOrderInfo.setClerkTime(new Date());
            storeOrderInfo.setIsPay(Integer.valueOf(1));
            storeOrderInfo.setStatus(Integer.valueOf(3));
            storeOrderInfo.setIsFinish(Integer.valueOf(1));
            if (storeOrderInfo.getProductType() != 2) {
                Member member = this.memberMapper.selectForUpdate(storeOrderInfo.getMemberId());
                BigDecimal payPrice = storeOrderInfo.getVipPrice().multiply(BigDecimal.valueOf(storeOrderInfo.getPayNum().intValue())).subtract(storeOrderInfo.getCouponPrice());
                Integer integral = payPrice.intValue();
                if (integral > 0) {
                    member.setFrozenPoints(Integer.valueOf(member.getFrozenPoints() + integral));
                }
                MemberPointsFrozen mpz = new MemberPointsFrozen();
                mpz.setBackIntegral(integral);
                mpz.setMemberId(member.getId());
                mpz.setStoreOrderInfoId(storeOrderInfo.getId());
                mpz.setBuyNum(storeOrderInfo.getPayNum());
                mpz.setCreateTime(new Date());
                this.memberPointsFrozenService.save((Object)mpz);
                PointsLog pointsLog = PointsLog.builder().oldPoints(member.getPoints()).newPoints(Integer.valueOf(member.getPoints() + integral)).memberId(member.getId()).changeAmount(integral).changeType(PointChangeTypeEnum.CONSUME.getCode()).build();
                this.pointsLogService.addPointsLog(pointsLog);
                this.dealIntegral(storeOrderInfo);
                if (storeOrderInfo.getIsPeriodicity() != null && storeOrderInfo.getIsPeriodicity() == 1) {
                    DateTime date = DateUtil.date();
                    storeOrderInfo.setRentStartTime((Date)date);
                    storeOrderInfo.setRentEndTime((Date)DateUtil.offsetDay((Date)date, (int)storeOrderInfo.getPeriodicityDay()));
                    this.memberRentProductService.dealRentProduct(storeOrderInfo);
                }
                this.memberMapper.updateById((Object)member);
            }
            this.mapper.updateById((Object)storeOrderInfo);
            return R.ok();
        }
        return R.failed();
    }

    @Transactional(rollbackFor={Exception.class})
    public R refund(RefundParam prams) {
        StoreOrderInfo storeOrderInfo = (StoreOrderInfo)this.mapper.selectById((Serializable)prams.getId());
        if (storeOrderInfo == null) {
            return R.failed((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        int payNum = storeOrderInfo.getPayNum();
        if (prams.getRefundNum() > payNum) {
            return R.failed((String)"\u9000\u6b3e\u6570\u91cf\u9519\u8bef");
        }
        storeOrderInfo.setRefundNum(Integer.valueOf(prams.getRefundNum() + storeOrderInfo.getRefundNum()));
        BigDecimal refundPrice = this.computeRefundPrice(prams);
        storeOrderInfo.setRefundPrice(storeOrderInfo.getRefundPrice().add(refundPrice));
        if (prams.getRefundNum() + storeOrderInfo.getRefundNum() == storeOrderInfo.getPayNum()) {
            storeOrderInfo.setIsRefund(Integer.valueOf(2));
        } else {
            storeOrderInfo.setIsRefund(Integer.valueOf(1));
        }
        storeOrderInfo.setStatus(Integer.valueOf(4));
        Integer backIntegral = storeOrderInfo.getPrice().multiply(BigDecimal.valueOf(prams.getRefundNum().intValue())).setScale(0, RoundingMode.DOWN).intValue();
        Integer totalIntegral = storeOrderInfo.getPrice().multiply(BigDecimal.valueOf(storeOrderInfo.getPayNum().intValue())).setScale(0, RoundingMode.DOWN).intValue();
        if (storeOrderInfo.getBackIntegral() + backIntegral > totalIntegral) {
            backIntegral = totalIntegral - storeOrderInfo.getBackIntegral();
        }
        storeOrderInfo.setBackIntegral(Integer.valueOf(storeOrderInfo.getBackIntegral() + backIntegral));
        this.updateById((Object)storeOrderInfo);
        if (Objects.equals(prams.getRefundNum(), storeOrderInfo.getPayNum())) {
            this.memberPointsFrozenService.remove((Wrapper)new LambdaUpdateWrapper().eq(MemberPointsFrozen::getStoreOrderInfoId, (Object)storeOrderInfo.getId()));
        } else {
            this.memberPointsFrozenService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().setSql(String.format("back_integral = back_integral - %d", prams.getRefundNum() * storeOrderInfo.getGiveIntegral()), new Object[0])).eq(MemberPointsFrozen::getStoreOrderInfoId, (Object)storeOrderInfo.getId()));
        }
        Member member = this.memberMapper.selectForUpdate(storeOrderInfo.getMemberId());
        member.setFrozenPoints(Integer.valueOf(member.getFrozenPoints() - backIntegral));
        this.memberMapper.updateById((Object)member);
        Member parent = (Member)this.memberMapper.selectById((Serializable)member.getManagerId());
        if (parent != null) {
            parent.setFrozenPoints(Integer.valueOf(parent.getFrozenPoints() - storeOrderInfo.getGiveIntegral() * prams.getRefundNum()));
            this.memberMapper.updateById((Object)parent);
        }
        this.memberRentProductService.remove((Wrapper)new LambdaUpdateWrapper().eq(MemberRentProduct::getStoreId, (Object)storeOrderInfo.getId()));
        StoreOrder storeOrder = (StoreOrder)this.storeOrderMapper.selectById((Serializable)storeOrderInfo.getOrderId());
        OrderRefundInfo orderRefundInfo = new OrderRefundInfo();
        orderRefundInfo.setRefundPrice(refundPrice);
        orderRefundInfo.setStoreOrderInfoId(storeOrderInfo.getId());
        orderRefundInfo.setOperId(Integer.valueOf(SecurityUtils.getLoginUser().getUserid().intValue()));
        orderRefundInfo.setCreateTime(new Date());
        orderRefundInfo.setRefundNum(prams.getRefundNum());
        this.orderRefundInfoService.save((Object)orderRefundInfo);
        RefundVo refundVo = new RefundVo();
        refundVo.setOutTradeNo(storeOrderInfo.getOrderNo());
        refundVo.setOutRefundNo(storeOrderInfo.getRefundOrder());
        refundVo.setRefundAmount(refundPrice);
        refundVo.setTotalAmount(storeOrder.getPayPrice());
        R refund = this.wxPayService.createRefund(refundVo);
        if (refund.getCode() == 200L) {
            return R.ok();
        }
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        return R.failed((String)refund.getMsg());
    }

    public BigDecimal computeRefundPrice(RefundParam params) {
        StoreOrderInfo storeOrderInfo = (StoreOrderInfo)this.mapper.selectById((Serializable)params.getId());
        if (params.getRefundNum() > storeOrderInfo.getPayNum()) {
            throw new ServiceException("\u9000\u8d27\u6570\u91cf\u9519\u8bef");
        }
        if (params.getRefundNum() + storeOrderInfo.getRefundNum() == storeOrderInfo.getPayNum()) {
            return storeOrderInfo.getVipPrice().multiply(new BigDecimal(storeOrderInfo.getPayNum())).subtract(storeOrderInfo.getCouponPrice()).subtract(storeOrderInfo.getRefundPrice());
        }
        BigDecimal couponPriceUnit = storeOrderInfo.getCouponPrice().divide(new BigDecimal(storeOrderInfo.getPayNum()), 2, RoundingMode.HALF_UP);
        return new BigDecimal(params.getRefundNum()).multiply(storeOrderInfo.getVipPrice().subtract(couponPriceUnit));
    }

    private void dealIntegral(StoreOrderInfo storeOrderInfo) {
        Member member;
        if (storeOrderInfo.getGiveIntegral() > 0 && storeOrderInfo.getIsPeriodicity() != null && storeOrderInfo.getIsPeriodicity() == 1 && (member = (Member)this.memberMapper.selectById((Serializable)storeOrderInfo.getMemberId())).getManagerId() != null && member.getManagerId() > 0 && this.memberRentProductService.hasRentProduct(member.getManagerId(), storeOrderInfo.getProductId())) {
            Member manager = this.memberMapper.selectForUpdate(member.getManagerId());
            Integer originIntegral = manager.getFrozenPoints();
            manager.setFrozenPoints(Integer.valueOf(manager.getFrozenPoints() + storeOrderInfo.getGiveIntegral() * storeOrderInfo.getPayNum()));
            this.memberMapper.updateById((Object)manager);
            MemberPointsFrozen mpz = new MemberPointsFrozen();
            mpz.setBackIntegral(Integer.valueOf(storeOrderInfo.getGiveIntegral() * storeOrderInfo.getPayNum()));
            mpz.setMemberId(manager.getId());
            mpz.setStoreOrderInfoId(storeOrderInfo.getId());
            mpz.setBuyNum(storeOrderInfo.getPayNum());
            mpz.setCreateTime(new Date());
            this.memberPointsFrozenService.save((Object)mpz);
            PointsLog pointsLog = PointsLog.builder().oldPoints(manager.getPoints()).newPoints(Integer.valueOf(manager.getPoints() + storeOrderInfo.getGiveIntegral())).memberId(manager.getId()).changeAmount(storeOrderInfo.getGiveIntegral()).changeType(PointChangeTypeEnum.SHARE.getCode()).build();
            this.pointsLogService.addPointsLog(pointsLog);
            log.info("\u7528\u6237{}\u4e0b\u7ea7{}\u7ed9\u4ed6\u8d5a\u53d6\u79ef\u5206{}\uff0c\u5df2\u5b58\u5165\u51bb\u7ed3\u79ef\u5206\uff0c\u539f\u51bb\u7ed3\u79ef\u5206{}\uff0c\u73b0\u51bb\u7ed3\u79ef\u5206{}", new Object[]{manager.getId(), member.getId(), storeOrderInfo.getGiveIntegral(), originIntegral, manager.getFrozenPoints()});
        }
    }

    public StoreOrderInfoRespVo getDetail(IdPrams vo) {
        MPJLambdaWrapper wrapper = (MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper(StoreOrderInfo.class).selectAll(StoreOrderInfo.class)).eq(StoreOrderInfo::getId, (Object)vo.getId());
        if (!SecurityUtils.isAdmin((Long)SecurityUtils.getLoginUser().getUserid())) {
            wrapper.eq(StoreOrderInfo::getStoreId, (Object)SecurityUtils.getLoginUser().getSysUser().getDeptId());
        }
        return (StoreOrderInfoRespVo)this.mapper.selectJoinOne(StoreOrderInfoRespVo.class, (MPJBaseJoin)wrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public R backProduct(IdPrams vo) {
        StoreOrderInfo storeOrderInfo = (StoreOrderInfo)this.mapper.selectById((Serializable)vo.getId());
        if (storeOrderInfo == null) {
            return R.failed((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (storeOrderInfo.getIsBack() == 1) {
            return R.failed((String)"\u8be5\u5546\u54c1\u5df2\u9000\u8d27");
        }
        if (storeOrderInfo.getIsRefund() > 0) {
            return R.failed((String)"\u8be5\u5546\u54c1\u5df2\u9000\u6b3e");
        }
        if (storeOrderInfo.getIsPeriodicity() != 1 || storeOrderInfo.getProductType() != 1) {
            return R.failed((String)"\u8be5\u5546\u54c1\u4e0d\u662f\u5468\u671f\u5546\u54c1\uff0c\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
        storeOrderInfo.setIsBack(Integer.valueOf(1));
        storeOrderInfo.setIsFinish(Integer.valueOf(1));
        this.memberRentProductService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(MemberRentProduct::getStoreId, (Object)storeOrderInfo.getId())).set(MemberRentProduct::getBackTime, (Object)new Date()));
        if (this.mapper.updateById((Object)storeOrderInfo) > 0) {
            this.finishIntegral(storeOrderInfo.getId());
            return R.ok();
        }
        return R.failed();
    }

    @Transactional(rollbackFor={Exception.class})
    public void finishIntegral(Integer orderInfoId) {
        List mpz = this.memberPointsFrozenService.list((Wrapper)new LambdaQueryWrapper().eq(MemberPointsFrozen::getStoreOrderInfoId, (Object)orderInfoId));
        for (MemberPointsFrozen memberPointsFrozen : mpz) {
            Member member = this.memberMapper.selectForUpdate(memberPointsFrozen.getMemberId());
            Integer integral = memberPointsFrozen.getBackIntegral();
            member.setFrozenPoints(Integer.valueOf(member.getFrozenPoints() - integral));
            member.setPoints(Integer.valueOf(member.getPoints() + integral));
            this.memberMapper.updateById((Object)member);
            log.info("\u7528\u6237{}\u5f52\u8fd8\u5546\u54c1\uff0c\u83b7\u53d6\u79ef\u5206{}\uff0c\u5df2\u4ece\u51bb\u7ed3\u79ef\u5206\u6263\u9664\uff0c\u73b0\u51bb\u7ed3\u79ef\u5206{}", new Object[]{member.getId(), integral, member.getFrozenPoints()});
        }
        this.memberPointsFrozenService.removeBatchByIds((Collection)mpz);
    }

    public Page<AppletOrderInfoDetailVo> getMyOrderList(TypeParam vo) {
        MPJLambdaWrapper wrapper = (MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper(StoreOrderInfo.class).selectAll(StoreOrderInfo.class)).selectAs(StoreOrderInfo::getId, AppletOrderInfoDetailVo::getOrderId)).eq(StoreOrderInfo::getMemberId, (Object)SecurityUtils.getLoginUser().getMember().getId())).orderByDesc(StoreOrderInfo::getCreateTime);
        if (StringUtils.isNotBlank((String)vo.getKeyWord())) {
            wrapper.and(i -> ((MPJLambdaWrapper)((MPJLambdaWrapper)i.like(StoreOrderInfo::getProductName, (Object)vo.getKeyWord())).or()).like(StoreOrderInfo::getSpecValue, (Object)vo.getKeyWord()));
        }
        if (vo.getTypeId() > 0) {
            wrapper.eq(StoreOrderInfo::getStatus, (Object)vo.getTypeId());
        }
        Page appletOrderInfoDetailVoPage = (Page)this.mapper.selectJoinPage((IPage)new Page((long)vo.getPageNo().intValue(), (long)vo.getPageSize().intValue()), AppletOrderInfoDetailVo.class, (MPJBaseJoin)wrapper);
        appletOrderInfoDetailVoPage.getRecords().forEach(appletOrderInfoDetailVo -> {
            if (appletOrderInfoDetailVo.getStatus() != 2) {
                appletOrderInfoDetailVo.setVerifyCode("");
            }
        });
        return appletOrderInfoDetailVoPage;
    }

    public R payOrderInfo(Integer id) {
        if (id == null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38");
        }
        StoreOrderInfo storeOrderInfo = (StoreOrderInfo)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(StoreOrderInfo.class).eq(StoreOrderInfo::getId, (Object)id)).eq(StoreOrderInfo::getMemberId, (Object)SecurityUtils.getLoginUser().getMember().getId()));
        if (storeOrderInfo == null) {
            throw new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        R payOrderInfo = this.wxPayService.queryOrderByOutTradeNo(storeOrderInfo.getOrderNo());
        LinkedHashMap res = (LinkedHashMap)payOrderInfo.getData();
        if (payOrderInfo.getCode() == 200L && !res.isEmpty() && "\u652f\u4ed8\u6210\u529f".equals(res.get("msg"))) {
            this.orderPaySuccess(storeOrderInfo.getOrderNo(), (Map)payOrderInfo.getData());
            return R.failed((String)"\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u6e05\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        String orderNo = IdUtils.getInstance().nextId().toString();
        StoreOrder storeOrder = (StoreOrder)this.storeOrderMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(StoreOrder::getId, (Object)storeOrderInfo.getOrderId()));
        StoreOrder newOrder = new StoreOrder();
        BeanUtils.copyProperties((Object)storeOrder, (Object)newOrder);
        newOrder.setId(null);
        newOrder.setOrderId(orderNo);
        newOrder.setTotalNum(storeOrderInfo.getPayNum());
        newOrder.setTotalPrice(storeOrderInfo.getPrice().multiply(new BigDecimal(storeOrderInfo.getPayNum())));
        newOrder.setPayPrice(storeOrderInfo.getVipPrice().multiply(new BigDecimal(storeOrderInfo.getPayNum())).subtract(storeOrderInfo.getCouponPrice()));
        this.storeOrderMapper.insert((Object)newOrder);
        storeOrderInfo.setOrderId(newOrder.getId());
        storeOrderInfo.setOrderNo(orderNo);
        CreateOrderReq createOrderReq = new CreateOrderReq();
        createOrderReq.setTotal(Integer.valueOf(storeOrder.getPayPrice().multiply(new BigDecimal(100)).intValue()));
        createOrderReq.setWxOpenId(SecurityUtils.getLoginUser().getMember().getOpenId());
        createOrderReq.setDescription(storeOrderInfo.getProductName() + "\u5546\u54c1\u8d2d\u4e70");
        createOrderReq.setOutTradeNo(orderNo);
        this.storeOrderInfoMapper.updateById((Object)storeOrderInfo);
        return this.wxPayService.createOrder(createOrderReq);
    }

    public String payNotify(HttpServletRequest request) {
        Transaction transaction = this.wxPayService.payNotify(request);
        HashMap<String, String> returnMap = new HashMap<String, String>(2);
        returnMap.put("code", "FAIL");
        returnMap.put("message", "\u5931\u8d25");
        if (Transaction.TradeStateEnum.SUCCESS == transaction.getTradeState()) {
            String outTradeNo = transaction.getOutTradeNo();
            StoreOrderInfo payment = (StoreOrderInfo)this.storeOrderInfoMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"order_no", (Object)outTradeNo));
            if (payment != null) {
                payment.setIsPay(Integer.valueOf(1));
                payment.setStatus(Integer.valueOf(2));
                DateTime dateTime = DateUtil.parse((CharSequence)transaction.getSuccessTime());
                Date date = dateTime.toJdkDate();
                payment.setPayTime(Objects.requireNonNullElseGet(date, Date::new));
                log.info(payment.getOrderId() + "\u652f\u4ed8\u6210\u529f\u65f6\u95f4" + transaction.getSuccessTime());
                log.info(payment.getOrderId() + "\u66f4\u65b0\u652f\u4ed8\u65f6\u95f4" + payment.getPayTime());
            }
            returnMap.put("code", "SUCCESS");
            returnMap.put("message", "\u6210\u529f");
            return JSONObject.toJSONString(returnMap, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        }
        return JSONObject.toJSONString(returnMap, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void orderPaySuccess(String orderNo, Map<String, Object> payRes) {
        if (StringUtils.isNotBlank((String)orderNo)) {
            StoreOrder storeOrder = (StoreOrder)this.storeOrderMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(StoreOrder::getOrderId, (Object)orderNo));
            if (ObjectUtil.isNotEmpty((Object)storeOrder) && storeOrder.getPaid() == 0) {
                storeOrder.setPaid(Integer.valueOf(1));
                storeOrder.setPayTime((Date)DateUtil.parse((CharSequence)payRes.get("success_time").toString()));
            }
            this.dealPaySuccess(storeOrder);
        }
    }

    public RefundStatusVo applyRefund(QueryByIdVo vo) {
        StoreOrderInfo storeOrderInfo = (StoreOrderInfo)this.getById((Serializable)vo.getId());
        if (storeOrderInfo == null || storeOrderInfo.getIsPay() <= 0 || storeOrderInfo.getIsFinish() == 1) {
            throw new ServiceException("\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        if (!(storeOrderInfo.getRefundStatus().equals(4) || storeOrderInfo.getRefundStatus().equals(0) || storeOrderInfo.getRefundStatus().equals(3))) {
            throw new ServiceException("\u8ba2\u5355\u9000\u6b3e\u7533\u8bf7\u72b6\u6001\u5f02\u5e38");
        }
        storeOrderInfo.setRefundOrder(IdUtils.getInstance().nextId().toString());
        storeOrderInfo.setRefundStatus(Integer.valueOf(2));
        storeOrderInfo.setStatus(Integer.valueOf(5));
        storeOrderInfo.setRefundApplyTime(new Date());
        this.updateById((Object)storeOrderInfo);
        return this.buildRefundStatusVo(storeOrderInfo);
    }

    public RefundStatusVo cancelRefund(QueryByIdVo vo) {
        StoreOrderInfo storeOrderInfo = (StoreOrderInfo)this.getById((Serializable)vo.getId());
        if (storeOrderInfo == null || storeOrderInfo.getIsPay() < 1 || storeOrderInfo.getRefundStatus() != 2) {
            throw new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u9000\u6b3e\u72b6\u6001\u5f02\u5e38");
        }
        storeOrderInfo.setRefundStatus(Integer.valueOf(4));
        storeOrderInfo.setRefundCancelTime(new Date());
        storeOrderInfo.setStatus(Integer.valueOf(2));
        this.updateById((Object)storeOrderInfo);
        return this.buildRefundStatusVo(storeOrderInfo);
    }

    public RefundStatusVo getRefundInfo(QueryByIdVo vo) {
        StoreOrderInfo storeOrderInfo = (StoreOrderInfo)this.getById((Serializable)vo.getId());
        if (storeOrderInfo == null || storeOrderInfo.getStatus() == 0) {
            throw new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u9000\u6b3e\u72b6\u6001\u5f02\u5e38");
        }
        return this.buildRefundStatusVo(storeOrderInfo);
    }

    public R RejectRefund(RejectRefundVo vo) {
        if (vo.getId() == null || vo.getRefundReason() == null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38");
        }
        StoreOrderInfo storeOrderInfo = (StoreOrderInfo)this.getById((Serializable)vo.getId());
        storeOrderInfo.setRefundReason(vo.getRefundReason());
        storeOrderInfo.setRefundStatus(Integer.valueOf(3));
        storeOrderInfo.setRefundReasonTime(new Date());
        return this.updateById((Object)storeOrderInfo) ? R.ok() : R.failed();
    }

    public String refundNotify(HttpServletRequest request) {
        log.info("-----------\u9000\u6b3e\u56de\u8c03-----------");
        RefundNotification refundNotification = this.wxPayService.refundNotify(request);
        String refundStatus = refundNotification.getRefundStatus().toString();
        String outRefundNo = refundNotification.getOutRefundNo();
        StoreOrderInfo returnGoods = (StoreOrderInfo)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(StoreOrderInfo.class).eq(StoreOrderInfo::getRefundOrder, (Object)outRefundNo)).last("limit 1"));
        switch (refundStatus) {
            case "SUCCESS": {
                returnGoods.setIsFinish(Integer.valueOf(1));
                returnGoods.setStatus(Integer.valueOf(4));
                returnGoods.setRefundStatus(OrderRefundEnum.REFUNDED.getCode());
                break;
            }
            case "CLOSED": 
            case "ABNORMAL": 
            case "PROCESSING": {
                returnGoods.setRefundStatus(OrderRefundEnum.APPLY.getCode());
                break;
            }
        }
        this.updateById((Object)returnGoods);
        return "";
    }

    public R queryOrderByOutTradeNo(String outTradeNo) {
        R payOrderInfo = this.wxPayService.queryOrderByOutTradeNo(outTradeNo);
        LinkedHashMap res = (LinkedHashMap)payOrderInfo.getData();
        if (payOrderInfo.getCode() == 200L && !res.isEmpty() && "\u652f\u4ed8\u6210\u529f".equals(res.get("msg"))) {
            this.orderPaySuccess(outTradeNo, (Map)payOrderInfo.getData());
        }
        return R.ok();
    }

    public Page<RefundListVo> getRefundList(RefundListSearchParam param) {
        MPJLambdaWrapper wrapper = (MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper(StoreOrderInfo.class).select(new SFunction[]{StoreOrderInfo::getId, StoreOrderInfo::getClerkId, StoreOrderInfo::getOrderNo, StoreOrderInfo::getRefundOrder, StoreOrderInfo::getVipPrice, StoreOrderInfo::getRefundApplyTime, StoreOrderInfo::getRefundStatus, StoreOrderInfo::getRefundReason, StoreOrderInfo::getRefundRemark, StoreOrderInfo::getProductName, StoreOrderInfo::getCouponPrice, StoreOrderInfo::getImage, StoreOrderInfo::getSpecValue, StoreOrderInfo::getPayNum, StoreOrderInfo::getPrice, StoreOrderInfo::getRefundTime}).innerJoin(StoreOrder.class, StoreOrder::getId, StoreOrder::getOrderId)).select(new SFunction[]{StoreOrderInfo::getUserPhone}).ne(StoreOrderInfo::getRefundStatus, (Object)0)).eq(StringUtils.isNotBlank((String)param.getOrderNo()), StoreOrderInfo::getOrderNo, (Object)param.getOrderNo())).eq(StringUtils.isNotBlank((String)param.getUserPhone()), StoreOrderInfo::getUserPhone, (Object)param.getUserPhone())).eq(StringUtils.isNotBlank((String)param.getRefundOrder()), StoreOrderInfo::getRefundOrder, (Object)param.getRefundOrder())).eq(ObjectUtil.isNotEmpty((Object)param.getStatus()), StoreOrderInfo::getRefundStatus, (Object)param.getStatus());
        if (ObjectUtil.isNotEmpty((Object)param.getStartTime()) && ObjectUtil.isNotEmpty((Object)param.getEndTime())) {
            wrapper.between(StoreOrderInfo::getRefundApplyTime, (Object)param.getStartTime(), (Object)param.getEndTime());
        }
        wrapper.orderByDesc(StoreOrderInfo::getRefundApplyTime);
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        Page refundListVoPage = (Page)this.storeOrderInfoMapper.selectJoinPage((IPage)page, RefundListVo.class, (MPJBaseJoin)wrapper);
        refundListVoPage.getRecords().forEach(item -> {
            item.setStatusText(ObjectUtil.isNull((Object)item.getClerkId()) ? "\u4ee3\u53d6\u4ef6" : "\u5df2\u53d6\u4ef6");
            item.setRefundStatusText(OrderRefundEnum.fromCode((Integer)item.getRefundStatus()).getValue());
        });
        return refundListVoPage;
    }

    @Transactional(rollbackFor={Exception.class})
    public void dealPaySuccess(StoreOrder storeOrder) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(StoreOrderInfo::getOrderId, (Object)storeOrder.getId())).set(StoreOrderInfo::getIsPay, (Object)1)).set(StoreOrderInfo::getStatus, (Object)2)).set(StoreOrderInfo::getPayTime, (Object)storeOrder.getPayTime());
        this.update((Wrapper)wrapper);
    }

    private RefundStatusVo buildRefundStatusVo(StoreOrderInfo storeOrderInfo) {
        RefundStatusVo refundStatusVo = new RefundStatusVo();
        refundStatusVo.setId(storeOrderInfo.getId());
        refundStatusVo.setOrderNo(storeOrderInfo.getOrderNo());
        refundStatusVo.setApplyTime(storeOrderInfo.getRefundApplyTime());
        refundStatusVo.setImage(storeOrderInfo.getImage());
        refundStatusVo.setProductName(storeOrderInfo.getProductName());
        refundStatusVo.setPayNum(storeOrderInfo.getPayNum());
        refundStatusVo.setPayPrice(storeOrderInfo.getVipPrice().multiply(BigDecimal.valueOf(storeOrderInfo.getPayNum().intValue())).subtract(storeOrderInfo.getCouponPrice()));
        refundStatusVo.setRefundReason(storeOrderInfo.getRefundReason());
        refundStatusVo.setRefundReasonTime(storeOrderInfo.getRefundReasonTime());
        refundStatusVo.setRefundTime(storeOrderInfo.getRefundTime());
        refundStatusVo.setRefundCancelTime(storeOrderInfo.getRefundCancelTime());
        refundStatusVo.setRefundStatus(storeOrderInfo.getRefundStatus());
        refundStatusVo.setProductId(storeOrderInfo.getProductId());
        refundStatusVo.setPrice(storeOrderInfo.getVipPrice());
        refundStatusVo.setSpecValue(storeOrderInfo.getSpecValue());
        refundStatusVo.setRefundPrice(storeOrderInfo.getRefundPrice());
        refundStatusVo.setStoreName(storeOrderInfo.getStoreName());
        return refundStatusVo;
    }
}

