/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.order.controller;

import gz.lp.common.core.api.R;
import gz.lp.common.pay.config.CreateOrderReq;
import gz.lp.common.pay.service.WxPayService;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.mall.order.service.StoreOrderService;
import gz.lp.system.api.domain.PaymentRespVo;
import gz.lp.system.api.domain.param.CreateOrderParam;
import gz.lp.system.api.domain.param.IntegralBuyParam;
import gz.lp.system.api.domain.param.OrderComputedPriceParam;
import gz.lp.system.api.domain.param.PreOrderParams;
import gz.lp.system.api.domain.vo.ComputeOrderPriceRespVo;
import gz.lp.system.api.domain.vo.PreOrderRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/storeOrder"})
public class StoreOrderController {
    @Autowired
    private StoreOrderService storeOrderService;
    @Autowired
    private WxPayService wxPayService;

    @RequestMapping(value={"/preOrder"})
    public R preOrder(@RequestBody PreOrderParams params) {
        return R.success((Object)this.storeOrderService.preOrder(params));
    }

    @RequestMapping(value={"/loadPreOrder"})
    public R<PreOrderRespVo> loadPreOrder(@RequestBody String preOrderNo) {
        return R.success((Object)this.storeOrderService.loadPreOrder(preOrderNo));
    }

    @RequestMapping(value={"/createOrder"})
    public R createOrder(@RequestBody CreateOrderParam param) {
        PaymentRespVo order = this.storeOrderService.createOrder(param);
        CreateOrderReq createOrderReq = new CreateOrderReq();
        createOrderReq.setTotal(order.getTotalPrice());
        createOrderReq.setWxOpenId(SecurityUtils.getLoginUser().getMember().getOpenId());
        createOrderReq.setDescription("\u7acb\u54c1\u4ea7\u54c1\u652f\u4ed8");
        createOrderReq.setOutTradeNo(order.getOutTradeNo());
        return this.wxPayService.createOrder(createOrderReq);
    }

    @RequestMapping(value={"/computedOrderPrice"})
    public R<ComputeOrderPriceRespVo> computedOrderPrice(@RequestBody OrderComputedPriceParam param) {
        return R.success((Object)this.storeOrderService.computedOrderPrice(param));
    }

    @PostMapping(value={"/integralBuy"})
    public R integralBuy(@RequestBody IntegralBuyParam request) {
        return this.storeOrderService.integralBuy(request);
    }
}

