/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.member.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.JsonUtils;
import gz.lp.common.core.utils.PackageUtil;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.mall.member.entity.MemberRentProduct;
import gz.lp.mall.member.entity.PushStatistics;
import gz.lp.mall.member.mapper.MemberRentProductMapper;
import gz.lp.mall.member.service.MemberRentProductService;
import gz.lp.mall.member.service.PushStatisticsService;
import gz.lp.mall.member.vo.TodayPushDataVo;
import gz.lp.mall.order.entity.StoreOrderInfo;
import gz.lp.system.api.domain.param.TypeParam;
import gz.lp.system.api.domain.vo.MyPackageRespVo;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemberRentProductServiceImpl
extends ServiceImpl<MemberRentProductMapper, MemberRentProduct>
implements MemberRentProductService {
    private static final Logger log = LoggerFactory.getLogger(MemberRentProductServiceImpl.class);
    @Autowired
    private MemberRentProductMapper memberRentProductMapper;
    @Autowired
    private PushStatisticsService pushStatisticsService;

    public boolean dealRentProduct(StoreOrderInfo storeOrderInfo) {
        if (storeOrderInfo != null) {
            MemberRentProduct memberRentProduct = this.getByStoreOrderInfo(storeOrderInfo);
            if (memberRentProduct == null) {
                memberRentProduct = MemberRentProduct.builder().memberId(storeOrderInfo.getMemberId()).productId(storeOrderInfo.getProductId()).specId(storeOrderInfo.getAttrValueId()).storeId(storeOrderInfo.getStoreId()).createTime(new Date()).build();
            }
            memberRentProduct.setOrderInfoId(storeOrderInfo.getId());
            memberRentProduct.setOrderNo(storeOrderInfo.getOrderNo());
            memberRentProduct.setOrderNo(storeOrderInfo.getOrderNo());
            memberRentProduct.setStartTime(storeOrderInfo.getRentStartTime());
            memberRentProduct.setEndTime(storeOrderInfo.getRentEndTime());
            return this.saveOrUpdate((Object)memberRentProduct);
        }
        return false;
    }

    public boolean hasRentProduct(Integer memberId, Integer productId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(MemberRentProduct.class).eq(MemberRentProduct::getProductId, (Object)productId)).eq(MemberRentProduct::getMemberId, (Object)memberId)).ge(MemberRentProduct::getEndTime, (Object)DateUtils.getTime())).le(MemberRentProduct::getStartTime, (Object)DateUtils.getTime());
        return this.getOne((Wrapper)wrapper) == null;
    }

    public MyPackageRespVo getMyPackage(TypeParam param) {
        MPJLambdaWrapper wrapper = (MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper(MemberRentProduct.class).select(new SFunction[]{MemberRentProduct::getBackTime, MemberRentProduct::getSpecId, MemberRentProduct::getStoreId, MemberRentProduct::getStartTime, MemberRentProduct::getEndTime}).selectAs(StoreOrderInfo::getSpecValue, MyPackageRespVo::getSpecVal)).leftJoin(StoreOrderInfo.class, StoreOrderInfo::getId, MemberRentProduct::getOrderInfoId)).eq(MemberRentProduct::getMemberId, (Object)SecurityUtils.getLoginUser().getMember().getId());
        if (param.getTypeId() == 1) {
            ((MPJLambdaWrapper)wrapper.le(MemberRentProduct::getStartTime, (Object)DateUtils.getTime())).ge(MemberRentProduct::getEndTime, (Object)DateUtils.getTime());
        }
        if (param.getTypeId() == 2) {
            ((MPJLambdaWrapper)wrapper.lt(MemberRentProduct::getEndTime, (Object)DateUtils.getTime())).isNull(MemberRentProduct::getBackTime);
        }
        return (MyPackageRespVo)this.memberRentProductMapper.selectJoinOne(MyPackageRespVo.class, (MPJBaseJoin)wrapper);
    }

    public boolean checkRentProductNoBack(Integer memberId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(MemberRentProduct.class).eq(MemberRentProduct::getMemberId, (Object)memberId)).isNull(MemberRentProduct::getBackTime);
        return this.memberRentProductMapper.selectCount((Wrapper)wrapper) > 0L;
    }

    private MemberRentProduct getByStoreOrderInfo(StoreOrderInfo storeOrderInfo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(MemberRentProduct.class).eq(MemberRentProduct::getProductId, (Object)storeOrderInfo.getProductId())).eq(MemberRentProduct::getSpecId, (Object)storeOrderInfo.getAttrValueId())).eq(MemberRentProduct::getStoreId, (Object)storeOrderInfo.getStoreId())).eq(MemberRentProduct::getMemberId, (Object)storeOrderInfo.getMemberId());
        return (MemberRentProduct)this.memberRentProductMapper.selectOne((Wrapper)wrapper);
    }

    public void pushNotOneDayData() {
        List todayPushData = ((MemberRentProductMapper)this.baseMapper).getTodayPushData();
        if (todayPushData == null || todayPushData.isEmpty()) {
            return;
        }
        this.pushData(todayPushData);
    }

    public R manuallyPushData(Integer[] ids) {
        List manuallyPushData = this.memberRentProductMapper.getManuallyPushData(List.of(ids));
        return R.success((Object)this.pushData(manuallyPushData));
    }

    public String pushData(List<TodayPushDataVo> todayPushData) {
        CopyOnWriteArrayList failedPushData = new CopyOnWriteArrayList();
        CopyOnWriteArrayList successPushData = new CopyOnWriteArrayList();
        todayPushData.stream().filter(item -> PackageUtil.hasPackage((String)item.getName(), (Integer)item.getPeriodicityDay()));
        todayPushData.forEach(item -> {
            try {
                if (PackageUtil.pushPackage((String)item.getPhone(), (String)item.getName())) {
                    successPushData.add(item.getMrpId());
                } else {
                    failedPushData.add(item);
                }
            }
            catch (Exception e) {
                failedPushData.add(item);
            }
        });
        if (successPushData.size() > 0) {
            ((MemberRentProductMapper)this.baseMapper).editPushData(successPushData, Integer.valueOf(2));
        }
        long validCount = todayPushData.stream().filter(item -> PackageUtil.hasPackage((String)item.getName(), (Integer)item.getPeriodicityDay())).count();
        if (failedPushData.size() > 0) {
            ((MemberRentProductMapper)this.baseMapper).editPushData(failedPushData.stream().map(TodayPushDataVo::getMrpId).filter(Objects::nonNull).collect(Collectors.toList()), Integer.valueOf(3));
            PushStatistics pushStatistics = PushStatistics.builder().totalNum(Integer.valueOf(todayPushData.size())).successNum(Integer.valueOf((int)validCount)).failNum(Integer.valueOf(failedPushData.size())).pushType(Integer.valueOf(2)).pushTime(DateUtils.getNowDate()).failData(JsonUtils.listToJson(failedPushData)).build();
            this.pushStatisticsService.saveData(pushStatistics);
        }
        return String.format("\u63a8\u9001\u5b8c\u6210 - \u603b\u6570\u636e\u91cf: %d, \u63a8\u9001\u6210\u529f: %d, \u63a8\u9001\u5931\u8d25: %d%n,\u5931\u8d25\u6570\u636e:", todayPushData.size(), validCount, failedPushData.size(), failedPushData);
    }
}

