/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.member.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.security.annotation.InnerAuth;
import gz.lp.common.security.service.TokenService;
import gz.lp.mall.member.service.MemberRentProductService;
import gz.lp.mall.member.service.MemberService;
import gz.lp.mall.member.service.PointsLogService;
import gz.lp.system.api.domain.LoginBody;
import gz.lp.system.api.domain.MemberInfo;
import gz.lp.system.api.domain.QueryByIdsVo;
import gz.lp.system.api.domain.param.AppletEditMemberParams;
import gz.lp.system.api.domain.param.GetMemberJuniorParams;
import gz.lp.system.api.domain.param.IdPrams;
import gz.lp.system.api.domain.param.PointsLogListParams;
import gz.lp.system.api.domain.param.TypeParam;
import gz.lp.system.api.domain.vo.EditMemberVo;
import gz.lp.system.api.domain.vo.MemberJuniorRespVo;
import gz.lp.system.api.domain.vo.MemberPageRespVo;
import gz.lp.system.api.domain.vo.MemberPageVo;
import gz.lp.system.api.domain.vo.MyPackageRespVo;
import gz.lp.system.api.model.LoginUser;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/member"})
public class MemberController {
    @Autowired
    private MemberService memberService;
    @Autowired
    private PointsLogService pointsLogService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private MemberRentProductService memberRentProductService;

    @PostMapping(value={"/appletLogin"})
    public R login(@RequestBody LoginBody vo) {
        MemberInfo memberInfo = this.memberService.login(vo);
        LoginUser loginUser = new LoginUser();
        loginUser.setIsApplet(1);
        loginUser.setMember(memberInfo);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("info", memberInfo);
        result.put("token", this.tokenService.createToken(loginUser));
        return R.success(result);
    }

    @PostMapping(value={"/getMemberInfo"})
    @InnerAuth
    public R getMemberInfo() {
        return R.success((Object)this.memberService.getMemberInfo());
    }

    @PostMapping(value={"/myPackage"})
    @InnerAuth
    public R<MyPackageRespVo> getMyPackage(@RequestBody TypeParam param) {
        return R.success((Object)this.memberRentProductService.getMyPackage(param));
    }

    @PostMapping
    public R<Page<MemberPageRespVo>> queryByPage(@RequestBody MemberPageVo vo) {
        return R.success((Object)this.memberService.queryByPage(vo));
    }

    @PostMapping(value={"/editMember"})
    public R editMember(@RequestBody EditMemberVo vo) {
        String res = this.memberService.editMember(vo);
        if (StringUtil.isNotBlank((CharSequence)res)) {
            return R.failed((String)res);
        }
        return R.ok();
    }

    @PostMapping(value={"/appletEditMember"})
    public R editMember(@RequestBody AppletEditMemberParams vo) {
        return this.memberService.AppletEditMember(vo);
    }

    @PostMapping(value={"/pointsLog"})
    @InnerAuth
    public R pointsLog(@RequestBody PointsLogListParams vo) {
        return R.success((Object)this.pointsLogService.getPointsLogPage(vo));
    }

    @PostMapping(value={"/juniorMember"})
    public R<Page<MemberJuniorRespVo>> memberJuniorList(@RequestBody GetMemberJuniorParams vo) {
        return R.success((Object)this.memberService.memberJuniorList(vo));
    }

    @PostMapping(value={"/juniorMemberChildren"})
    public R<Page<MemberJuniorRespVo>> juniorMemberChildren(@RequestBody IdPrams vo) {
        return R.success((Object)this.memberService.memberJuniorChildrenList(vo));
    }

    @PostMapping(value={"/getPointsRecordByUid"})
    @InnerAuth
    public R getPointsRecordByUid(@RequestBody IdPrams idPrams) {
        return R.success((Object)this.pointsLogService.queryPointsRecordByMember(idPrams));
    }

    @PostMapping(value={"/manuallyPushData"})
    public R manuallyPushData(@RequestBody QueryByIdsVo vo) {
        return this.memberRentProductService.manuallyPushData(vo.getIds());
    }
}

