/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.coupon.service.impl;

import com.alibaba.nacos.common.utils.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.mall.coupon.domain.Coupon;
import gz.lp.mall.coupon.domain.CouponUsage;
import gz.lp.mall.coupon.mapper.CouponMapper;
import gz.lp.mall.coupon.mapper.CouponUsageMapper;
import gz.lp.mall.coupon.param.CouponUsageListParam;
import gz.lp.mall.coupon.service.CouponUsageService;
import gz.lp.mall.coupon.vo.CouponUsageVo;
import gz.lp.mall.member.entity.Member;
import gz.lp.system.api.domain.QueryMyCouponsVo;
import gz.lp.system.api.domain.ReceiveCouponsVo;
import gz.lp.system.api.domain.UseCouponVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponUsageServiceImpl
extends ServiceImpl<CouponUsageMapper, CouponUsage>
implements CouponUsageService {
    @Autowired
    private CouponMapper couponMapper;

    public R getList(CouponUsageListParam param) {
        Page page = new Page();
        page.setCurrent((long)param.getPageNo().intValue());
        page.setSize((long)param.getPageSize().intValue());
        MPJLambdaWrapper qw = new MPJLambdaWrapper();
        ((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)qw.selectAs(CouponUsage::getId, CouponUsageVo::getId)).selectAs(Member::getMemberId, CouponUsageVo::getMemberId)).selectAs(Member::getNickname, CouponUsageVo::getNickname)).selectAs(Member::getAvatar, CouponUsageVo::getAvatar)).selectAs(Coupon::getCouponName, CouponUsageVo::getCouponName)).selectAs(Coupon::getCouponType, CouponUsageVo::getCouponType)).selectAs(Coupon::getFaceValue, CouponUsageVo::getFaceValue)).selectAs(Coupon::getDiscount, CouponUsageVo::getDiscount)).selectAs(Coupon::getUsageScope, CouponUsageVo::getUsageScope)).selectAs(Coupon::getLimitAmount, CouponUsageVo::getLimitAmount)).selectAs(Coupon::getCouponStatus, CouponUsageVo::getCouponStatus)).selectAs(CouponUsage::getPickUpTime, CouponUsageVo::getPickUpTime)).selectAs(CouponUsage::getIsUse, CouponUsageVo::getIsUse)).leftJoin(Coupon.class, Coupon::getId, CouponUsage::getCouponId)).leftJoin(Member.class, Member::getId, CouponUsage::getUserId);
        if (StringUtils.isNotBlank((String)param.getNickname())) {
            qw.like(Member::getNickname, (Object)param.getNickname());
        }
        if (StringUtils.isNotBlank((String)param.getCouponName())) {
            qw.like(Coupon::getCouponName, (Object)param.getCouponName());
        }
        if (param.getUsageScope() != null) {
            qw.eq(Coupon::getUsageScope, (Object)param.getUsageScope());
        }
        if (param.getCouponId() != null) {
            qw.eq(CouponUsage::getCouponId, (Object)param.getCouponId());
        }
        if (param.getOrderId() != null) {
            qw.eq(CouponUsage::getOrderId, (Object)param.getOrderId());
        }
        if (param.getStartTime() != null && param.getEndTime() != null) {
            qw.between(CouponUsage::getPickUpTime, (Object)param.getStartTime(), (Object)param.getEndTime());
        }
        if (param.getIsUse() != null) {
            qw.eq(CouponUsage::getIsUse, (Object)param.getIsUse());
        }
        Page list = (Page)((CouponUsageMapper)this.baseMapper).selectJoinPage((IPage)page, CouponUsageVo.class, (MPJBaseJoin)qw);
        return R.success((Object)list);
    }

    public CouponUsage getByCouponUsageId(Integer couponId, Integer memberId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper(CouponUsage.class);
        queryWrapper.eq(CouponUsage::getId, (Object)couponId);
        queryWrapper.eq(CouponUsage::getIsUse, (Object)0);
        queryWrapper.eq(CouponUsage::getUserId, (Object)memberId);
        queryWrapper.orderByDesc(CouponUsage::getId);
        queryWrapper.last(" limit 1");
        return (CouponUsage)this.getOne((Wrapper)queryWrapper);
    }

    public R useCoupon(UseCouponVo vo) {
        if (vo.getId() == null) {
            return R.failed((String)"\u6838\u9500\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        }
        CouponUsage use = (CouponUsage)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CouponUsage::getId, (Object)vo.getId())).eq(CouponUsage::getIsUse, (Object)0));
        if (use == null) {
            return R.failed((String)"\u6838\u9500\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        }
        use.setIsUse(Integer.valueOf(1));
        use.setUseTime(DateUtils.getTime());
        return this.updateById((Object)use) ? R.ok() : R.failed((String)"\u6838\u9500\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
    }

    @Transactional
    public R claimCoupon(ReceiveCouponsVo vo) {
        List userCouponList = ((CouponUsageMapper)this.baseMapper).getListByUserId(vo.getUserId(), vo.getId());
        if (userCouponList != null && userCouponList.size() > 0) {
            return R.failed((String)"\u60a8\u5df2\u9886\u53d6\u8fc7\u8be5\u4f18\u60e0\u5238!");
        }
        Coupon coupon1 = this.couponMapper.selectByIdForUpdate(Long.valueOf(vo.getId().intValue()));
        if (coupon1.getCouponNumber() <= 0) {
            return R.failed((String)"\u4f18\u60e0\u5238\u5df2\u9886\u5b8c!");
        }
        CouponUsage couponUsage = CouponUsage.builder().id(null).couponId(vo.getId()).userId(vo.getUserId()).orderId(null).pickUpTime(DateUtils.getTime()).isUse(Integer.valueOf(0)).build();
        this.save((Object)couponUsage);
        this.couponMapper.updateById((Object)Coupon.builder().id(coupon1.getId()).couponNumber(Integer.valueOf(coupon1.getCouponNumber() - 1)).useNumber(Integer.valueOf(coupon1.getUseNumber() + 1)).updateTime(DateUtils.getTime()).build());
        return R.success((Object)"\u9886\u53d6\u6210\u529f\uff01");
    }

    public R getMyUseList(QueryMyCouponsVo vo) {
        Page page = new Page();
        page.setCurrent((long)vo.getPageNum().intValue());
        page.setSize((long)vo.getPageSize().intValue());
        Integer memberId = SecurityUtils.getLoginUser().getMember().getId();
        Integer pageType = vo.getPageType();
        IPage list = ((CouponUsageMapper)this.baseMapper).getMyUseList(page, memberId, pageType);
        return R.success((Object)list);
    }

    public List<CouponUsage> getCouponUse(List<Integer> couponId, Integer memberId) {
        QueryWrapper qw = new QueryWrapper();
        qw.in((Object)"coupon_id", couponId);
        qw.eq((Object)"user_id", (Object)memberId);
        List couponUsages = ((CouponUsageMapper)this.baseMapper).selectList((Wrapper)qw);
        return couponUsages;
    }
}

