/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.coupon.controller;

import gz.lp.common.core.api.R;
import gz.lp.mall.coupon.domain.Coupon;
import gz.lp.mall.coupon.param.CouponAppParam;
import gz.lp.mall.coupon.param.CouponDetailParam;
import gz.lp.mall.coupon.param.CouponListParam;
import gz.lp.mall.coupon.service.CouponService;
import gz.lp.system.api.domain.QueryCouponByUsageScopeVo;
import gz.lp.system.api.domain.QueryMyCouponsVo;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/coupons"})
public class CouponController {
    @Autowired
    private CouponService service;

    @PostMapping(value={"/list"})
    public R list(@RequestBody CouponListParam param) {
        return R.success((Object)this.service.getCouponList(param));
    }

    @PostMapping(value={"/detail"})
    public R detail(@RequestBody CouponDetailParam param) {
        if (param == null || param.getId() == null) {
            return R.failed((String)"\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!!!");
        }
        return R.success((Object)this.service.getCouponDetail(param));
    }

    @PostMapping(value={"/delete"})
    public R delete(@RequestBody CouponDetailParam param) {
        if (param == null || param.getId() == null) {
            return R.failed((String)"\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!!!");
        }
        return this.service.removeById((Serializable)param.getId()) ? R.success((Object)"\u5220\u9664\u6210\u529f") : R.failed((String)"\u5220\u9664\u5931\u8d25");
    }

    @PostMapping(value={"/add"})
    public R add(@RequestBody CouponAppParam param) {
        return this.service.addCoupon(param);
    }

    @PostMapping(value={"/edit"})
    public R update(@RequestBody Coupon param) {
        return this.service.editCoupon(param);
    }

    @PostMapping(value={"/queryMyCoupons"})
    public R queryMyCoupons(@RequestBody QueryMyCouponsVo vo) {
        return R.success((Object)this.service.queryMyCoupons(vo));
    }

    @PostMapping(value={"/getCouponByUsageScope"})
    public R getCouponByUsageScope(@RequestBody QueryCouponByUsageScopeVo vo) {
        return R.success((Object)this.service.getCouponByUsageScope(vo));
    }
}

