/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.system.service.impl;

import cn.hutool.core.convert.Convert;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.redis.service.RedisService;
import gz.lp.common.redis.util.RedisUtil;
import gz.lp.system.domain.SysConfig;
import gz.lp.system.mapper.SysConfigMapper;
import gz.lp.system.service.ISysConfigService;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysConfigServiceImpl
implements ISysConfigService {
    @Autowired
    private SysConfigMapper configMapper;
    @Autowired
    private RedisService redisService;

    @PostConstruct
    public void init() {
        this.loadingConfigCache();
    }

    public SysConfig selectConfigById(Long configId) {
        SysConfig config = new SysConfig();
        config.setConfigId(configId);
        return this.configMapper.selectConfig(config);
    }

    public String selectConfigByKey(String configKey) {
        String configValue = Convert.toStr((Object)RedisUtil.get((String)this.getCacheKey(configKey)));
        if (StringUtil.isNotEmpty((String)configValue)) {
            return configValue;
        }
        SysConfig config = new SysConfig();
        config.setConfigKey(configKey);
        SysConfig retConfig = this.configMapper.selectConfig(config);
        if (StringUtil.isNotNull((Object)retConfig)) {
            RedisUtil.set((String)this.getCacheKey(configKey), (Object)retConfig.getConfigValue(), (long)-1L);
            return retConfig.getConfigValue();
        }
        return "";
    }

    public List<SysConfig> selectConfigList(SysConfig config) {
        return this.configMapper.selectConfigList(config);
    }

    public int insertConfig(SysConfig config) {
        int row = this.configMapper.insertConfig(config);
        if (row > 0) {
            RedisUtil.set((String)this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue(), (long)-1L);
        }
        return row;
    }

    public int updateConfig(SysConfig config) {
        int row;
        SysConfig temp = this.configMapper.selectConfigById(config.getConfigId());
        if (!StringUtil.equals((CharSequence)temp.getConfigKey(), (CharSequence)config.getConfigKey())) {
            RedisUtil.del((String[])new String[]{this.getCacheKey(temp.getConfigKey())});
        }
        if ((row = this.configMapper.updateConfig(config)) > 0) {
            RedisUtil.set((String)this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue(), (long)-1L);
        }
        return row;
    }

    public void deleteConfigByIds(Long[] configIds) {
        for (Long configId : configIds) {
            SysConfig config = this.selectConfigById(configId);
            if (StringUtil.equals((CharSequence)"Y", (CharSequence)config.getConfigType())) {
                throw new ServiceException(String.format("\u5185\u7f6e\u53c2\u6570\u3010%1$s\u3011\u4e0d\u80fd\u5220\u9664 ", config.getConfigKey()));
            }
            this.configMapper.deleteConfigById(configId);
            RedisUtil.del((String[])new String[]{this.getCacheKey(config.getConfigKey())});
        }
    }

    public void loadingConfigCache() {
        List configsList = this.configMapper.selectConfigList(new SysConfig());
        for (SysConfig config : configsList) {
            this.redisService.setCacheObject(this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue());
        }
    }

    public void clearConfigCache() {
        Collection keys = RedisUtil.keys((String)"sys_config:*");
        RedisUtil.deleteBatch((Collection)keys);
    }

    public void resetConfigCache() {
        this.clearConfigCache();
        this.loadingConfigCache();
    }

    public boolean checkConfigKeyUnique(SysConfig config) {
        Long configId = StringUtil.isNull((Object)config.getConfigId()) ? -1L : config.getConfigId();
        SysConfig info = this.configMapper.checkConfigKeyUnique(config.getConfigKey());
        return !StringUtil.isNotNull((Object)info) || info.getConfigId().longValue() == configId.longValue();
    }

    private String getCacheKey(String configKey) {
        return "sys_config:" + configKey;
    }
}

