/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.applet.tribe.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.applet.tribe.entity.PostTags;
import gz.lp.applet.tribe.entity.Posts;
import gz.lp.applet.tribe.mapper.PostsMapper;
import gz.lp.applet.tribe.param.AddAndEditPostParam;
import gz.lp.applet.tribe.param.DeleteParam;
import gz.lp.applet.tribe.param.PostTagsParam;
import gz.lp.applet.tribe.param.QueryDetailParam;
import gz.lp.applet.tribe.param.QueryPostParam;
import gz.lp.applet.tribe.service.PostTagsService;
import gz.lp.applet.tribe.service.PostsService;
import gz.lp.applet.tribe.vo.PostVo;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.tools;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PostsServiceImpl
extends ServiceImpl<PostsMapper, Posts>
implements PostsService {
    @Autowired
    private PostsMapper postsMapper;
    @Autowired
    private PostTagsService postTagsService;

    @Transactional(rollbackFor={Exception.class})
    public int postCon(AddAndEditPostParam addAndEditPostParam) {
        boolean isTagsSaved;
        Posts post = new Posts();
        BeanUtils.copyProperties((Object)addAndEditPostParam.getPostParam(), (Object)post);
        int postInsertResult = this.postsMapper.insert((Object)post);
        if (postInsertResult <= 0) {
            throw new ServiceException("\u53d1\u5e16\u5931\u8d25");
        }
        List postTagsList = addAndEditPostParam.getPostTagsParams().stream().map(tagParam -> {
            PostTags postTag = new PostTags();
            postTag.setPostId(post.getPostId());
            postTag.setTagName(tagParam.getTagName());
            postTag.setCreatedAt(DateUtils.formatDate((String)DateUtils.getTime()));
            return postTag;
        }).collect(Collectors.toList());
        if (!postTagsList.isEmpty() && !(isTagsSaved = this.postTagsService.saveBatch(postTagsList))) {
            throw new ServiceException("\u53d1\u5e16\u5931\u8d25");
        }
        return postInsertResult;
    }

    public int editPost(AddAndEditPostParam addAndEditPostParam) {
        if (addAndEditPostParam == null || addAndEditPostParam.getPostParam() == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e3a\u7a7a");
        }
        Posts posts = (Posts)this.postsMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"post_id", (Object)addAndEditPostParam.getPostParam().getPostId()));
        if (posts == null) {
            throw new ServiceException("\u5e16\u5b50\u4e0d\u5b58\u5728");
        }
        try {
            List tagIdsToDelete;
            tools.structure((Object)posts, (Object)addAndEditPostParam, (Boolean)false);
            this.postsMapper.updateById((Object)posts);
            List newTags = addAndEditPostParam.getPostTagsParams().stream().filter(po -> po.getTagId() == null).map(po -> {
                PostTags postTags = new PostTags();
                postTags.setPostId(posts.getPostId());
                postTags.setTagName(po.getTagName());
                return postTags;
            }).collect(Collectors.toList());
            if (!newTags.isEmpty()) {
                this.postTagsService.saveBatch(newTags);
            }
            if (!(tagIdsToDelete = addAndEditPostParam.getPostTagsParams().stream().filter(po -> po.getTagId() != null).map(PostTagsParam::getTagId).collect(Collectors.toList())).isEmpty()) {
                this.postTagsService.removeBatchByIds(tagIdsToDelete);
            }
            return 1;
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("\u5904\u7406\u5931\u8d25");
        }
    }

    public int deletePost(DeleteParam deleteParam) {
        return this.postsMapper.deleteById((Serializable)deleteParam.getPostId());
    }

    public IPage<PostVo> query(QueryPostParam queryPostParam) {
        Page postVoPage = new Page((long)queryPostParam.getPageNo().intValue(), (long)queryPostParam.getPageSize().intValue());
        return this.postsMapper.queryPage((IPage)postVoPage, queryPostParam);
    }

    public PostVo queryDetail(QueryDetailParam queryDetailParam) {
        PostVo postVo = this.postsMapper.queryDetail(queryDetailParam);
        List postTagsVos = this.postsMapper.queryTags(queryDetailParam.getPostId());
        postVo.setPostTagsVos(postTagsVos);
        return postVo;
    }
}

