/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.gateway.filter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import gz.lp.common.core.utils.ServletUtils;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.gateway.config.properties.CaptchaProperties;
import gz.lp.gateway.service.ValidateCodeService;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;

@Component
public class ValidateCodeFilter
extends AbstractGatewayFilterFactory<Object> {
    private static Logger logger = LoggerFactory.getLogger(ValidateCodeFilter.class);
    private static final String[] VALIDATE_URL = new String[]{"/auth/login"};
    private static final String CODE = "code";
    private static final String UUID = "uuid";
    @Autowired
    private CaptchaProperties captchaProperties;
    @Autowired
    private ValidateCodeService codeService;

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest();
            if (!StringUtil.containsAnyIgnoreCase((CharSequence)request.getURI().getPath(), (CharSequence[])VALIDATE_URL) || !this.captchaProperties.getEnabled().booleanValue()) {
                return chain.filter(exchange);
            }
            try {
                String rspStr = this.resolveBodyFromRequest(request);
                JSONObject obj = JSON.parseObject((String)rspStr);
                this.codeService.checkCaptcha(obj.getString(UUID), obj.getString(CODE));
            }
            catch (Exception e) {
                return ServletUtils.webFluxResponseWriter((ServerHttpResponse)exchange.getResponse(), (Object)e.getMessage());
            }
            return chain.filter(exchange);
        };
    }

    private String resolveBodyFromRequest(ServerHttpRequest serverHttpRequest) {
        Flux body = serverHttpRequest.getBody();
        AtomicReference bodyRef = new AtomicReference();
        body.subscribe(buffer -> {
            CharBuffer charBuffer = StandardCharsets.UTF_8.decode(buffer.asByteBuffer());
            DataBufferUtils.release((DataBuffer)buffer);
            bodyRef.set(charBuffer.toString());
        });
        return (String)bodyRef.get();
    }
}

