/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller;

import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.naming.controllers.OperatorController;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="consoleHealth")
@RequestMapping(value={"/v1/console/health"})
public class HealthController {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthController.class);
    private final ConfigInfoPersistService configInfoPersistService;
    private final OperatorController apiCommands;

    @Autowired
    public HealthController(ConfigInfoPersistService configInfoPersistService, OperatorController apiCommands) {
        this.configInfoPersistService = configInfoPersistService;
        this.apiCommands = apiCommands;
    }

    @GetMapping(value={"/liveness"})
    public ResponseEntity<String> liveness() {
        return ResponseEntity.ok().body((Object)"OK");
    }

    @GetMapping(value={"/readiness"})
    public ResponseEntity<String> readiness(HttpServletRequest request) {
        boolean isConfigReadiness = this.isConfigReadiness();
        boolean isNamingReadiness = this.isNamingReadiness(request);
        if (isConfigReadiness && isNamingReadiness) {
            return ResponseEntity.ok().body((Object)"OK");
        }
        if (!isConfigReadiness && !isNamingReadiness) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config and Naming are not in readiness");
        }
        if (!isConfigReadiness) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config is not in readiness");
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Naming is not in readiness");
    }

    private boolean isConfigReadiness() {
        try {
            this.configInfoPersistService.configInfoCount("");
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Config health check fail.", (Throwable)e);
            return false;
        }
    }

    private boolean isNamingReadiness(HttpServletRequest request) {
        try {
            this.apiCommands.metrics(request);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Naming health check fail.", (Throwable)e);
            return false;
        }
    }
}

