/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.service.advertisement.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.poi.ExcelUtil;
import gz.lp.common.core.web.controller.BaseController;
import gz.lp.common.log.annotation.Log;
import gz.lp.common.log.enums.BusinessType;
import gz.lp.service.advertisement.domain.Advertisement;
import gz.lp.service.advertisement.service.IAdvertisementService;
import gz.lp.service.advertisement.vo.AdvertisementListVo;
import gz.lp.system.api.domain.QueryAdvertisementVo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/advertisement"})
public class AdvertisementController
extends BaseController {
    @Autowired
    private IAdvertisementService advertisementService;

    @PostMapping(value={"/list"})
    public R list(@RequestBody AdvertisementListVo vo) {
        Page list = this.advertisementService.selectAdvertisementList(vo);
        return R.success((Object)list);
    }

    @Log(title="\u5e7f\u544a", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, AdvertisementListVo advertisement) {
        Page list = this.advertisementService.selectAdvertisementList(advertisement);
        ExcelUtil util = new ExcelUtil(Advertisement.class);
        util.exportExcel(response, list.getRecords(), "\u5e7f\u544a\u6570\u636e");
    }

    @GetMapping(value={"/{advertisementId}"})
    public R getInfo(@PathVariable(value="advertisementId") Integer advertisementId) {
        return R.success((Object)this.advertisementService.selectAdvertisementByAdvertisementId(advertisementId));
    }

    @Log(title="\u5e7f\u544a", businessType=BusinessType.INSERT)
    @PostMapping
    public R add(@RequestBody Advertisement advertisement) {
        return R.success((Object)this.advertisementService.insertAdvertisement(advertisement));
    }

    @Log(title="\u5e7f\u544a", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    public R edit(@RequestBody Advertisement advertisement) {
        boolean b = this.advertisementService.updateAdvertisement(advertisement);
        if (b) {
            return R.success((Object)"\u4fee\u6539\u6210\u529f");
        }
        return R.failed((String)"\u4fee\u6539\u5931\u8d25");
    }

    @Log(title="\u5e7f\u544a", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{advertisementIds}"})
    public R remove(@PathVariable Long[] advertisementIds) {
        return R.success((Object)this.advertisementService.deleteAdvertisementByAdvertisementIds(advertisementIds));
    }

    @PostMapping(value={"/queryAdvertisement"})
    public R queryAdvertisement(@RequestBody QueryAdvertisementVo vo) throws IOException {
        return R.success((Object)this.advertisementService.queryAdvertisement(vo));
    }
}

