/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.service.activity.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.service.activity.domain.Activity;
import gz.lp.service.activity.mapper.ActivityMapper;
import gz.lp.service.activity.service.IActivityService;
import gz.lp.service.activity.vo.ActivityListVo;
import gz.lp.system.api.domain.QueryByIdVo;
import gz.lp.system.api.domain.QueryListVo;
import gz.lp.system.api.model.RespQueryListVo;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityServiceImpl
extends ServiceImpl<ActivityMapper, Activity>
implements IActivityService {
    @Autowired
    private ActivityMapper activityMapper;
    private Activity activity;

    public Activity selectActivityById(Integer id) {
        return (Activity)this.getById((Serializable)id);
    }

    public Page<Activity> selectActivityList(ActivityListVo vo) {
        Page page = new Page();
        page.setCurrent((long)vo.getPageNum().intValue());
        page.setSize((long)vo.getPageSize().intValue());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"is_del", (Object)1);
        if (StrUtil.isNotBlank((CharSequence)vo.getActivityName())) {
            query.like((Object)"activity_name", (Object)vo.getActivityName());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getActivityType())) {
            query.eq((Object)"activity_type", (Object)vo.getActivityType());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getStatus())) {
            query.eq((Object)"status", (Object)vo.getStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getStartStartTime()) && StrUtil.isNotBlank((CharSequence)vo.getEndStartTime())) {
            query.between((Object)"start_time", (Object)DateUtils.parseDate((Object)vo.getStartStartTime()), (Object)DateUtils.parseDate((Object)vo.getEndStartTime()));
        }
        Page activityIPage = (Page)this.activityMapper.selectPage((IPage)page, (Wrapper)query);
        return activityIPage;
    }

    public Boolean insertActivity(Activity activity) {
        String nowDate = DateUtils.getDate();
        activity.setCreateTime(nowDate);
        activity.setUpdateTime(nowDate);
        activity.setIsDel(1);
        return this.save((Object)activity);
    }

    public R updateActivity(Activity activity) {
        this.activity = activity;
        activity.setUpdateTime(DateUtils.getDate());
        boolean b = this.updateById((Object)activity);
        if (b) {
            return R.success((Object)"\u4fee\u6539\u6210\u529f");
        }
        return R.failed((String)"\u4fee\u6539\u5931\u8d25");
    }

    public int deleteActivityByIds(Long[] ids) {
        return this.activityMapper.deleteActivityByIds(ids);
    }

    public int deleteActivityById(Long id) {
        return this.activityMapper.deleteActivityById(id);
    }

    public IPage<RespQueryListVo> queryActivity(QueryListVo vo) {
        Page page = new Page();
        page.setCurrent((long)vo.getPageNo().intValue());
        page.setSize((long)vo.getPageSize().intValue());
        return this.activityMapper.queryActivity((IPage)page, vo);
    }

    public Activity queryActivityById(QueryByIdVo vo) {
        if (SecurityUtils.getLoginUser() != null && SecurityUtils.getLoginUser().getMember() != null) {
            Integer memberId = SecurityUtils.getLoginUser().getMember().getId();
        } else {
            Object memberId = null;
        }
        return (Activity)this.getById((Serializable)vo.getId());
    }
}

