/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.service.activity.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.poi.ExcelUtil;
import gz.lp.common.core.web.controller.BaseController;
import gz.lp.common.core.web.domain.AjaxResult;
import gz.lp.common.log.annotation.Log;
import gz.lp.common.log.enums.BusinessType;
import gz.lp.service.activity.domain.ActivityRegistration;
import gz.lp.service.activity.service.IActivityRegistrationService;
import gz.lp.service.activity.vo.ActivityRegistrationListVo;
import gz.lp.service.activity.vo.ActivityRegistrationVerificationVo;
import gz.lp.service.activity.vo.GetActivityRegistrationListVo;
import gz.lp.system.api.domain.ActivityRegistrationVo;
import gz.lp.system.api.domain.QueryByIdVo;
import gz.lp.system.api.domain.QueryMyActivityVo;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/registration"})
public class ActivityRegistrationController
extends BaseController {
    @Autowired
    private IActivityRegistrationService activityRegistrationService;

    @GetMapping(value={"/list"})
    public R list(GetActivityRegistrationListVo activityRegistration) {
        Page list = this.activityRegistrationService.selectActivityRegistrationList(activityRegistration);
        return R.success((Object)list);
    }

    @PostMapping(value={"/listActivityRegistration"})
    public R listActivityRegistration(@RequestBody QueryByIdVo vo) {
        return this.activityRegistrationService.listActivityRegistration(vo);
    }

    @Log(title="\u6d3b\u52a8\u62a5\u540d", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, GetActivityRegistrationListVo activityRegistration) {
        Page list = this.activityRegistrationService.selectActivityRegistrationList(activityRegistration);
        ExcelUtil util = new ExcelUtil(ActivityRegistrationListVo.class);
        util.exportExcel(response, list.getRecords(), "\u6d3b\u52a8\u62a5\u540d\u6570\u636e");
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return this.success((Object)this.activityRegistrationService.selectActivityRegistrationById(id));
    }

    @Log(title="\u6d3b\u52a8\u62a5\u540d", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ActivityRegistration activityRegistration) {
        return this.toAjax(this.activityRegistrationService.insertActivityRegistration(activityRegistration));
    }

    @Log(title="\u6d3b\u52a8\u62a5\u540d", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ActivityRegistration activityRegistration) {
        return this.toAjax(this.activityRegistrationService.updateActivityRegistration(activityRegistration));
    }

    @Log(title="\u6d3b\u52a8\u62a5\u540d", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.activityRegistrationService.deleteActivityRegistrationByIds(ids));
    }

    @PostMapping(value={"/activityRegistrationVerification"})
    public R activityRegistrationVerification(@RequestBody ActivityRegistrationVerificationVo vo) {
        return this.activityRegistrationService.activityRegistrationVerification(vo);
    }

    @PostMapping(value={"/activityRegistration"})
    public R activityRegistration(@RequestBody ActivityRegistrationVo activityRegistration) {
        return this.activityRegistrationService.activityRegistration(activityRegistration);
    }

    @PostMapping(value={"/queryMyActivity"})
    public R queryMyActivity(@RequestBody QueryMyActivityVo vo) {
        return R.success((Object)this.activityRegistrationService.queryMyActivity(vo));
    }
}

