/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.product.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.ListUtils;
import gz.lp.common.core.utils.StringUtils;
import gz.lp.mall.file.entity.FileUrl;
import gz.lp.mall.file.service.FileUrlService;
import gz.lp.mall.product.entity.GoodsCategory;
import gz.lp.mall.product.mapper.GoodsCategoryIndexMapper;
import gz.lp.mall.product.mapper.GoodsCategoryMapper;
import gz.lp.mall.product.param.GoodsCategoryCreateValidate;
import gz.lp.mall.product.param.GoodsCategoryUpdateValidate;
import gz.lp.mall.product.service.IGoodsCategoryService;
import gz.lp.mall.product.vo.GoodsCategoryVo;
import gz.lp.mall.product.vo.ThreeCategoryVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsCategoryImpI
extends ServiceImpl<GoodsCategoryMapper, GoodsCategory>
implements IGoodsCategoryService {
    @Autowired
    GoodsCategoryMapper goodsCategoryMapper;
    @Autowired
    GoodsCategoryIndexMapper goodsCategoryIndexMapper;
    @Autowired
    FileUrlService fileUrlService;

    public JSONArray listCategory() {
        FileUrl one = (FileUrl)this.fileUrlService.getOne(null);
        String serviceUrl = one.getServiceUrl();
        List lists = this.goodsCategoryMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_delete", (Object)0)).orderByDesc((Object)"sort")).orderByAsc((Object)"id"));
        List collect = lists.stream().map(li -> li.getPid()).collect(Collectors.toList());
        ArrayList<GoodsCategoryVo> list = new ArrayList<GoodsCategoryVo>();
        for (GoodsCategory item : lists) {
            GoodsCategoryVo goodsCategoryVo = new GoodsCategoryVo();
            goodsCategoryVo.setId(item.getId());
            goodsCategoryVo.setPid(item.getPid());
            goodsCategoryVo.setName(item.getName());
            goodsCategoryVo.setIsShow(item.getIsShow());
            goodsCategoryVo.setImage(serviceUrl + item.getImage());
            goodsCategoryVo.setSort(item.getSort());
            goodsCategoryVo.setCreateTime(DateUtils.formatDate((String)DateUtils.getTime()));
            if (collect.contains(item.getId())) {
                goodsCategoryVo.setHasChildren(Boolean.valueOf(true));
                collect.removeIf(co -> co == item.getId());
            } else {
                goodsCategoryVo.setHasChildren(Boolean.valueOf(false));
            }
            list.add(goodsCategoryVo);
        }
        JSONArray jsonArray = JSONArray.parseArray((String)JSONArray.toJSONString(list, (JSONWriter.Feature[])new JSONWriter.Feature[0]), (JSONReader.Feature[])new JSONReader.Feature[0]);
        return ListUtils.listToTree((JSONArray)jsonArray, (String)"id", (String)"pid", (String)"children");
    }

    public GoodsCategoryVo detail(Integer id) {
        FileUrl one = (FileUrl)this.fileUrlService.getOne(null);
        String serviceUrl = one.getServiceUrl();
        GoodsCategory goodsCategory = (GoodsCategory)this.goodsCategoryMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"is_delete", (Object)0)).last("limit 1"));
        Assert.notNull((Object)goodsCategory, (String)"\u6570\u636e\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        GoodsCategoryVo vo = new GoodsCategoryVo();
        vo.setId(goodsCategory.getId());
        vo.setImage(serviceUrl + goodsCategory.getImage());
        vo.setName(goodsCategory.getName());
        vo.setPid(goodsCategory.getPid());
        vo.setSort(goodsCategory.getSort());
        vo.setIsShow(goodsCategory.getIsShow());
        vo.setCreateTime(goodsCategory.getCreateTime());
        return vo;
    }

    public void add(GoodsCategoryCreateValidate goodsCategoryCreateValidate) {
        GoodsCategory model = (GoodsCategory)this.goodsCategoryMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_delete", (Object)0)).eq((Object)"name", (Object)goodsCategoryCreateValidate.getName())).last("limit 1"));
        Assert.isNull((Object)model, (String)"\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (goodsCategoryCreateValidate.getPid() > 0) {
            GoodsCategory Pmodel = (GoodsCategory)this.goodsCategoryMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_delete", (Object)0)).eq((Object)"id", (Object)goodsCategoryCreateValidate.getPid())).last("limit 1"));
            Assert.notNull((Object)Pmodel, (String)"\u7236\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        GoodsCategory goodsCategory = new GoodsCategory();
        goodsCategory.setName(goodsCategoryCreateValidate.getName());
        goodsCategory.setImage(StringUtils.substringDate((String)goodsCategoryCreateValidate.getImage()));
        goodsCategory.setPid(goodsCategoryCreateValidate.getPid());
        goodsCategory.setIsShow(goodsCategoryCreateValidate.getIsShow());
        goodsCategory.setCreateTime(DateUtils.formatDate((String)DateUtils.getTime()));
        goodsCategory.setUpdateTime(DateUtils.formatDate((String)DateUtils.getTime()));
        if (goodsCategoryCreateValidate.getName().contains("\u79ef\u5206")) {
            goodsCategory.setCode("code123");
        }
        this.goodsCategoryMapper.insert((Object)goodsCategory);
    }

    public List<GoodsCategory> edit(GoodsCategoryUpdateValidate goodsCategoryUpdateValidate) {
        GoodsCategory goodsCategory = (GoodsCategory)this.goodsCategoryMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)goodsCategoryUpdateValidate.getId())).eq((Object)"is_delete", (Object)0)).last("limit 1"));
        Assert.notNull((Object)goodsCategory, (String)"\u6570\u636e\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        GoodsCategory model = (GoodsCategory)this.goodsCategoryMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().ne((Object)"id", (Object)goodsCategoryUpdateValidate.getId())).eq((Object)"is_delete", (Object)0)).eq((Object)"name", (Object)goodsCategoryUpdateValidate.getName())).last("limit 1"));
        Assert.isNull((Object)model, (String)"\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (goodsCategoryUpdateValidate.getPid() > 0) {
            GoodsCategory Pmodel = (GoodsCategory)this.goodsCategoryMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_delete", (Object)0)).eq((Object)"id", (Object)goodsCategoryUpdateValidate.getPid())).last("limit 1"));
            Assert.notNull((Object)Pmodel, (String)"\u7236\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        if (goodsCategoryUpdateValidate.getPid().equals(goodsCategory.getId())) {
            throw new ServiceException("\u7236\u7ea7\u5206\u7c7b\u4e0d\u80fd\u81ea\u5df1");
        }
        goodsCategory.setName(goodsCategoryUpdateValidate.getName());
        goodsCategory.setImage(StringUtils.substringDate((String)goodsCategoryUpdateValidate.getImage()));
        goodsCategory.setPid(goodsCategoryUpdateValidate.getPid());
        goodsCategory.setSort(goodsCategoryUpdateValidate.getSort());
        goodsCategory.setIsShow(goodsCategoryUpdateValidate.getIsShow());
        goodsCategory.setUpdateTime(DateUtils.formatDate((String)DateUtils.getTime()));
        this.goodsCategoryMapper.updateById((Object)goodsCategory);
        List categoryIds = goodsCategoryUpdateValidate.getCategoryIds();
        categoryIds.removeIf(id -> id == goodsCategoryUpdateValidate.getId());
        if (categoryIds.size() > 0) {
            Integer[] idArray = categoryIds.toArray(new Integer[0]);
            return this.goodsCategoryMapper.selectBatchIds(Arrays.asList(idArray));
        }
        return null;
    }

    public void del(Integer id) {
        GoodsCategory goodsCategory = (GoodsCategory)this.goodsCategoryMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"is_delete", (Object)0)).last("limit 1"));
        Assert.notNull((Object)goodsCategory, (String)"\u6570\u636e\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Integer goodsNum = this.goodsCategoryIndexMapper.queryGoodsNum(id);
        if (goodsNum > 0) {
            throw new ServiceException("\u5206\u7c7b\u5df2\u88ab\u4f7f\u7528,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        GoodsCategory childCategory = (GoodsCategory)this.goodsCategoryMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"pid", (Object)id)).eq((Object)"is_delete", (Object)0)).last("limit 1"));
        if (StringUtils.isNotNull((Object)childCategory)) {
            throw new ServiceException("\u5b58\u5728\u5b50\u7ea7\u5206\u7c7b,\u4e0d\u5141\u8bb8\u76f4\u63a5\u5220\u9664");
        }
        goodsCategory.setIsDelete(Integer.valueOf(1));
        this.goodsCategoryMapper.updateById((Object)goodsCategory);
    }

    public List<GoodsCategory> change(List<Integer> id) {
        Integer[] idArray = id.toArray(new Integer[0]);
        return this.goodsCategoryMapper.selectBatchIds(Arrays.asList(idArray));
    }

    public List<ThreeCategoryVo> queryThree(Integer id) {
        List goodsCategories = this.goodsCategoryMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"pid", (Object)id)).eq((Object)"is_delete", (Object)0));
        return goodsCategories.stream().map(go -> {
            ThreeCategoryVo threeCategoryVo = new ThreeCategoryVo();
            BeanUtils.copyProperties((Object)go, (Object)threeCategoryVo);
            return threeCategoryVo;
        }).collect(Collectors.toList());
    }
}

