/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.product.controller;

import com.alibaba.fastjson2.JSONArray;
import gz.lp.common.core.annotation.IDMust;
import gz.lp.common.core.api.R;
import gz.lp.common.security.annotation.InnerAuth;
import gz.lp.mall.commons.IdValidate;
import gz.lp.mall.product.param.GoodsCategoryCreateValidate;
import gz.lp.mall.product.param.GoodsCategoryUpdateValidate;
import gz.lp.mall.product.service.IGoodsCategoryService;
import gz.lp.mall.product.vo.GoodsCategoryVo;
import gz.lp.system.api.param.QueryCategoryParam;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goods/goodsCategory"})
public class GoodsCategoryController {
    @Resource
    IGoodsCategoryService iGoodsCategoryService;

    @GetMapping(value={"/list"})
    public R<JSONArray> goodsCategoryList() {
        return R.success((Object)this.iGoodsCategoryService.listCategory());
    }

    @GetMapping(value={"/detail"})
    public R<GoodsCategoryVo> detail(@Validated @IDMust @RequestParam(value="id") Integer id) {
        GoodsCategoryVo detail = this.iGoodsCategoryService.detail(id);
        return R.success((Object)detail);
    }

    @PostMapping(value={"/add"})
    public R<Object> add(@Validated @RequestBody GoodsCategoryCreateValidate goodsCategoryCreateValidate) {
        this.iGoodsCategoryService.add(goodsCategoryCreateValidate);
        return R.ok();
    }

    @PostMapping(value={"/edit"})
    public R<Object> edit(@Validated @RequestBody GoodsCategoryUpdateValidate goodsCategoryUpdateValidate) {
        List edit = this.iGoodsCategoryService.edit(goodsCategoryUpdateValidate);
        if (null != edit) {
            edit.stream().forEach(c -> c.setIsShow(goodsCategoryUpdateValidate.getIsShow()));
            this.iGoodsCategoryService.updateBatchById((Collection)edit);
        }
        return R.ok();
    }

    @PostMapping(value={"/del"})
    public R<Object> del(@Validated @RequestBody IdValidate idValidate) {
        this.iGoodsCategoryService.del((Integer)idValidate.getId().get(0));
        return R.ok();
    }

    @PostMapping(value={"/change"})
    public R<Object> change(@Validated @RequestBody IdValidate idValidate) {
        List change = this.iGoodsCategoryService.change(idValidate.getId());
        change.stream().forEach(c -> c.setIsShow(idValidate.getIsShow()));
        this.iGoodsCategoryService.updateBatchById((Collection)change);
        return R.ok();
    }

    @InnerAuth
    @GetMapping(value={"/queryCategory"})
    public R queryCategory() {
        return R.success((Object)this.iGoodsCategoryService.listCategory());
    }

    @InnerAuth
    @PostMapping(value={"/queryThreeCategory"})
    public R queryThreeCategory(@RequestBody QueryCategoryParam queryCategoryParam) {
        return R.success((Object)this.iGoodsCategoryService.queryThree(queryCategoryParam.getId()));
    }
}

