/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.order.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import gz.lp.common.core.api.R;
import gz.lp.mall.order.entity.params.RefundListSearchParam;
import gz.lp.mall.order.entity.params.RefundParam;
import gz.lp.mall.order.entity.vo.RefundListVo;
import gz.lp.mall.order.service.StoreOrderInfoService;
import gz.lp.system.api.domain.QueryByIdVo;
import gz.lp.system.api.vo.RefundStatusVo;
import gz.lp.system.api.vo.RejectRefundVo;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/orderAfter"})
public class OrderAfterController {
    @Autowired
    private StoreOrderInfoService storeOrderInfoService;

    @PostMapping(value={"/getRefundList"})
    public R<Page<RefundListVo>> getRefundList(@RequestBody RefundListSearchParam param) {
        return R.success((Object)this.storeOrderInfoService.getRefundList(param));
    }

    @PostMapping(value={"/rejectRefund"})
    public R rejectRefund(@Validated @RequestBody RejectRefundVo vo) {
        return this.storeOrderInfoService.RejectRefund(vo);
    }

    @PostMapping(value={"/refund"})
    public R refund(@RequestBody RefundParam vo) {
        return this.storeOrderInfoService.refund(vo);
    }

    @PostMapping(value={"/applyRefund"})
    public R<RefundStatusVo> applyRefund(@RequestBody QueryByIdVo vo) {
        return R.success((Object)this.storeOrderInfoService.applyRefund(vo));
    }

    @PostMapping(value={"/cancelRefund"})
    public R<RefundStatusVo> cancelRefund(@RequestBody QueryByIdVo vo) {
        return R.success((Object)this.storeOrderInfoService.cancelRefund(vo));
    }

    @PostMapping(value={"/getRefundInfo"})
    public R<RefundStatusVo> getRefundInfo(@RequestBody QueryByIdVo vo) {
        return R.success((Object)this.storeOrderInfoService.getRefundInfo(vo));
    }

    @PostMapping(value={"/refundNotify"})
    public String refundNotify(HttpServletRequest xmlData) {
        return this.storeOrderInfoService.refundNotify(xmlData);
    }
}

