/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.member.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.JsonUtils;
import gz.lp.common.core.utils.PackageUtil;
import gz.lp.mall.member.entity.PushStatistics;
import gz.lp.mall.member.mapper.MemberRentProductMapper;
import gz.lp.mall.member.mapper.PushStatisticsMapper;
import gz.lp.mall.member.service.PushStatisticsService;
import gz.lp.mall.member.vo.GetListPushStatisticsVo;
import gz.lp.mall.member.vo.GetManuallyPushDataVo;
import gz.lp.mall.member.vo.TodayPushDataVo;
import gz.lp.system.api.domain.QueryByIdsVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushStatisticsServiceImpl
extends ServiceImpl<PushStatisticsMapper, PushStatistics>
implements PushStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(PushStatisticsServiceImpl.class);
    @Autowired
    private MemberRentProductMapper memberRentProductMapper;

    public Integer saveData(PushStatistics pushStatistics) {
        ((PushStatisticsMapper)this.baseMapper).insert((Object)pushStatistics);
        return pushStatistics.getId();
    }

    public R getPushStatistics(GetListPushStatisticsVo vo) {
        vo.setPushTime(vo.getPushTime() == null ? null : DateUtils.convertIsoToDateStr((String)vo.getPushTime()));
        vo.setRePushTime(vo.getRePushTime() == null ? null : DateUtils.convertIsoToDateStr((String)vo.getRePushTime()));
        Page page = new Page((long)vo.getPageNum().intValue(), (long)vo.getPageSize().intValue());
        IPage resultPage = ((PushStatisticsMapper)this.baseMapper).getPageList((IPage)page, vo);
        return R.success((Object)resultPage);
    }

    public R pushData(QueryByIdsVo vo) {
        List pushStatistics = ((PushStatisticsMapper)this.baseMapper).selectBatchIds(Arrays.asList(vo.getIds()));
        if (pushStatistics == null || pushStatistics.isEmpty()) {
            return R.failed((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u9700\u8981\u91cd\u65b0\u63a8\u9001\u7684\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        CopyOnWriteArrayList pushData = new CopyOnWriteArrayList();
        pushStatistics.forEach(ps -> {
            List pushDataVos = JsonUtils.jsonToList((String)ps.getFailData(), TodayPushDataVo.class);
            pushData.addAll(pushDataVos);
        });
        CopyOnWriteArrayList failedPushData = new CopyOnWriteArrayList();
        CopyOnWriteArrayList successPushData = new CopyOnWriteArrayList();
        pushData.stream().filter(item -> PackageUtil.hasPackage((String)item.getName(), (Integer)item.getPeriodicityDay()));
        pushData.forEach(item -> {
            try {
                if (PackageUtil.pushPackage((String)item.getPhone(), (String)item.getName())) {
                    successPushData.add(item.getMrpId());
                } else {
                    failedPushData.add(item);
                }
            }
            catch (Exception e) {
                failedPushData.add(item);
            }
        });
        long count = pushData.stream().filter(item -> PackageUtil.hasPackage((String)item.getName(), (Integer)item.getPeriodicityDay())).count();
        String str = String.format("\u63a8\u9001\u5b8c\u6210 - \u603b\u6570\u636e\u91cf: %d, \u63a8\u9001\u6210\u529f: %d, \u63a8\u9001\u5931\u8d25: %d%n, \u5931\u8d25\u6570\u636e: %s", pushData.size(), count, failedPushData.size(), ((Object)failedPushData).toString());
        if (failedPushData.size() > 0) {
            PushStatistics ps1 = PushStatistics.builder().totalNum(Integer.valueOf(pushData.size())).successNum(Integer.valueOf((int)count)).failNum(Integer.valueOf(failedPushData.size())).pushType(Integer.valueOf(3)).rePushTime(DateUtils.getNowDate()).failData(JsonUtils.listToJson(failedPushData)).build();
            this.saveData(ps1);
            List<Integer> collect = pushStatistics.stream().map(PushStatistics::getId).filter(Objects::nonNull).collect(Collectors.toList());
            ArrayList bathEdit = new ArrayList();
            collect.forEach(id -> {
                PushStatistics ps2 = PushStatistics.builder().id(id).reId(ps1.getId()).build();
                bathEdit.add(ps2);
            });
            this.updateBatchById(bathEdit);
        }
        if (successPushData.size() > 0) {
            this.memberRentProductMapper.editPushData(successPushData, Integer.valueOf(2));
        }
        return R.success((Object)str);
    }

    public R getManuallyPushData(GetManuallyPushDataVo vo) {
        Page page = new Page((long)vo.getPageNum().intValue(), (long)vo.getPageSize().intValue());
        vo.setStartTime(vo.getStartTime() == null ? null : DateUtils.convertIsoToDateStr((String)vo.getStartTime()));
        return R.success((Object)this.memberRentProductMapper.getPageManuallyPushData((IPage)page, vo));
    }
}

