/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.coupon.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.bean.BeanUtils;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.mall.coupon.domain.Coupon;
import gz.lp.mall.coupon.domain.CouponUsage;
import gz.lp.mall.coupon.domain.dto.CouponUsageDto;
import gz.lp.mall.coupon.mapper.CouponMapper;
import gz.lp.mall.coupon.param.CouponAppParam;
import gz.lp.mall.coupon.param.CouponDetailParam;
import gz.lp.mall.coupon.param.CouponListParam;
import gz.lp.mall.coupon.service.CouponService;
import gz.lp.mall.coupon.service.CouponUsageService;
import gz.lp.mall.coupon.vo.CouponByUsageScopeVo;
import gz.lp.system.api.domain.QueryCouponByUsageScopeVo;
import gz.lp.system.api.domain.QueryMyCouponsVo;
import gz.lp.system.api.domain.RespQueryMyCouponsVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponServiceImpl
extends ServiceImpl<CouponMapper, Coupon>
implements CouponService {
    @Autowired
    private CouponMapper mapper;
    @Autowired
    private CouponUsageService couponUsageService;

    public Page<Coupon> getCouponList(CouponListParam param) {
        Page page = new Page();
        page.setCurrent((long)param.getPageNo().intValue());
        page.setSize((long)param.getPageSize().intValue());
        QueryWrapper query = new QueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)param.getCouponName())) {
            query.like((Object)"coupon_name", (Object)param.getCouponName());
        }
        if (StrUtil.isNotBlank((CharSequence)param.getCouponType())) {
            query.eq((Object)"coupon_type", (Object)param.getCouponType());
        }
        if (StrUtil.isNotBlank((CharSequence)param.getUsageScope())) {
            query.eq((Object)"usage_scope", (Object)param.getUsageScope());
        }
        if (StrUtil.isNotBlank((CharSequence)param.getStartTime()) && StrUtil.isNotBlank((CharSequence)param.getEndTime())) {
            query.between((Object)"start_time", (Object)param.getStartTime(), (Object)param.getEndTime());
        }
        if (param.getCouponStatus() != null) {
            query.eq((Object)"coupon_status", (Object)param.getCouponStatus());
        }
        query.orderByAsc((Object)"update_time");
        return (Page)this.mapper.selectPage((IPage)page, (Wrapper)query);
    }

    public Coupon getCouponDetail(CouponDetailParam param) {
        return (Coupon)this.mapper.selectById((Serializable)param.getId());
    }

    public R addCoupon(CouponAppParam param) {
        if (param == null) {
            return R.failed((String)"\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!!!");
        }
        Coupon coupon = this.BuilderCoupon(param);
        if (this.mapper.insert((Object)coupon) > 0) {
            return R.success((Object)"\u6dfb\u52a0\u6210\u529f");
        }
        return R.failed((String)"\u6dfb\u52a0\u5931\u8d25");
    }

    public R editCoupon(Coupon coupon) {
        if (coupon == null || coupon.getId() == null) {
            return R.failed((String)"\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!!!");
        }
        if (this.mapper.updateById((Object)coupon) > 0) {
            return R.success((Object)"\u4fee\u6539\u6210\u529f");
        }
        return R.failed((String)"\u4fee\u6539\u5931\u8d25");
    }

    private Coupon BuilderCoupon(CouponAppParam param) {
        Coupon coupon = Coupon.builder().couponName(param.getCouponName()).couponType(param.getCouponType()).faceValue(param.getFaceValue()).discount(param.getDiscount()).usageScope(param.getUsageScope()).limitAmount(param.getLimitAmount()).startTime(param.getStartTime()).endTime(param.getEndTime()).linkId(param.getLinkId()).couponNumber(param.getCouponNumber()).useNumber(Integer.valueOf(0)).couponStatus(param.getCouponStatus()).createTime(DateUtils.getTime()).build();
        return coupon;
    }

    public CouponUsageDto getCouponUse(Integer couponId) {
        MPJLambdaWrapper wrapper = (MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper(Coupon.class).selectAll(Coupon.class)).select(new SFunction[]{CouponUsage::getUserId, CouponUsage::getUseTime, CouponUsage::getIsUse}).selectAs(CouponUsage::getId, "usageId")).innerJoin(CouponUsage.class, CouponUsage::getCouponId, Coupon::getId)).eq(CouponUsage::getId, (Object)couponId)).eq(CouponUsage::getUserId, (Object)SecurityUtils.getLoginUser().getMember().getId())).eq(CouponUsage::getIsUse, (Object)0);
        return (CouponUsageDto)this.mapper.selectJoinOne(CouponUsageDto.class, (MPJBaseJoin)wrapper);
    }

    public IPage<RespQueryMyCouponsVo> queryMyCoupons(QueryMyCouponsVo vo) {
        Integer memberId = SecurityUtils.getLoginUser().getMember().getId();
        MPJLambdaWrapper wrapper = (MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper(Coupon.class).selectAs(Coupon::getId, "couponId")).select(new SFunction[]{Coupon::getCouponName, Coupon::getCouponType, Coupon::getFaceValue, Coupon::getDiscount, Coupon::getUsageScope, Coupon::getLimitAmount, Coupon::getStartTime, Coupon::getEndTime, Coupon::getLinkId}).select(new SFunction[]{CouponUsage::getUserId, CouponUsage::getPickUpTime}).selectAs(CouponUsage::getId, "usageId")).innerJoin(CouponUsage.class, CouponUsage::getCouponId, Coupon::getId)).eq(Coupon::getCouponStatus, (Object)1)).ge(Coupon::getEndTime, (Object)DateUtils.getTime())).eq(CouponUsage::getUserId, (Object)memberId)).eq(CouponUsage::getIsUse, (Object)0);
        return (IPage)this.mapper.selectJoinList(RespQueryMyCouponsVo.class, (MPJBaseJoin)wrapper);
    }

    public List<CouponByUsageScopeVo> getCouponByUsageScope(QueryCouponByUsageScopeVo vo) {
        QueryWrapper query = new QueryWrapper();
        if (vo.getSourceId() != null) {
            query.eq((Object)"usage_scope", (Object)vo.getSourceId());
        }
        query.eq((Object)"coupon_status", (Object)1);
        if (vo.getId() != null) {
            query.like((Object)"link_id", (Object)("|" + vo.getId().toString() + "|"));
        }
        query.ge((Object)"end_time", (Object)DateUtils.getTime());
        List coupons = this.mapper.selectList((Wrapper)query);
        if (coupons.size() == 0) {
            return new ArrayList<CouponByUsageScopeVo>();
        }
        List<Integer> collect = coupons.stream().map(Coupon::getId).toList();
        Integer memberId = SecurityUtils.getLoginUser().getMember().getId();
        List couponUse = this.couponUsageService.getCouponUse(collect, memberId);
        List<CouponByUsageScopeVo> resp = coupons.stream().map(coupon -> {
            CouponByUsageScopeVo cbs = new CouponByUsageScopeVo();
            BeanUtils.copyProperties((Object)coupon, (Object)cbs);
            cbs.setIsReceive(Boolean.valueOf(false));
            return cbs;
        }).collect(Collectors.toList());
        if (couponUse.size() > 0) {
            Map usageMap = couponUse.stream().collect(Collectors.toMap(item -> item.getCouponId().longValue(), Function.identity()));
            resp.removeIf(vo1 -> {
                CouponUsage usage = (CouponUsage)usageMap.get(vo1.getId());
                return usage != null && usage.getIsUse() == 1;
            });
            resp.forEach(vo2 -> {
                CouponUsage usage = (CouponUsage)usageMap.get(vo2.getId());
                vo2.setIsReceive(Boolean.valueOf(usage != null));
            });
        }
        return resp;
    }
}

