/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.file.utils;

import gz.lp.common.core.exception.file.FileException;
import gz.lp.common.core.exception.file.FileNameLengthLimitExceededException;
import gz.lp.common.core.exception.file.FileSizeLimitExceededException;
import gz.lp.common.core.exception.file.InvalidExtensionException;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.file.FileTypeUtils;
import gz.lp.common.core.utils.file.MimeTypeUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUploadUtils {
    public static final long DEFAULT_MAX_SIZE = 0x3200000L;
    public static final int DEFAULT_FILE_NAME_LENGTH = 100;

    public static final String upload(String baseDir, MultipartFile file) throws IOException {
        try {
            return FileUploadUtils.upload((String)baseDir, (MultipartFile)file, (String[])MimeTypeUtils.DEFAULT_ALLOWED_EXTENSION, null);
        }
        catch (FileException fe) {
            throw new IOException(fe.getMessage(), fe);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static String resetFileName(MultipartFile file) {
        String originalFileName = file.getOriginalFilename();
        String ext = "." + FilenameUtils.getExtension((String)originalFileName);
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String datePath = DateUtils.datePath();
        return datePath + "/" + uuid + ext;
    }

    public static final String upload(String baseDir, MultipartFile file, String[] allowedExtension, String upload) throws FileSizeLimitExceededException, IOException, FileNameLengthLimitExceededException, InvalidExtensionException {
        int fileNamelength = Objects.requireNonNull(file.getOriginalFilename()).length();
        if (fileNamelength > 100) {
            throw new FileNameLengthLimitExceededException(100);
        }
        FileUploadUtils.assertAllowed((MultipartFile)file, (String[])allowedExtension);
        String fileName = FileUploadUtils.extractFilename((MultipartFile)file, (String)upload);
        String absPath = FileUploadUtils.getAbsoluteFile((String)baseDir, (String)fileName).getAbsolutePath();
        file.transferTo(Paths.get(absPath, new String[0]));
        return FileUploadUtils.getPathFileName((String)fileName);
    }

    public static final Boolean delUpload(String file) {
        File goalFile = new File(file);
        if (goalFile.exists()) {
            return goalFile.delete();
        }
        return false;
    }

    public static final String extractFilename(MultipartFile file, String upload) {
        return StringUtil.format((String)"{}/{}.{}", (Object[])new Object[]{DateUtils.datePath(), upload, FileTypeUtils.getExtension((MultipartFile)file)});
    }

    private static final File getAbsoluteFile(String uploadDir, String fileName) throws IOException {
        File desc = new File(uploadDir + File.separator + fileName);
        if (!desc.exists() && !desc.getParentFile().exists()) {
            desc.getParentFile().mkdirs();
        }
        return desc.isAbsolute() ? desc : desc.getAbsoluteFile();
    }

    private static final String getPathFileName(String fileName) throws IOException {
        String pathFileName = "/" + fileName;
        return pathFileName;
    }

    public static final void assertAllowed(MultipartFile file, String[] allowedExtension) throws FileSizeLimitExceededException, InvalidExtensionException {
        long size = file.getSize();
        if (size > 0x3200000L) {
            throw new FileSizeLimitExceededException(50L);
        }
        String fileName = file.getOriginalFilename();
        String extension = FileTypeUtils.getExtension((MultipartFile)file);
        if (allowedExtension != null && !FileUploadUtils.isAllowedExtension((String)extension, (String[])allowedExtension)) {
            if (allowedExtension == MimeTypeUtils.IMAGE_EXTENSION) {
                throw new InvalidExtensionException.InvalidImageExtensionException(allowedExtension, extension, fileName);
            }
            if (allowedExtension == MimeTypeUtils.FLASH_EXTENSION) {
                throw new InvalidExtensionException.InvalidFlashExtensionException(allowedExtension, extension, fileName);
            }
            if (allowedExtension == MimeTypeUtils.MEDIA_EXTENSION) {
                throw new InvalidExtensionException.InvalidMediaExtensionException(allowedExtension, extension, fileName);
            }
            if (allowedExtension == MimeTypeUtils.VIDEO_EXTENSION) {
                throw new InvalidExtensionException.InvalidVideoExtensionException(allowedExtension, extension, fileName);
            }
            throw new InvalidExtensionException(allowedExtension, extension, fileName);
        }
    }

    public static final boolean isAllowedExtension(String extension, String[] allowedExtension) {
        for (String str : allowedExtension) {
            if (!str.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }
}

