/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.file.storage.service;

import gz.lp.file.storage.properties.StorageProperties;
import gz.lp.file.storage.service.StorageService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.springframework.util.FileCopyUtils;

public class LocalStorageService
extends StorageService {
    public LocalStorageService(StorageProperties properties) {
        this.properties = properties;
    }

    public String upload(byte[] data, String path) {
        return this.upload((InputStream)new ByteArrayInputStream(data), path);
    }

    public String upload(InputStream inputStream, String path) {
        try {
            File file = new File(this.properties.getLocal().getPath() + File.separator + path);
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("\u76ee\u5f55 '" + parent + "' \u521b\u5efa\u5931\u8d25");
            }
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a", e);
        }
        return this.properties.getConfig().getDomain() + "/" + this.properties.getLocal().getUrl() + "/" + path;
    }
}

