/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.applet.order.controller;

import gz.lp.common.core.api.R;
import gz.lp.system.api.RemoteMallService;
import gz.lp.system.api.domain.param.CreateOrderParam;
import gz.lp.system.api.domain.param.IntegralBuyParam;
import gz.lp.system.api.domain.param.OrderComputedPriceParam;
import gz.lp.system.api.domain.param.PreOrderParams;
import gz.lp.system.api.domain.vo.ComputeOrderPriceRespVo;
import gz.lp.system.api.domain.vo.PreOrderRespVo;
import gz.lp.system.api.param.QueryOrderStatusParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/order"})
public class OrderController {
    @Autowired
    private RemoteMallService remoteMallService;

    @PostMapping(value={"/preOrder"})
    public R preOrder(@RequestBody PreOrderParams params) {
        return this.remoteMallService.preOrder(params, "inner");
    }

    @PostMapping(value={"/loadPreOrder"})
    public R<PreOrderRespVo> loadPreOrder(String preOrderNo) {
        return this.remoteMallService.loadPreOrder(preOrderNo, "inner");
    }

    @PostMapping(value={"/createOrder"})
    public R createOrder(@RequestBody CreateOrderParam params) {
        return this.remoteMallService.createOrder(params, "inner");
    }

    @PostMapping(value={"/computedOrderPrice"})
    public R<ComputeOrderPriceRespVo> computedOrderPrice(@RequestBody OrderComputedPriceParam params) {
        return this.remoteMallService.computedOrderPrice(params, "inner");
    }

    @PostMapping(value={"/integralBuy"})
    public R integralBuy(@RequestBody IntegralBuyParam request) {
        return this.remoteMallService.integralBuy(request, "inner");
    }

    @PostMapping(value={"/queryOrderByOutTradeNo"})
    public R queryOrderByOutTradeNo(@RequestBody QueryOrderStatusParam param) {
        return this.remoteMallService.queryOrderByOutTradeNo(param, "inner");
    }
}

