/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.gateway.service.impl;

import cn.hutool.core.codec.Base64;
import com.google.code.kaptcha.Producer;
import gz.lp.common.core.exception.captcha.CaptchaException;
import gz.lp.common.core.utils.IdUtils;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.web.domain.AjaxResult;
import gz.lp.common.redis.util.RedisUtil;
import gz.lp.gateway.config.properties.CaptchaProperties;
import gz.lp.gateway.service.ValidateCodeService;
import jakarta.annotation.Resource;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.FastByteArrayOutputStream;

@Service
public class ValidateCodeServiceImpl
implements ValidateCodeService {
    @Resource(name="captchaProducer")
    private Producer captchaProducer;
    @Resource(name="captchaProducerMath")
    private Producer captchaProducerMath;
    @Autowired
    private CaptchaProperties captchaProperties;

    public AjaxResult createCaptcha() throws IOException, CaptchaException {
        AjaxResult ajax = AjaxResult.success();
        boolean captchaEnabled = this.captchaProperties.getEnabled();
        ajax.put("captchaEnabled", (Object)captchaEnabled);
        if (!captchaEnabled) {
            return ajax;
        }
        String uuid = IdUtils.getDefInstance().nextId().toString();
        String verifyKey = "captcha_codes:" + uuid;
        String capStr = null;
        String code = null;
        BufferedImage image = null;
        String captchaType = this.captchaProperties.getType();
        if ("math".equals(captchaType)) {
            String capText = this.captchaProducerMath.createText();
            capStr = capText.substring(0, capText.lastIndexOf("@"));
            code = capText.substring(capText.lastIndexOf("@") + 1);
            image = this.captchaProducerMath.createImage(capStr);
        } else if ("char".equals(captchaType)) {
            capStr = code = this.captchaProducer.createText();
            image = this.captchaProducer.createImage(capStr);
        }
        RedisUtil.set((String)verifyKey, code, (long)120L);
        FastByteArrayOutputStream os = new FastByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "jpg", (OutputStream)os);
        }
        catch (IOException e) {
            return AjaxResult.error((String)e.getMessage());
        }
        ajax.put("uuid", (Object)uuid);
        ajax.put("img", (Object)Base64.encode((byte[])os.toByteArray()));
        return ajax;
    }

    public void checkCaptcha(String uuid, String code) throws CaptchaException {
        if (StringUtil.isEmpty((String)code)) {
            throw new CaptchaException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)uuid)) {
            throw new CaptchaException("\u9a8c\u8bc1\u7801\u5df2\u5931\u6548");
        }
        String verifyKey = "captcha_codes:" + uuid;
        String captcha = (String)RedisUtil.get((String)verifyKey);
        RedisUtil.del((String[])new String[]{verifyKey});
        if (!code.equalsIgnoreCase(captcha)) {
            throw new CaptchaException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
    }
}

