/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.file.storage.service;

import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.IOUtils;
import gz.lp.file.storage.properties.StorageProperties;
import gz.lp.file.storage.service.StorageService;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.ServerException;

public class QiniuStorageService
extends StorageService {
    private final UploadManager uploadManager;

    public QiniuStorageService(StorageProperties properties) {
        this.properties = properties;
        this.uploadManager = new UploadManager(new Configuration(Region.autoRegion()));
    }

    public String upload(byte[] data, String path) {
        try {
            String token = Auth.create((String)this.properties.getQiniu().getAccessKey(), (String)this.properties.getQiniu().getSecretKey()).uploadToken(this.properties.getQiniu().getBucketName());
            Response res = this.uploadManager.put(data, path, token);
            if (!res.isOK()) {
                throw new ServerException(res.toString());
            }
            return path;
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a", e);
        }
    }

    public String upload(InputStream inputStream, String path) {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            return this.upload(data, path);
        }
        catch (IOException e) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a", e);
        }
    }
}

