/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.gateway.filter;

import gz.lp.common.core.utils.ServletUtils;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.jwt.JwtUtils;
import gz.lp.common.redis.util.RedisUtil;
import io.jsonwebtoken.Claims;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class JwtAuthGlobalFilter
implements GlobalFilter,
Ordered {
    private static Logger logger = LoggerFactory.getLogger(JwtAuthGlobalFilter.class);
    List<String> ignoreWhite = Arrays.asList("/mall/storeOrderInfo/payNotify", "/applet/member/login", "/mall/member/appletLogin", "/auth/login", "/auth/aes/key", "/auth/logout", "/server/websocket/*", "/api/*", "/dcapi/*", "/system/user/resetPassword", "/applet/activity/queryActivity", "/applet/activity/queryActivityById", "/applet/appAdvertisement/queryAdvertisement", "/applet/coupons/getCouponByUsageScope", "/applet/product/queryCategory", "/applet/product/queryGoodsPage", "/applet/product/queryDetail", "/applet/posts/query", "/applet/store/getStore", "/applet/store/getStoreGoods", "/applet/store/getStoreByGoods");

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        logger.info("--------------\u5168\u5c40\u8fc7\u6ee4\u5668------------------");
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpRequest.Builder mutate = request.mutate();
        String url = request.getURI().getPath();
        if (StringUtil.matches((String)url, (List)this.ignoreWhite)) {
            return chain.filter(exchange);
        }
        String token = this.getToken(request);
        if (StringUtil.isEmpty((String)token)) {
            return this.unauthorizedResponse(exchange, "\u4ee4\u724c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Claims claims = JwtUtils.parseToken((String)token);
        if (claims == null) {
            return this.unauthorizedResponse(exchange, "\u4ee4\u724c\u5df2\u8fc7\u671f\u6216\u9a8c\u8bc1\u4e0d\u6b63\u786e\uff01");
        }
        String userkey = JwtUtils.getUserKey((Claims)claims);
        boolean islogin = RedisUtil.hasKey((String)this.getTokenKey(userkey));
        if (!islogin) {
            return this.unauthorizedResponse(exchange, "\u767b\u5f55\u72b6\u6001\u5df2\u8fc7\u671f");
        }
        String userid = JwtUtils.getUserId((Claims)claims);
        String username = JwtUtils.getUserName((Claims)claims);
        if (StringUtil.isEmpty((String)userid) || StringUtil.isEmpty((String)username)) {
            return this.unauthorizedResponse(exchange, "\u4ee4\u724c\u9a8c\u8bc1\u5931\u8d25");
        }
        this.addHeader(mutate, "user_key", (Object)userkey);
        this.addHeader(mutate, "id", (Object)userid);
        this.addHeader(mutate, "user", (Object)username);
        this.removeHeader(mutate, "from-source");
        return chain.filter(exchange.mutate().request(mutate.build()).build());
    }

    private String getTokenKey(String token) {
        return "login_tokens:" + token;
    }

    private String getToken(ServerHttpRequest request) {
        String token = request.getHeaders().getFirst("Authorization");
        if (StringUtil.isNotEmpty((String)token) && token.startsWith("Bearer ")) {
            token = token.replaceFirst("Bearer ", "");
        }
        return token;
    }

    public int getOrder() {
        return -200;
    }

    private Mono<Void> unauthorizedResponse(ServerWebExchange exchange, String msg) {
        logger.error("[\u9274\u6743\u5f02\u5e38\u5904\u7406]\u8bf7\u6c42\u8def\u5f84:{}", (Object)exchange.getRequest().getPath());
        return ServletUtils.webFluxResponseWriter((ServerHttpResponse)exchange.getResponse(), (Object)msg, (int)401);
    }

    private void addHeader(ServerHttpRequest.Builder mutate, String name, Object value) {
        if (value == null) {
            return;
        }
        String valueStr = value.toString();
        String valueEncode = JwtAuthGlobalFilter.urlEncode((String)valueStr);
        mutate.header(name, new String[]{valueEncode});
    }

    private void removeHeader(ServerHttpRequest.Builder mutate, String name) {
        mutate.headers(httpHeaders -> httpHeaders.remove((Object)name)).build();
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

