/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.system.service.impl;

import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.system.api.domain.SysRole;
import gz.lp.system.api.domain.SysUser;
import gz.lp.system.domain.SysMenu;
import gz.lp.system.domain.vo.MetaVo;
import gz.lp.system.domain.vo.RouterVo;
import gz.lp.system.domain.vo.TreeSelect;
import gz.lp.system.mapper.SysMenuMapper;
import gz.lp.system.mapper.SysRoleMapper;
import gz.lp.system.mapper.SysRoleMenuMapper;
import gz.lp.system.service.ISysMenuService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysMenuServiceImpl
implements ISysMenuService {
    public static final String PREMISSION_STRING = "perms[\"{0}\"]";
    @Autowired
    private SysMenuMapper menuMapper;
    @Autowired
    private SysRoleMapper roleMapper;
    @Autowired
    private SysRoleMenuMapper roleMenuMapper;

    public List<SysMenu> selectMenuList(Long userId) {
        return this.selectMenuList(new SysMenu(), userId);
    }

    public List<SysMenu> selectMenuList(SysMenu menu, Long userId) {
        List menuList = null;
        if (SysUser.isAdmin((Long)userId)) {
            menuList = this.menuMapper.selectMenuList(menu);
        } else {
            menu.getParams().put("userId", userId);
            menuList = this.menuMapper.selectMenuListByUserId(menu);
        }
        return menuList;
    }

    public Set<String> selectMenuPermsByUserId(Long userId) {
        List perms = this.menuMapper.selectMenuPermsByUserId(userId);
        HashSet<String> permsSet = new HashSet<String>();
        for (String perm : perms) {
            if (!StringUtil.isNotEmpty((String)perm)) continue;
            permsSet.addAll(Arrays.asList(perm.trim().split(",")));
        }
        return permsSet;
    }

    public Set<String> selectMenuPermsByRoleId(Long roleId) {
        List perms = this.menuMapper.selectMenuPermsByRoleId(roleId);
        HashSet<String> permsSet = new HashSet<String>();
        for (String perm : perms) {
            if (!StringUtil.isNotEmpty((String)perm)) continue;
            permsSet.addAll(Arrays.asList(perm.trim().split(",")));
        }
        return permsSet;
    }

    public List<SysMenu> selectMenuTreeByUserId(Long userId) {
        List menus = null;
        menus = SecurityUtils.isAdmin((Long)userId) ? this.menuMapper.selectMenuTreeAll() : this.menuMapper.selectMenuTreeByUserId(userId);
        return this.getChildPerms(menus, 0);
    }

    public List<Long> selectMenuListByRoleId(Long roleId) {
        SysRole role = this.roleMapper.selectRoleById(roleId);
        return this.menuMapper.selectMenuListByRoleId(roleId, role.isMenuCheckStrictly());
    }

    public List<RouterVo> buildMenus(List<SysMenu> menus) {
        LinkedList<RouterVo> routers = new LinkedList<RouterVo>();
        for (SysMenu menu : menus) {
            RouterVo router = new RouterVo();
            router.setHidden("1".equals(menu.getVisible()));
            router.setName(this.getRouteName(menu));
            router.setPath(this.getRouterPath(menu));
            router.setComponent(this.getComponent(menu));
            router.setQuery(menu.getQuery());
            router.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon(), StringUtil.equals((CharSequence)"1", (CharSequence)menu.getIsCache()), menu.getPath()));
            List cMenus = menu.getChildren();
            if (!cMenus.isEmpty() && cMenus.size() > 0 && "M".equals(menu.getMenuType())) {
                router.setAlwaysShow(Boolean.valueOf(true));
                router.setRedirect("noRedirect");
                router.setChildren(this.buildMenus(cMenus));
            } else if (this.isMenuFrame(menu)) {
                router.setMeta(null);
                childrenList = new ArrayList<RouterVo>();
                children = new RouterVo();
                children.setPath(menu.getPath());
                children.setComponent(menu.getComponent());
                children.setName(StringUtil.capitalize((String)menu.getPath()));
                children.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon(), StringUtil.equals((CharSequence)"1", (CharSequence)menu.getIsCache()), menu.getPath()));
                children.setQuery(menu.getQuery());
                childrenList.add(children);
                router.setChildren(childrenList);
            } else if (menu.getParentId().intValue() == 0 && this.isInnerLink(menu)) {
                router.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon()));
                router.setPath("/");
                childrenList = new ArrayList();
                children = new RouterVo();
                String routerPath = this.innerLinkReplaceEach(menu.getPath());
                children.setPath(routerPath);
                children.setComponent("InnerLink");
                children.setName(StringUtil.capitalize((String)routerPath));
                children.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon(), menu.getPath()));
                childrenList.add(children);
                router.setChildren(childrenList);
            }
            routers.add(router);
        }
        return routers;
    }

    public List<SysMenu> buildMenuTree(List<SysMenu> menus) {
        List<SysMenu> returnList = new ArrayList<SysMenu>();
        List tempList = menus.stream().map(SysMenu::getMenuId).collect(Collectors.toList());
        for (SysMenu menu : menus) {
            if (tempList.contains(menu.getParentId())) continue;
            this.recursionFn(menus, menu);
            returnList.add(menu);
        }
        if (returnList.isEmpty()) {
            returnList = menus;
        }
        return returnList;
    }

    public List<TreeSelect> buildMenuTreeSelect(List<SysMenu> menus) {
        List menuTrees = this.buildMenuTree(menus);
        return menuTrees.stream().map(TreeSelect::new).collect(Collectors.toList());
    }

    public SysMenu selectMenuById(Long menuId) {
        return this.menuMapper.selectMenuById(menuId);
    }

    public boolean hasChildByMenuId(Long menuId) {
        int result = this.menuMapper.hasChildByMenuId(menuId);
        return result > 0;
    }

    public boolean checkMenuExistRole(Long menuId) {
        int result = this.roleMenuMapper.checkMenuExistRole(menuId);
        return result > 0;
    }

    public int insertMenu(SysMenu menu) {
        return this.menuMapper.insertMenu(menu);
    }

    public int updateMenu(SysMenu menu) {
        return this.menuMapper.updateMenu(menu);
    }

    public int deleteMenuById(Long menuId) {
        return this.menuMapper.deleteMenuById(menuId);
    }

    public boolean checkMenuNameUnique(SysMenu menu) {
        Long menuId = StringUtil.isNull((Object)menu.getMenuId()) ? -1L : menu.getMenuId();
        SysMenu info = this.menuMapper.checkMenuNameUnique(menu.getMenuName(), menu.getParentId());
        return !StringUtil.isNotNull((Object)info) || info.getMenuId().longValue() == menuId.longValue();
    }

    public String getRouteName(SysMenu menu) {
        String routerName = StringUtil.capitalize((String)menu.getPath());
        if (this.isMenuFrame(menu)) {
            routerName = "";
        }
        return routerName;
    }

    public String getRouterPath(SysMenu menu) {
        Object routerPath = menu.getPath();
        if (menu.getParentId().intValue() != 0 && this.isInnerLink(menu)) {
            routerPath = this.innerLinkReplaceEach((String)routerPath);
        }
        if (0 == menu.getParentId().intValue() && "M".equals(menu.getMenuType()) && "1".equals(menu.getIsFrame())) {
            routerPath = "/" + menu.getPath();
        } else if (this.isMenuFrame(menu)) {
            routerPath = "/";
        }
        return routerPath;
    }

    public String getComponent(SysMenu menu) {
        String component = "Layout";
        if (StringUtil.isNotEmpty((String)menu.getComponent()) && !this.isMenuFrame(menu)) {
            component = menu.getComponent();
        } else if (StringUtil.isEmpty((String)menu.getComponent()) && menu.getParentId().intValue() != 0 && this.isInnerLink(menu)) {
            component = "InnerLink";
        } else if (StringUtil.isEmpty((String)menu.getComponent()) && this.isParentView(menu)) {
            component = "ParentView";
        }
        return component;
    }

    public boolean isMenuFrame(SysMenu menu) {
        return menu.getParentId().intValue() == 0 && "C".equals(menu.getMenuType()) && menu.getIsFrame().equals("1");
    }

    public boolean isInnerLink(SysMenu menu) {
        return menu.getIsFrame().equals("1") && StringUtil.ishttp((String)menu.getPath());
    }

    public boolean isParentView(SysMenu menu) {
        return menu.getParentId().intValue() != 0 && "M".equals(menu.getMenuType());
    }

    public List<SysMenu> getChildPerms(List<SysMenu> list, int parentId) {
        ArrayList<SysMenu> returnList = new ArrayList<SysMenu>();
        for (SysMenu t : list) {
            if (t.getParentId() != (long)parentId) continue;
            this.recursionFn(list, t);
            returnList.add(t);
        }
        return returnList;
    }

    private void recursionFn(List<SysMenu> list, SysMenu t) {
        List childList = this.getChildList(list, t);
        t.setChildren(childList);
        for (SysMenu tChild : childList) {
            if (!this.hasChild(list, tChild)) continue;
            this.recursionFn(list, tChild);
        }
    }

    private List<SysMenu> getChildList(List<SysMenu> list, SysMenu t) {
        ArrayList<SysMenu> tlist = new ArrayList<SysMenu>();
        for (SysMenu n : list) {
            if (n.getParentId().longValue() != t.getMenuId().longValue()) continue;
            tlist.add(n);
        }
        return tlist;
    }

    private boolean hasChild(List<SysMenu> list, SysMenu t) {
        return this.getChildList(list, t).size() > 0;
    }

    public String innerLinkReplaceEach(String path) {
        return StringUtil.replaceEach((String)path, (String[])new String[]{"http://", "https://", "www.", "."}, (String[])new String[]{"", "", "", "/"});
    }
}

