/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.system.controller;

import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.web.controller.BaseController;
import gz.lp.common.core.web.domain.AjaxResult;
import gz.lp.common.core.web.page.TableDataInfo;
import gz.lp.common.log.annotation.Log;
import gz.lp.common.log.enums.BusinessType;
import gz.lp.common.redis.util.RedisUtil;
import gz.lp.common.security.annotation.RequiresPermissions;
import gz.lp.system.api.model.LoginUser;
import gz.lp.system.domain.SysUserOnline;
import gz.lp.system.service.ISysUserOnlineService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/online"})
public class SysUserOnlineController
extends BaseController {
    @Autowired
    private ISysUserOnlineService userOnlineService;

    @RequiresPermissions(value={"monitor:online:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(String ipaddr, String userName) {
        Collection keys = RedisUtil.keys((String)"login_tokens:*");
        ArrayList<SysUserOnline> userOnlineList = new ArrayList<SysUserOnline>();
        for (String key : keys) {
            LoginUser user = (LoginUser)RedisUtil.get((String)key);
            if (StringUtil.isNotEmpty((String)ipaddr) && StringUtil.isNotEmpty((String)userName)) {
                userOnlineList.add(this.userOnlineService.selectOnlineByInfo(ipaddr, userName, user));
                continue;
            }
            if (StringUtil.isNotEmpty((String)ipaddr)) {
                userOnlineList.add(this.userOnlineService.selectOnlineByIpaddr(ipaddr, user));
                continue;
            }
            if (StringUtil.isNotEmpty((String)userName)) {
                userOnlineList.add(this.userOnlineService.selectOnlineByUserName(userName, user));
                continue;
            }
            userOnlineList.add(this.userOnlineService.loginUserToUserOnline(user));
        }
        Collections.reverse(userOnlineList);
        userOnlineList.removeAll(Collections.singleton(null));
        return this.getDataTable(userOnlineList);
    }

    @RequiresPermissions(value={"monitor:online:forceLogout"})
    @Log(title="\u5728\u7ebf\u7528\u6237", businessType=BusinessType.FORCE)
    @DeleteMapping(value={"/{tokenId}"})
    public AjaxResult forceLogout(@PathVariable String tokenId) {
        RedisUtil.del((String[])new String[]{"login_tokens:" + tokenId});
        return this.success();
    }
}

