/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.system.controller;

import gz.lp.common.core.utils.poi.ExcelUtil;
import gz.lp.common.core.web.controller.BaseController;
import gz.lp.common.core.web.domain.AjaxResult;
import gz.lp.common.core.web.page.TableDataInfo;
import gz.lp.common.log.annotation.Log;
import gz.lp.common.log.enums.BusinessType;
import gz.lp.common.security.annotation.RequiresPermissions;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.system.api.domain.SysRole;
import gz.lp.system.api.domain.SysUser;
import gz.lp.system.domain.SysUserRole;
import gz.lp.system.service.ISysRoleService;
import gz.lp.system.service.ISysUserService;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/role"})
public class SysRoleController
extends BaseController {
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysUserService userService;

    @RequiresPermissions(value={"system:role:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysRole role) {
        this.startPage();
        List list = this.roleService.selectRoleList(role);
        return this.getDataTable(list);
    }

    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"system:role:export"})
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysRole role) {
        List list = this.roleService.selectRoleList(role);
        ExcelUtil util = new ExcelUtil(SysRole.class);
        util.exportExcel(response, list, "\u89d2\u8272\u6570\u636e");
    }

    @RequiresPermissions(value={"system:role:query"})
    @GetMapping(value={"/{roleId}"})
    public AjaxResult getInfo(@PathVariable Long roleId) {
        this.roleService.checkRoleDataScope(roleId);
        return this.success((Object)this.roleService.selectRoleById(roleId));
    }

    @RequiresPermissions(value={"system:role:add"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysRole role) {
        if (!this.roleService.checkRoleNameUnique(role)) {
            return this.error("\u65b0\u589e\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!this.roleService.checkRoleKeyUnique(role)) {
            return this.error("\u65b0\u589e\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u6743\u9650\u5df2\u5b58\u5728");
        }
        role.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.roleService.insertRole(role));
    }

    @RequiresPermissions(value={"system:role:edit"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysRole role) {
        this.roleService.checkRoleAllowed(role);
        this.roleService.checkRoleDataScope(role.getRoleId());
        if (!this.roleService.checkRoleNameUnique(role)) {
            return this.error("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!this.roleService.checkRoleKeyUnique(role)) {
            return this.error("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u6743\u9650\u5df2\u5b58\u5728");
        }
        role.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.roleService.updateRole(role));
    }

    @RequiresPermissions(value={"system:role:edit"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changeStatus"})
    public AjaxResult changeStatus(@RequestBody SysRole role) {
        this.roleService.checkRoleAllowed(role);
        this.roleService.checkRoleDataScope(role.getRoleId());
        role.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.roleService.updateRoleStatus(role));
    }

    @RequiresPermissions(value={"system:role:remove"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{roleIds}"})
    public AjaxResult remove(@PathVariable Long[] roleIds) {
        return this.toAjax(this.roleService.deleteRoleByIds(roleIds));
    }

    @RequiresPermissions(value={"system:role:query"})
    @GetMapping(value={"/optionselect"})
    public AjaxResult optionselect() {
        return this.success((Object)this.roleService.selectRoleAll());
    }

    @GetMapping(value={"/authUser/allocatedList"})
    public TableDataInfo allocatedList(SysUser user) {
        this.startPage();
        List list = this.userService.selectAllocatedList(user);
        return this.getDataTable(list);
    }

    @GetMapping(value={"/authUser/unallocatedList"})
    public TableDataInfo unallocatedList(SysUser user) {
        this.startPage();
        List list = this.userService.selectUnallocatedList(user);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"system:role:edit"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PutMapping(value={"/authUser/cancel"})
    public AjaxResult cancelAuthUser(@RequestBody SysUserRole userRole) {
        return this.toAjax(this.roleService.deleteAuthUser(userRole));
    }

    @RequiresPermissions(value={"system:role:edit"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PutMapping(value={"/authUser/cancelAll"})
    public AjaxResult cancelAuthUserAll(Long roleId, Long[] userIds) {
        return this.toAjax(this.roleService.deleteAuthUsers(roleId, userIds));
    }

    @RequiresPermissions(value={"system:role:edit"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PutMapping(value={"/authUser/selectAll"})
    public AjaxResult selectAuthUserAll(Long roleId, Long[] userIds) {
        this.roleService.checkRoleDataScope(roleId);
        return this.toAjax(this.roleService.insertAuthUsers(roleId, userIds));
    }
}

