/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.system.controller;

import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.IdUtils;
import gz.lp.common.core.web.controller.BaseController;
import gz.lp.common.core.web.domain.AjaxResult;
import gz.lp.common.core.web.page.TableDataInfo;
import gz.lp.common.log.annotation.Log;
import gz.lp.common.log.enums.BusinessType;
import gz.lp.common.security.annotation.RequiresPermissions;
import gz.lp.system.api.RemoteFileService;
import gz.lp.system.api.domain.FileUrl;
import gz.lp.system.domain.SysFile;
import gz.lp.system.domain.from.SysFileQueryForm;
import gz.lp.system.service.ISysFileService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/file"})
public class SysFileController
extends BaseController {
    @Autowired
    private ISysFileService sysFileService;
    @Autowired
    private RemoteFileService remoteFileService;

    @GetMapping(value={"/list"})
    public TableDataInfo list(SysFileQueryForm queryForm) {
        this.startPage();
        List list = this.sysFileService.selectSysFileList(queryForm);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"system:file:query"})
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") String id) {
        return this.success((Object)this.sysFileService.selectSysFileById(id));
    }

    @RequiresPermissions(value={"system:file:add"})
    @Log(title="\u6587\u4ef6\u4fe1\u606f\u5b58\u50a8", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysFile sysFile) {
        return this.toAjax(this.sysFileService.insertSysFile(sysFile));
    }

    @RequiresPermissions(value={"system:file:edit"})
    @Log(title="\u6587\u4ef6\u4fe1\u606f\u5b58\u50a8", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysFile sysFile) {
        return this.toAjax(this.sysFileService.updateSysFile(sysFile));
    }

    @RequiresPermissions(value={"system:file:remove"})
    @Log(title="\u6587\u4ef6\u4fe1\u606f\u5b58\u50a8", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable String[] ids) {
        return this.toAjax(this.sysFileService.deleteSysFileByIds(ids));
    }

    @PostMapping(value={"/upload"})
    public AjaxResult upload(MultipartFile file) {
        R upload = this.remoteFileService.upload(file);
        if (upload.getCode() != 200L) {
            return this.error("\u4e0a\u4f20\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        FileUrl data = (FileUrl)upload.getData();
        String url = data.getQlyURL();
        SysFile sysFile = new SysFile();
        sysFile.setId(IdUtils.getDefInstance().nextId().toString());
        sysFile.setFileUrl(url);
        this.sysFileService.insertSysFile(sysFile);
        return this.success((Object)sysFile);
    }
}

