/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.system.controller;

import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.poi.ExcelUtil;
import gz.lp.common.core.web.controller.BaseController;
import gz.lp.common.core.web.domain.AjaxResult;
import gz.lp.common.core.web.page.TableDataInfo;
import gz.lp.common.log.annotation.Log;
import gz.lp.common.log.enums.BusinessType;
import gz.lp.common.security.annotation.RequiresPermissions;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.system.api.domain.SysDictData;
import gz.lp.system.service.ISysDictDataService;
import gz.lp.system.service.ISysDictTypeService;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dict/data"})
public class SysDictDataController
extends BaseController {
    @Autowired
    private ISysDictDataService dictDataService;
    @Autowired
    private ISysDictTypeService dictTypeService;

    @RequiresPermissions(value={"system:dict:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysDictData dictData) {
        this.startPage();
        List list = this.dictDataService.selectDictDataList(dictData);
        return this.getDataTable(list);
    }

    @Log(title="\u5b57\u5178\u6570\u636e", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"system:dict:export"})
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysDictData dictData) {
        List list = this.dictDataService.selectDictDataList(dictData);
        ExcelUtil util = new ExcelUtil(SysDictData.class);
        util.exportExcel(response, list, "\u5b57\u5178\u6570\u636e");
    }

    @RequiresPermissions(value={"system:dict:query"})
    @GetMapping(value={"/{dictCode}"})
    public AjaxResult getInfo(@PathVariable Long dictCode) {
        return this.success((Object)this.dictDataService.selectDictDataById(dictCode));
    }

    @GetMapping(value={"/type/{dictType}"})
    public AjaxResult dictType(@PathVariable String dictType) {
        ArrayList data = this.dictTypeService.selectDictDataByType(dictType);
        if (StringUtil.isNull((Object)data)) {
            data = new ArrayList();
        }
        return this.success((Object)data);
    }

    @RequiresPermissions(value={"system:dict:add"})
    @Log(title="\u5b57\u5178\u6570\u636e", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysDictData dict) {
        dict.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.dictDataService.insertDictData(dict));
    }

    @RequiresPermissions(value={"system:dict:edit"})
    @Log(title="\u5b57\u5178\u6570\u636e", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysDictData dict) {
        dict.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.dictDataService.updateDictData(dict));
    }

    @RequiresPermissions(value={"system:dict:remove"})
    @Log(title="\u5b57\u5178\u7c7b\u578b", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{dictCodes}"})
    public AjaxResult remove(@PathVariable Long[] dictCodes) {
        this.dictDataService.deleteDictDataByIds(dictCodes);
        return this.success();
    }
}

