/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.service.enumeration.controller;

import gz.lp.common.core.api.R;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enum"})
public class EnumController {
    @PostMapping(value={"/getEnum"})
    public R getEnum(@RequestBody String enumType) {
        if (enumType != null) {
            enumType = enumType.replace("\"", "").trim();
        }
        try {
            String className = "gz.lp.common.core.enums.enumeration." + enumType.replace("_", "") + "Enum";
            Class<?> enumClass = Class.forName(className);
            if (!enumClass.isEnum()) {
                return R.failed((String)"\u975e\u679a\u4e3e\u7c7b\u578b");
            }
            Method getCode = enumClass.getMethod("getCode", new Class[0]);
            Method getValue = Arrays.stream(enumClass.getMethods()).filter(m -> m.getName().startsWith("getValue") || m.getName().startsWith("getDescription")).findFirst().orElseThrow();
            HashMap<Object, Object> statusMap = new HashMap<Object, Object>();
            for (Object enumConstant : enumClass.getEnumConstants()) {
                statusMap.put(getCode.invoke(enumConstant, new Object[0]), getValue.invoke(enumConstant, new Object[0]));
            }
            return R.success(statusMap);
        }
        catch (ClassNotFoundException e) {
            return R.failed((String)"\u679a\u4e3e\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return R.failed((String)"\u679a\u4e3e\u7ed3\u6784\u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }
}

