/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.service.activity.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.common.core.api.R;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.service.activity.domain.Activity;
import gz.lp.service.activity.domain.ActivityRegistration;
import gz.lp.service.activity.mapper.ActivityMapper;
import gz.lp.service.activity.mapper.ActivityRegistrationMapper;
import gz.lp.service.activity.service.IActivityRegistrationService;
import gz.lp.service.activity.service.impl.ActivityServiceImpl;
import gz.lp.service.activity.vo.ActivityRegistrationListVo;
import gz.lp.service.activity.vo.ActivityRegistrationVerificationVo;
import gz.lp.service.activity.vo.GetActivityRegistrationListVo;
import gz.lp.service.thisServiceUtil.CodeUtil;
import gz.lp.system.api.domain.ActivityRegistrationVo;
import gz.lp.system.api.domain.QueryByIdVo;
import gz.lp.system.api.domain.QueryMyActivityVo;
import gz.lp.system.api.model.RespQueryMyActivityVo;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityRegistrationServiceImpl
extends ServiceImpl<ActivityRegistrationMapper, ActivityRegistration>
implements IActivityRegistrationService {
    @Autowired
    private ActivityRegistrationMapper activityRegistrationMapper;
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActivityServiceImpl activityService;
    private final Map<Long, ReentrantLock> activityLocks = new ConcurrentHashMap();

    public ActivityRegistration selectActivityRegistrationById(Long id) {
        return this.activityRegistrationMapper.selectActivityRegistrationById(id);
    }

    public Page<ActivityRegistrationListVo> selectActivityRegistrationList(GetActivityRegistrationListVo activityRegistration) {
        Page page = new Page();
        page.setCurrent((long)activityRegistration.getPageNum().intValue());
        page.setSize((long)activityRegistration.getPageSize().intValue());
        Page getActivityRegistrationListVoPage = this.activityRegistrationMapper.selectActivityRegistrationList(page, activityRegistration);
        return getActivityRegistrationListVoPage;
    }

    public R listActivityRegistration(QueryByIdVo vo) {
        if (vo.getId() == null) {
            return R.failed((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        }
        List getActivityRegistrationListVoPage = this.activityRegistrationMapper.listActivityRegistration(vo.getId());
        return R.success((Object)getActivityRegistrationListVoPage);
    }

    public int insertActivityRegistration(ActivityRegistration activityRegistration) {
        return this.activityRegistrationMapper.insert((Object)activityRegistration);
    }

    public int updateActivityRegistration(ActivityRegistration activityRegistration) {
        return this.activityRegistrationMapper.updateActivityRegistration(activityRegistration);
    }

    public int deleteActivityRegistrationByIds(Long[] ids) {
        return this.activityRegistrationMapper.deleteActivityRegistrationByIds(ids);
    }

    public int deleteActivityRegistrationById(Long id) {
        return this.activityRegistrationMapper.deleteActivityRegistrationById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public R activityRegistration(ActivityRegistrationVo activityRegistration) {
        Long activityId = (long)activityRegistration.getId();
        this.activityLocks.computeIfAbsent(activityId, k -> new ReentrantLock());
        ReentrantLock lock = (ReentrantLock)this.activityLocks.get(activityId);
        lock.lock();
        try {
            Activity activity = (Activity)this.activityService.getById((Serializable)activityId);
            if (activity == null) {
                R r = R.failed((String)"\u6d3b\u52a8\u62a5\u540d\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
                return r;
            }
            if (activity.getParticipants() >= activity.getMaxParticipants()) {
                String strResp = "";
                strResp = activity.getActivityType() == 3 ? "\u64cd\u4f5c\u5931\u8d25\u3002\u540d\u989d\u5df2\u62a2\u5149\u3002" : "\u62a5\u540d\u5931\u8d25\u3002\u62a5\u540d\u4eba\u6570\u5df2\u6ee1\u3002";
                R r = R.failed((String)strResp);
                return r;
            }
            ActivityRegistration activityRegistration1 = (ActivityRegistration)this.activityRegistrationMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"activity_id", (Object)activity.getId())).eq((Object)"member_id", (Object)SecurityUtils.getLoginUser().getMember().getId())).eq((Object)"status", (Object)"1"));
            if (activityRegistration1 != null) {
                R r = R.failed((String)("\u64cd\u4f5c\u5931\u8d25\u3002\u60a8\u5df2\u62a5\u540d\u8be5\u6d3b\u52a8,\u6d3b\u52a8\u7801\u4e3a:" + activityRegistration1.getVerificationNumber()));
                return r;
            }
            String strVerificationNumber = null;
            try {
                strVerificationNumber = CodeUtil.generateEnrollmentNumber((String)"A");
            }
            catch (ServiceException e) {
                R r = R.failed((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u6d3b\u52a8\u540d\u989d\u5df2\u6ee1,\u8bf7\u660e\u65e5\u91cd\u65b0\u62a5\u540d!");
                lock.unlock();
                return r;
            }
            int updateRows = this.activityMapper.updateByIdWithVersion(activity);
            if (updateRows == 0) {
                R r = R.failed((String)"\u9886\u53d6\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
                return r;
            }
            ActivityRegistration one = ActivityRegistration.builder().id(null).activityId(activity.getId()).activityName(activity.getActivityName()).memberId(SecurityUtils.getLoginUser().getMember().getId()).registrationTime(DateUtils.getNowDate()).status(Integer.valueOf(1)).verificationNumber(strVerificationNumber).verificationStatus("0").isDel(Integer.valueOf(0)).build();
            this.activityRegistrationMapper.insert((Object)one);
            R r = R.success((Object)strVerificationNumber);
            return r;
        }
        finally {
            lock.unlock();
        }
    }

    public IPage<RespQueryMyActivityVo> queryMyActivity(QueryMyActivityVo vo) {
        Page page = new Page((long)vo.getPageNum().intValue(), (long)vo.getPageSize().intValue());
        vo.setMemberId(Integer.valueOf(1));
        return this.activityRegistrationMapper.queryMyActivity((IPage)page, vo);
    }

    public R activityRegistrationVerification(ActivityRegistrationVerificationVo vo) {
        if (vo.getId() == null) {
            R.failed((String)"\u6838\u9500\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        }
        if (StrUtil.isBlank((CharSequence)vo.getVerificationNumber())) {
            R.failed((String)"\u8bf7\u586b\u5199\u6838\u9500\u7801!!");
        }
        ActivityRegistration byId = (ActivityRegistration)this.getById((Serializable)vo.getId());
        if (vo.getVerificationNumber().equals(byId.getVerificationNumber())) {
            byId.setVerificationStatus("1");
            byId.setVerificationTime(DateUtils.getNowDate());
        } else {
            R.failed((String)"\u6838\u9500\u7801\u4e0d\u6b63\u786e,\u8bf7\u91cd\u65b0\u8f93\u5165!");
        }
        if (this.updateById((Object)byId)) {
            return R.success((Object)"\u6838\u9500\u6210\u529f!");
        }
        return R.failed((String)"\u6838\u9500\u5931\u8d25!");
    }
}

