/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.service.activity.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import gz.lp.common.core.api.R;
import gz.lp.common.core.utils.poi.ExcelUtil;
import gz.lp.common.core.web.controller.BaseController;
import gz.lp.common.core.web.domain.AjaxResult;
import gz.lp.common.log.annotation.Log;
import gz.lp.common.log.enums.BusinessType;
import gz.lp.service.activity.domain.Activity;
import gz.lp.service.activity.service.IActivityService;
import gz.lp.service.activity.vo.ActivityListVo;
import gz.lp.system.api.domain.QueryByIdVo;
import gz.lp.system.api.domain.QueryListVo;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/activity"})
public class ActivityController
extends BaseController {
    @Autowired
    private IActivityService activityService;

    @PostMapping(value={"/list"})
    public R list(@RequestBody ActivityListVo vo) {
        Page list = this.activityService.selectActivityList(vo);
        return R.success((Object)list);
    }

    @Log(title="\u6d3b\u52a8", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, ActivityListVo activity) {
        Page list = this.activityService.selectActivityList(activity);
        ExcelUtil util = new ExcelUtil(Activity.class);
        util.exportExcel(response, list.getRecords(), "\u6d3b\u52a8\u6570\u636e");
    }

    @GetMapping(value={"/{id}"})
    public R getInfo(@PathVariable(value="id") Integer id) {
        return R.success((Object)this.activityService.selectActivityById(id));
    }

    @Log(title="\u6d3b\u52a8", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    public R add(@RequestBody Activity activity) {
        return R.success((Object)this.activityService.insertActivity(activity));
    }

    @Log(title="\u6d3b\u52a8", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    public R edit(@RequestBody Activity activity) {
        return this.activityService.updateActivity(activity);
    }

    @Log(title="\u6d3b\u52a8", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.activityService.deleteActivityByIds(ids));
    }

    @PostMapping(value={"/queryActivity"})
    public R queryActivity(@RequestBody QueryListVo vo) {
        return R.success((Object)this.activityService.queryActivity(vo));
    }

    @PostMapping(value={"/queryActivityById"})
    public R queryActivityById(@RequestBody QueryByIdVo vo) {
        return R.success((Object)this.activityService.queryActivityById(vo));
    }
}

