/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.second.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.tools;
import gz.lp.mall.second.entity.ItemImages;
import gz.lp.mall.second.entity.SecondHandItems;
import gz.lp.mall.second.mapper.SecondHandItemsMapper;
import gz.lp.mall.second.service.ItemImagesService;
import gz.lp.mall.second.service.SecondHandItemsService;
import gz.lp.system.api.domain.param.AddAndEditSecondParam;
import gz.lp.system.api.domain.param.DeleteSecondParam;
import gz.lp.system.api.domain.param.ItemImagesParam;
import gz.lp.system.api.domain.param.QuerySecondParam;
import gz.lp.system.api.domain.param.SecondParam;
import gz.lp.system.api.domain.vo.DetailSecondVo;
import gz.lp.system.api.domain.vo.ItemImagesVo;
import gz.lp.system.api.domain.vo.SecondDetailsVo;
import gz.lp.system.api.domain.vo.SecondVo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SecondHandItemsServiceImpl
extends ServiceImpl<SecondHandItemsMapper, SecondHandItems>
implements SecondHandItemsService {
    @Autowired
    private SecondHandItemsMapper secondHandItemsMapper;
    @Autowired
    private ItemImagesService itemImagesService;

    @Transactional
    public int insertSecond(AddAndEditSecondParam addAndEditParam) {
        try {
            SecondParam secondParam = addAndEditParam.getSecondParam();
            SecondHandItems secondHandItems = new SecondHandItems();
            secondHandItems.setCreatedAt(DateUtils.formatDate((String)DateUtils.getTime()));
            BeanUtils.copyProperties((Object)secondParam, (Object)secondHandItems);
            this.secondHandItemsMapper.insert((Object)secondHandItems);
            List itemImagesParams = addAndEditParam.getItemImagesParams();
            if (itemImagesParams != null && !itemImagesParams.isEmpty()) {
                List images = itemImagesParams.stream().map(it -> {
                    ItemImages itemImages = new ItemImages();
                    BeanUtils.copyProperties((Object)it, (Object)itemImages);
                    itemImages.setCreatedAt(DateUtils.formatDate((String)DateUtils.getTime()));
                    return itemImages;
                }).collect(Collectors.toList());
                this.itemImagesService.saveBatch(images);
            }
            return secondHandItems.getItemId();
        }
        catch (Exception e) {
            this.log.error("\u63d2\u5165\u4e8c\u624b\u7269\u54c1\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u63d2\u5165\u4e8c\u624b\u7269\u54c1\u5931\u8d25", e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateSecond(AddAndEditSecondParam addAndEditParam) {
        if (addAndEditParam == null || addAndEditParam.getSecondParam() == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecondParam secondParam = addAndEditParam.getSecondParam();
        SecondHandItems secondHandItems = (SecondHandItems)this.secondHandItemsMapper.selectById((Serializable)secondParam.getItemId());
        if (secondHandItems == null) {
            throw new RuntimeException("\u4e8c\u624b\u7269\u54c1\u4e0d\u5b58\u5728");
        }
        try {
            tools.structure((Object)secondHandItems, (Object)secondParam, (Boolean)false);
            secondHandItems.setUpdatedAt(DateUtils.formatDate((String)DateUtils.getTime()));
            this.secondHandItemsMapper.updateById((Object)secondHandItems);
        }
        catch (IllegalAccessException e) {
            this.log.error("\u4fee\u6539\u4e8c\u624b\u7269\u54c1\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u4fee\u6539\u4e8c\u624b\u7269\u54c1\u5931\u8d25", e);
        }
        List itemImages = Optional.ofNullable(addAndEditParam.getItemImagesParams()).orElseGet(Collections::emptyList);
        this.processItemImages(itemImages, secondParam.getItemId());
        return 1;
    }

    public int deleteSecond(DeleteSecondParam deleteSecondParam) {
        return this.secondHandItemsMapper.deleteBatchIds((Collection)deleteSecondParam.getItemId());
    }

    public IPage<SecondVo> querySecond(QuerySecondParam querySecondParam) {
        Page secondVoPage = new Page((long)querySecondParam.getPageNo().intValue(), (long)querySecondParam.getPageSize().intValue());
        return this.secondHandItemsMapper.querySecond((IPage)secondVoPage, querySecondParam);
    }

    public SecondDetailsVo queryDetail(Integer id) {
        if (id == null || id <= 0) {
            this.log.error("\u67e5\u8be2\u4e8c\u624b\u5546\u54c1\u8be6\u60c5\u5931\u8d25: \u975e\u6cd5ID\u53c2\u6570");
            throw new IllegalArgumentException("\u5546\u54c1ID\u4e0d\u5408\u6cd5");
        }
        DetailSecondVo itemDetail = Optional.ofNullable(this.secondHandItemsMapper.queryDetail(id)).orElseThrow(() -> {
            this.log.error("\u67e5\u8be2\u4e8c\u624b\u5546\u54c1\u8be6\u60c5\u5931\u8d25: \u672a\u627e\u5230\u5bf9\u5e94\u5546\u54c1");
            return new RuntimeException("\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5df2\u4e0b\u67b6");
        });
        List imagesFuture = this.itemImagesService.list((Wrapper)new QueryWrapper().eq((Object)"item_id", (Object)id));
        List images = imagesFuture.stream().map(im -> {
            ItemImagesVo itemImagesVo = new ItemImagesVo();
            BeanUtils.copyProperties((Object)im, (Object)itemImagesVo);
            return itemImagesVo;
        }).collect(Collectors.toList());
        SecondDetailsVo secondDetailsVo = new SecondDetailsVo();
        secondDetailsVo.setDetailSecondVo(itemDetail);
        secondDetailsVo.setItemImages(images);
        return secondDetailsVo;
    }

    private void processItemImages(List<ItemImagesParam> itemImageParams, Integer itemId) {
        List newImages;
        List itemImages = itemImageParams.stream().map(param -> {
            ItemImages image = new ItemImages();
            BeanUtils.copyProperties((Object)param, (Object)image);
            return image;
        }).collect(Collectors.toList());
        Map<Boolean, List<ItemImages>> partitionedImages = itemImages.stream().collect(Collectors.partitioningBy(it -> it.getItemId() != null));
        List imageIdsToDelete = partitionedImages.getOrDefault(true, Collections.emptyList()).stream().map(ItemImages::getImageId).filter(Objects::nonNull).collect(Collectors.toList());
        if (!imageIdsToDelete.isEmpty()) {
            this.itemImagesService.removeBatchByIds(imageIdsToDelete);
        }
        if (!(newImages = partitionedImages.getOrDefault(false, Collections.emptyList()).stream().map(it -> {
            ItemImages newImage = new ItemImages();
            BeanUtils.copyProperties((Object)it, (Object)newImage);
            newImage.setItemId(itemId);
            newImage.setCreatedAt(DateUtils.formatDate((String)DateUtils.getTime()));
            return newImage;
        }).collect(Collectors.toList())).isEmpty()) {
            this.itemImagesService.saveBatch(newImages);
        }
    }
}

