/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.product.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.StringUtils;
import gz.lp.common.redis.util.RedisUtil;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.mall.cache.CacheTools;
import gz.lp.mall.cache.PageCache;
import gz.lp.mall.cache.PageResult;
import gz.lp.mall.file.entity.FileUrl;
import gz.lp.mall.file.service.FileUrlService;
import gz.lp.mall.inventory.entity.Inventory;
import gz.lp.mall.inventory.service.InventoryService;
import gz.lp.mall.product.entity.Goods;
import gz.lp.mall.product.entity.GoodsCategory;
import gz.lp.mall.product.entity.GoodsCategoryIndex;
import gz.lp.mall.product.entity.GoodsImage;
import gz.lp.mall.product.entity.GoodsSku;
import gz.lp.mall.product.entity.GoodsSkuName;
import gz.lp.mall.product.entity.GoodsSkuValue;
import gz.lp.mall.product.mapper.GoodsCategoryIndexMapper;
import gz.lp.mall.product.mapper.GoodsCategoryMapper;
import gz.lp.mall.product.mapper.GoodsImageMapper;
import gz.lp.mall.product.mapper.GoodsMapper;
import gz.lp.mall.product.mapper.GoodsSkuMapper;
import gz.lp.mall.product.mapper.GoodsSkuNameMapper;
import gz.lp.mall.product.mapper.GoodsSkuValueMapper;
import gz.lp.mall.product.param.GoodsCreateValidate;
import gz.lp.mall.product.param.GoodsSearchValidate;
import gz.lp.mall.product.param.GoodsUpdateValidate;
import gz.lp.mall.product.service.IGoodsService;
import gz.lp.mall.product.vo.AddInventoryGoodsVo;
import gz.lp.mall.product.vo.GetListByIdsAndSkuVo;
import gz.lp.mall.product.vo.GetStoreGoodsVo;
import gz.lp.mall.product.vo.GoodsDetailVo;
import gz.lp.mall.product.vo.GoodsListedVo;
import gz.lp.mall.product.vo.GoodsSkuVo;
import gz.lp.mall.product.vo.RespGetListByIdsAndSkuVo;
import gz.lp.mall.product.vo.SkuDataVo;
import gz.lp.mall.product.vo.SpecValueListVo;
import gz.lp.system.api.param.QueryGoodsDetailParam;
import gz.lp.system.api.param.QueryGoodsParam;
import gz.lp.system.api.vo.AppletGoodsDetailsVo;
import gz.lp.system.api.vo.AppletGoodsListVo;
import gz.lp.system.api.vo.GoodsDetailsVo;
import gz.lp.system.api.vo.GoodsSkuListVo;
import gz.lp.system.api.vo.PriceWithPointsVo;
import gz.lp.system.api.vo.SpecListVo;
import gz.lp.system.api.vo.SpecValueVo;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@EnableAsync
public class GoodsServiceImpI
extends ServiceImpl<GoodsMapper, Goods>
implements IGoodsService {
    @Autowired
    GoodsMapper goodsMapper;
    @Autowired
    GoodsImageMapper goodsImageMapper;
    @Autowired
    GoodsCategoryMapper goodsCategoryMapper;
    @Autowired
    GoodsCategoryIndexMapper goodsCategoryIndexMapper;
    @Autowired
    GoodsSkuMapper goodsSkuMapper;
    @Autowired
    GoodsSkuNameMapper goodsSkuNameMapper;
    @Autowired
    GoodsSkuValueMapper goodsSkuValueMapper;
    @Autowired
    FileUrlService fileUrlService;
    @Autowired
    private InventoryService inventoryService;

    public IPage<GoodsListedVo> list(GoodsSearchValidate goodsSearchValidate) {
        Integer page = goodsSearchValidate.getPageNo();
        Integer limit = goodsSearchValidate.getPageSize();
        Page goodsListedVoPage = new Page((long)page.intValue(), (long)limit.intValue());
        Page data = this.goodsMapper.queryList(goodsListedVoPage, goodsSearchValidate);
        List records = data.getRecords();
        FileUrl one = (FileUrl)this.fileUrlService.getOne(null);
        String serviceUrl = one.getServiceUrl();
        records.stream().forEach(re -> {
            if (re.getImage() != null) {
                re.setImage(serviceUrl + re.getImage());
            }
        });
        return data;
    }

    public GoodsDetailVo detail(Integer id) {
        FileUrl one = (FileUrl)this.fileUrlService.getOne(null);
        String serviceUrl = one.getServiceUrl();
        Goods goods = (Goods)this.goodsMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"is_delete", (Object)0)).last("limit 1"));
        Assert.notNull((Object)goods, (String)"\u5546\u54c1\u4e0d\u5b58\u5728\u4e86!", (Object[])new Object[0]);
        GoodsDetailVo goodsDetailVo = new GoodsDetailVo();
        BeanUtils.copyProperties((Object)goods, (Object)goodsDetailVo);
        goodsDetailVo.setContent(StringUtils.processForQuery((String)goodsDetailVo.getContent(), (String)serviceUrl));
        List goodsImages = this.goodsImageMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)id));
        LinkedList<CallSite> goodsImage = new LinkedList<CallSite>();
        for (GoodsImage image : goodsImages) {
            if (image.getImage() == null) continue;
            goodsImage.add((CallSite)((Object)(serviceUrl + image.getImage())));
        }
        goodsDetailVo.setGoodsImage(goodsImage);
        List goodsCategoryIndexList = this.goodsCategoryIndexMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)id));
        LinkedList<Integer> goodsCategory = new LinkedList<Integer>();
        for (GoodsCategoryIndex goodsCategoryIndex : goodsCategoryIndexList) {
            goodsCategory.add(goodsCategoryIndex.getCategoryId());
        }
        goodsDetailVo.setCategoryId(goodsCategory);
        List goodsSkus = this.goodsSkuMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)id));
        goodsSkus.forEach(goodsSku -> {
            if (StringUtil.isNotEmpty((String)goodsSku.getImage())) {
                goodsSku.setImage(serviceUrl + goodsSku.getImage());
            }
        });
        goodsDetailVo.setSpecValueList(goodsSkus);
        List goodsSkuNameList = this.goodsSkuNameMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)id));
        List goodsSkuValueList = this.goodsSkuValueMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)id));
        goodsSkuValueList.stream().forEach(go -> {
            String image = go.getImage();
            if (go.getImage() != null) {
                go.setImage(serviceUrl + image);
            }
        });
        ArrayList<SpecValueVo> specValue = new ArrayList<SpecValueVo>();
        for (GoodsSkuName goodsSkuName : goodsSkuNameList) {
            SpecValueVo specValueVo = new SpecValueVo();
            BeanUtils.copyProperties((Object)goodsSkuName, (Object)specValueVo);
            ArrayList<SpecListVo> specListVos = new ArrayList<SpecListVo>();
            for (GoodsSkuValue goodsSkuValue : goodsSkuValueList) {
                if (!goodsSkuValue.getSkuNameId().equals(goodsSkuName.getId())) continue;
                SpecListVo specListVo = new SpecListVo();
                BeanUtils.copyProperties((Object)goodsSkuValue, (Object)specListVo);
                String image = specListVo.getImage();
                if (image != null) {
                    if (!image.startsWith("http")) {
                        specListVo.setImage(serviceUrl + image);
                    } else {
                        specListVo.setImage(image);
                    }
                }
                specListVos.add(specListVo);
            }
            specValueVo.setSpecList(specListVos);
            specValue.add(specValueVo);
        }
        goodsDetailVo.setSpecValue(specValue);
        return goodsDetailVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(GoodsCreateValidate createValidate) {
        createValidate.setSpecValueList(this.__cartesianSpec(createValidate));
        this.__checkAddGoodsData(createValidate);
        String content = createValidate.getContent();
        Goods goods = new Goods();
        goods.setCode(createValidate.getCode());
        goods.setName(createValidate.getName());
        goods.setStatus(createValidate.getStatus());
        goods.setDescription(createValidate.getDescription());
        goods.setImage(StringUtils.substringDate((String)((String)createValidate.getGoodsImage().get(0))));
        goods.setExpressType(createValidate.getExpressType());
        goods.setExpressTemplateId(createValidate.getExpressTemplateId());
        goods.setStockWarning(createValidate.getStockWarning());
        goods.setSpecType(createValidate.getSpecType());
        goods.setSort(Integer.valueOf(createValidate.getSort() < 0 ? 0 : createValidate.getSort()));
        goods.setContent(StringUtils.processForSave((String)content));
        goods.setCreateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
        goods.setUpdateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
        goods.setIsExpress(createValidate.getIsExpress());
        goods.setIsSelffetch(createValidate.getIsSelffetch());
        goods.setRecommended(createValidate.getRecommended());
        goods.setSeven(createValidate.getSeven());
        this.goodsMapper.insert((Object)goods);
        Map goodsSkuData = this.__addGoodsSpec(goods.getId(), createValidate);
        goods.setMinPrice((BigDecimal)goodsSkuData.get("minPrice"));
        goods.setMaxPrice((BigDecimal)goodsSkuData.get("maxPrice"));
        goods.setMinLineationPrice((BigDecimal)goodsSkuData.get("minLineationPrice"));
        goods.setMaxLineationPrice((BigDecimal)goodsSkuData.get("maxLineationPrice"));
        goods.setMaxLineationPrice((BigDecimal)goodsSkuData.get("maxLineationPrice"));
        goods.setTotalStock((Integer)goodsSkuData.get("totalStock"));
        this.goodsMapper.updateById((Object)goods);
        for (String image : createValidate.getGoodsImage()) {
            GoodsImage goodsImage = new GoodsImage();
            goodsImage.setGoodsId(goods.getId());
            goodsImage.setImage(StringUtils.substringDate((String)image));
            this.goodsImageMapper.insert((Object)goodsImage);
        }
        for (Integer categoryId : createValidate.getCategoryId()) {
            GoodsCategoryIndex goodsCategoryIndex = new GoodsCategoryIndex();
            goodsCategoryIndex.setGoodsId(goods.getId());
            goodsCategoryIndex.setCategoryId(categoryId);
            this.goodsCategoryIndexMapper.insert((Object)goodsCategoryIndex);
        }
        this.delRedis();
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean edit(GoodsUpdateValidate updateValidate) {
        Goods goods = (Goods)this.goodsMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)updateValidate.getId())).eq((Object)"is_delete", (Object)0));
        Assert.notNull((Object)goods, (String)"\u5546\u54c1\u4e0d\u5b58\u5728\u4e86!", (Object[])new Object[0]);
        if (goods.getIsActivity() == 1) {
            throw new ServiceException("\u5546\u54c1\u6b63\u5728\u53c2\u52a0\u6d3b\u52a8\u4e2d\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        Integer goodsSpec = goods.getSpecType();
        String content = updateValidate.getContent();
        goods.setName(updateValidate.getName());
        goods.setCode(updateValidate.getCode());
        goods.setDescription(updateValidate.getDescription());
        goods.setStatus(updateValidate.getStatus());
        goods.setImage(StringUtils.substringDate((String)((String)updateValidate.getGoodsImage().get(0))));
        goods.setExpressTemplateId(updateValidate.getExpressTemplateId());
        goods.setExpressType(updateValidate.getExpressType());
        goods.setVirtualSalesNum(Integer.valueOf(updateValidate.getVirtualSalesNum() < 0 ? 0 : updateValidate.getVirtualSalesNum()));
        goods.setVirtualClickNum(Integer.valueOf(updateValidate.getVirtualClickNum() < 0 ? 0 : updateValidate.getVirtualClickNum()));
        goods.setStockWarning(updateValidate.getStockWarning());
        goods.setSpecType(updateValidate.getSpecType());
        goods.setContent(StringUtils.processForSave((String)content));
        goods.setSort(Integer.valueOf(updateValidate.getSort() < 0 ? 0 : updateValidate.getSort()));
        goods.setUpdateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
        goods.setIsExpress(updateValidate.getIsExpress());
        goods.setIsSelffetch(updateValidate.getIsSelffetch());
        goods.setRecommended(updateValidate.getRecommended());
        goods.setSeven(updateValidate.getSeven());
        this.goodsMapper.updateById((Object)goods);
        this.goodsCategoryIndexMapper.delete((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)goods.getId()));
        for (Integer categoryId : updateValidate.getCategoryId()) {
            GoodsCategoryIndex goodsCategoryIndex = new GoodsCategoryIndex();
            goodsCategoryIndex.setGoodsId(goods.getId());
            goodsCategoryIndex.setCategoryId(categoryId);
            this.goodsCategoryIndexMapper.insert((Object)goodsCategoryIndex);
        }
        this.goodsImageMapper.delete((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)goods.getId()));
        for (String image : updateValidate.getGoodsImage()) {
            GoodsImage goodsImage = new GoodsImage();
            goodsImage.setGoodsId(goods.getId());
            goodsImage.setImage(StringUtils.substringDate((String)image));
            this.goodsImageMapper.insert((Object)goodsImage);
        }
        Map goodsSkuData = this.__editGoodsSpec(goodsSpec, updateValidate);
        goods.setMaxPrice((BigDecimal)goodsSkuData.get("maxPrice"));
        goods.setMinPrice((BigDecimal)goodsSkuData.get("minPrice"));
        goods.setMinLineationPrice((BigDecimal)goodsSkuData.get("minLineationPrice"));
        goods.setMaxLineationPrice((BigDecimal)goodsSkuData.get("maxLineationPrice"));
        goods.setMaxLineationPrice((BigDecimal)goodsSkuData.get("maxLineationPrice"));
        goods.setTotalStock((Integer)goodsSkuData.get("totalStock"));
        this.goodsMapper.updateById((Object)goods);
        this.delRedis();
        return true;
    }

    public void del(Integer id) {
        Goods goods = (Goods)this.goodsMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"is_delete", (Object)0));
        Assert.notNull((Object)goods, (String)"\u5546\u54c1\u4e0d\u5b58\u5728\u4e86!", (Object[])new Object[0]);
        if (goods.getIsActivity() == 1) {
            throw new ServiceException("\u5546\u54c1\u6b63\u5728\u53c2\u52a0\u6d3b\u52a8\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        goods.setIsDelete(Integer.valueOf(1));
        this.goodsMapper.updateById((Object)goods);
        this.goodsCategoryIndexMapper.delByGoodsId(goods.getId());
        this.delRedis();
    }

    public void change(Integer id) {
        Goods goods = (Goods)this.goodsMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"is_delete", (Object)0));
        Assert.notNull((Object)goods, (String)"\u5546\u54c1\u4e0d\u5b58\u5728\u4e86!", (Object[])new Object[0]);
        if (goods.getIsActivity() == 1) {
            throw new ServiceException("\u5546\u54c1\u6b63\u5728\u53c2\u52a0\u6d3b\u52a8\u4e2d\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u72b6\u6001\uff01");
        }
        goods.setStatus(Integer.valueOf(goods.getStatus() == 0 ? 1 : 0));
        this.goodsMapper.updateById((Object)goods);
        this.delRedis();
    }

    public void sort(Integer id, Integer sort) {
        if (sort < 0) {
            throw new ServiceException("\u6392\u5e8f\u503c\u9700\u5927\u4e8e0");
        }
        Goods goods = (Goods)this.goodsMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"is_delete", (Object)0));
        Assert.notNull((Object)goods, (String)"\u5546\u54c1\u4e0d\u5b58\u5728\u4e86!", (Object[])new Object[0]);
        goods.setSort(sort);
        this.goodsMapper.updateById((Object)goods);
    }

    public void batchDelete(List<Integer> ids) {
        List goodsList = this.goodsMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"id", ids)).eq((Object)"is_delete", (Object)0));
        for (Goods goods : goodsList) {
            goods.setStatus(Integer.valueOf(0));
            goods.setIsDelete(Integer.valueOf(1));
            goods.setUpdateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
            this.goodsMapper.updateById((Object)goods);
        }
        this.delRedis();
    }

    public void batchUpper(List<Integer> ids) {
        List goodsList = this.goodsMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"id", ids)).eq((Object)"is_delete", (Object)0));
        for (Goods goods : goodsList) {
            goods.setStatus(Integer.valueOf(1));
            goods.setUpdateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
            this.goodsMapper.updateById((Object)goods);
        }
        this.delRedis();
    }

    public void batchLower(List<Integer> ids) {
        List goodsList = this.goodsMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"id", ids)).eq((Object)"is_delete", (Object)0));
        for (Goods goods : goodsList) {
            goods.setStatus(Integer.valueOf(0));
            goods.setUpdateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
            this.goodsMapper.updateById((Object)goods);
        }
        this.delRedis();
    }

    public PageResult<AppletGoodsListVo> queryPage(QueryGoodsParam params) {
        String cacheKey = CacheTools.generateCacheKey((QueryGoodsParam)params);
        Object o = RedisUtil.get((String)cacheKey);
        if (!ObjectUtils.isEmpty((Object)o)) {
            String jsonString = (String)o;
            PageCache cache = (PageCache)JSON.parseObject((String)jsonString, PageCache.class);
            this.asyncRefreshCache(params);
            return CacheTools.buildPageResult((PageCache)cache, (QueryGoodsParam)params);
        }
        IPage appletGoodsListVoIPage = this.updateRedis(params, cacheKey);
        List voList = CacheTools.convertToVO((List)appletGoodsListVoIPage.getRecords());
        return new PageResult(voList, params.getPageNo(), params.getPageSize(), Long.valueOf(appletGoodsListVoIPage.getTotal()));
    }

    public AppletGoodsDetailsVo AppletQueryDetail(QueryGoodsDetailParam queryGoodsDetailParam) {
        AppletGoodsDetailsVo appletGoodsDetailsVo = new AppletGoodsDetailsVo();
        FileUrl one = (FileUrl)this.fileUrlService.getOne(null);
        String serviceUrl = one.getServiceUrl();
        List goodsImages = this.goodsImageMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)queryGoodsDetailParam.getId()));
        LinkedList<CallSite> goodsImage = new LinkedList<CallSite>();
        for (GoodsImage image : goodsImages) {
            if (image.getImage() == null) continue;
            goodsImage.add((CallSite)((Object)(serviceUrl + image.getImage())));
        }
        appletGoodsDetailsVo.setGoodsImage(goodsImage);
        BigDecimal discount = null;
        Goods goods = (Goods)this.goodsMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)queryGoodsDetailParam.getId())).eq((Object)"is_delete", (Object)0)).eq((Object)"status", (Object)1));
        if (null == goods) {
            throw new ServiceException("\u5546\u54c1\u5df2\u5931\u6548!");
        }
        GoodsDetailsVo goodsDetailsVo = new GoodsDetailsVo();
        BeanUtils.copyProperties((Object)goods, (Object)goodsDetailsVo);
        goodsDetailsVo.setContent(StringUtils.processForQuery((String)goodsDetailsVo.getContent(), (String)serviceUrl));
        String s = goods.getImage() != null ? serviceUrl + goods.getImage() : goods.getImage();
        goodsDetailsVo.setImage(s);
        BigDecimal bigDecimal = this.computePrice(queryGoodsDetailParam.getId());
        goodsDetailsVo.setMinPrice(bigDecimal);
        if (discount != null) {
            goodsDetailsVo.setPrice(goodsDetailsVo.getMinPrice().multiply(discount).setScale(2, RoundingMode.HALF_UP));
        }
        appletGoodsDetailsVo.setGoodsDetailsVo(goodsDetailsVo);
        List goodsSkuNameList = this.goodsSkuNameMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)queryGoodsDetailParam.getId()));
        List goodsSkuValueList = this.goodsSkuValueMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)queryGoodsDetailParam.getId()));
        List specValue = goodsSkuNameList.stream().map(goodsSkuName -> {
            SpecValueVo specValueVo = new SpecValueVo();
            BeanUtils.copyProperties((Object)goodsSkuName, (Object)specValueVo);
            List specListVos = goodsSkuValueList.stream().filter(goodsSkuValue -> goodsSkuValue.getSkuNameId().equals(goodsSkuName.getId())).map(goodsSkuValue -> {
                SpecListVo specListVo = new SpecListVo();
                BeanUtils.copyProperties((Object)goodsSkuValue, (Object)specListVo);
                String image = specListVo.getImage();
                if (image != null) {
                    specListVo.setImage(serviceUrl + image);
                }
                return specListVo;
            }).collect(Collectors.toList());
            specValueVo.setSpecList(specListVos);
            return specValueVo;
        }).collect(Collectors.toList());
        appletGoodsDetailsVo.setSpecValue(specValue);
        List goods_id = this.goodsSkuMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)queryGoodsDetailParam.getId()));
        GoodsCategory goodsCategory = this.goodsCategoryMapper.queryInfo(((GoodsSku)goods_id.get(0)).getGoodsId());
        List collect = goods_id.stream().map(go -> {
            GoodsSkuListVo goodsSkuListVo = new GoodsSkuListVo();
            BeanUtils.copyProperties((Object)go, (Object)goodsSkuListVo);
            BigDecimal price = goodsSkuListVo.getPrice();
            if (discount != null) {
                goodsSkuListVo.setMinPrice(price.multiply(discount).setScale(2, RoundingMode.HALF_UP));
            }
            goodsSkuListVo.setImage((String)(go.getImage() != null ? serviceUrl + go.getImage() : go.getImage()));
            if ("code123".equals(goodsCategory.getCode())) {
                goodsSkuListVo.setPriceWithPointsVo(this.getPointsBySkuId(go));
            }
            if (go.getVipRatio() != 0) {
                goodsSkuListVo.setVipRatio(go.getVipRatio());
                goodsSkuListVo.setMinPrice(go.getPrice().multiply(new BigDecimal(go.getVipRatio())).divide(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
            }
            return goodsSkuListVo;
        }).collect(Collectors.toList());
        appletGoodsDetailsVo.setSpecValueList(collect);
        return appletGoodsDetailsVo;
    }

    public PriceWithPointsVo getPointsBySkuId(GoodsSku goodsSku) {
        return CacheTools.calculate((BigDecimal)goodsSku.getPrice(), (int)goodsSku.getIntegralRatio());
    }

    public BigDecimal computePrice(Integer id) {
        List goods_id = this.goodsSkuMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)id));
        GoodsSku goodsSku = goods_id.stream().min(Comparator.comparing(GoodsSku::getPrice)).orElse(null);
        return goodsSku.getPrice();
    }

    public IPage<AppletGoodsListVo> updateRedis(QueryGoodsParam params, String cacheKey) {
        Integer isVip;
        FileUrl one = (FileUrl)this.fileUrlService.getOne(null);
        String serviceUrl = one.getServiceUrl();
        IPage appletGoodsListVoIPage = this.queryDatabase(params);
        List records = appletGoodsListVoIPage.getRecords();
        records.stream().forEach(re -> {
            if (re.getImage() != null) {
                re.setImage(serviceUrl + re.getImage());
            }
        });
        List voList = CacheTools.convertToVO((List)appletGoodsListVoIPage.getRecords());
        Integer integer = (Integer)params.getCategoryId().get(0);
        GoodsCategory goodsCategory = (GoodsCategory)this.goodsCategoryMapper.selectById((Serializable)integer);
        if (goodsCategory == null) {
            return null;
        }
        if ("code123".equals(goodsCategory.getCode())) {
            Map integerPriceWithPointsVoMap = this.favorableTools(appletGoodsListVoIPage.getRecords());
            voList.forEach(item -> Optional.ofNullable((PriceWithPointsVo)integerPriceWithPointsVoMap.get(item.getId())).ifPresent(arg_0 -> ((AppletGoodsListVo)item).setPriceWithPointsVo(arg_0)));
        }
        if ((isVip = SecurityUtils.getLoginUser().getMember().getIsVip()) == 1) {
            Map integerIntegerMap = this.VIPTools(voList);
            if (!integerIntegerMap.isEmpty()) {
                voList.forEach(item -> Optional.ofNullable((Integer)integerIntegerMap.get(item.getId())).ifPresent(arg_0 -> ((AppletGoodsListVo)item).setDiscount(arg_0)));
            }
            voList.stream().filter(vo -> vo.getDiscount() != null && vo.getDiscount() != 0).forEach(vo -> vo.setMinPrice(vo.getPrice().multiply(new BigDecimal(vo.getDiscount())).divide(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP)));
        }
        PageCache updatedCache = new PageCache(voList, appletGoodsListVoIPage.getTotal());
        String jsonStr = JSON.toJSONString((Object)updatedCache);
        RedisUtil.set((String)cacheKey, (Object)jsonStr, (long)1800L);
        appletGoodsListVoIPage.setRecords(null);
        appletGoodsListVoIPage.setRecords(voList);
        return appletGoodsListVoIPage;
    }

    public Map<Integer, PriceWithPointsVo> favorableTools(List<AppletGoodsListVo> goodsList) {
        List goodsSkus = this.GetSKU(goodsList);
        return goodsSkus.stream().filter(sku -> sku.getPrice() != null && sku.getIntegralRatio() != null).collect(Collectors.groupingBy(GoodsSku::getGoodsId, Collectors.collectingAndThen(Collectors.minBy(Comparator.comparing(GoodsSku::getPrice)), optSku -> optSku.map(sku -> {
            PriceWithPointsVo calculate = CacheTools.calculate((BigDecimal)sku.getPrice(), (int)sku.getIntegralRatio());
            return calculate;
        }).orElse(null))));
    }

    public Map<Integer, Integer> VIPTools(List<AppletGoodsListVo> goodsList) {
        List goodsSkus = this.GetSKU(goodsList);
        Map<Integer, List<GoodsSku>> groupedByGoodsId = goodsSkus.stream().collect(Collectors.groupingBy(GoodsSku::getGoodsId));
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, List<GoodsSku>> entry : groupedByGoodsId.entrySet()) {
            boolean allSame;
            Integer goodsId = entry.getKey();
            List<GoodsSku> skuList = entry.getValue();
            boolean bl = allSame = skuList.stream().map(GoodsSku::getVipRatio).distinct().count() <= 1L;
            if (allSame) {
                result.put(goodsId, skuList.get(0).getVipRatio());
                continue;
            }
            Integer minRatio = skuList.stream().map(GoodsSku::getVipRatio).min(Integer::compareTo).orElse(0);
            result.put(goodsId, minRatio);
        }
        return result;
    }

    public List<GoodsSku> GetSKU(List<AppletGoodsListVo> goodsList) {
        List goodsIds = goodsList.stream().map(AppletGoodsListVo::getId).collect(Collectors.toList());
        QueryWrapper goods_id = (QueryWrapper)new QueryWrapper().in((Object)"goods_id", goodsIds);
        List goodsSkus = this.goodsSkuMapper.selectList((Wrapper)goods_id);
        if (goodsSkus == null || goodsSkus.isEmpty()) {
            return null;
        }
        return goodsSkus;
    }

    @Async
    public void asyncRefreshCache(QueryGoodsParam params) {
        String cacheKey = CacheTools.generateCacheKey((QueryGoodsParam)params);
        try {
            this.updateRedis(params, cacheKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IPage<AppletGoodsListVo> queryDatabase(QueryGoodsParam params) {
        Page appletGoodsListVoIPage = new Page((long)params.getPageNo().intValue(), (long)params.getPageSize().intValue());
        if (params.getCategoryId() == null || params.getCategoryId().size() == 0) {
            List integers = this.queryIdByName(params.getGoodName());
            params.setCategoryId(integers);
        }
        return this.goodsMapper.queryPage((IPage)appletGoodsListVoIPage, params);
    }

    public List<Integer> queryIdByName(String name) {
        List goodsCategories = this.goodsCategoryMapper.selectList((Wrapper)new QueryWrapper().like((Object)"name", (Object)name));
        return goodsCategories.stream().map(go -> go.getId()).collect(Collectors.toList());
    }

    private Map<String, Object> __statistics(QueryWrapper<Goods> queryWrapper) {
        LinkedHashMap<String, Object> statistics = new LinkedHashMap<String, Object>();
        QueryWrapper salesNumWrapper = (QueryWrapper)queryWrapper.clone();
        Long salesNum = this.goodsMapper.selectCount((Wrapper)salesNumWrapper.eq((Object)"status", (Object)1));
        QueryWrapper warningNumWrapper = (QueryWrapper)queryWrapper.clone();
        Long warningNum = this.goodsMapper.selectCount((Wrapper)warningNumWrapper.apply("stock_warning > total_stock", new Object[0]));
        QueryWrapper storageNumWrapper = (QueryWrapper)queryWrapper.clone();
        Long storageNum = this.goodsMapper.selectCount((Wrapper)storageNumWrapper.eq((Object)"status", (Object)0));
        statistics.put("salesNum", salesNum);
        statistics.put("warningNum", warningNum);
        statistics.put("storageNum", storageNum);
        return statistics;
    }

    private List<GoodsSkuVo> __cartesianSpec(GoodsCreateValidate goodsCreateValidate) {
        List specValue = goodsCreateValidate.getSpecValue();
        ArrayList<Iterator<String>> specLists = new ArrayList<Iterator<String>>();
        List specValueList = goodsCreateValidate.getSpecValueList();
        if (specValueList.size() == 1) {
            return specValueList;
        }
        for (SpecValueVo specValueVo : specValue) {
            List specList = specValueVo.getSpecList();
            Iterator<String> specName = new ArrayList();
            for (SpecListVo specListVo : specList) {
                specName.add(specListVo.getValue());
            }
            specLists.add(specName);
        }
        List firstList = (List)specLists.get(0);
        specLists.remove(0);
        ArrayList<SpecValueListVo> VoLists = new ArrayList<SpecValueListVo>();
        int firstKey = 0;
        for (String string : firstList) {
            SpecValueListVo specValueListVo = new SpecValueListVo();
            specValueListVo.setIds(Integer.toString(firstKey));
            specValueListVo.setValue(string);
            ++firstKey;
            VoLists.add(specValueListVo);
        }
        for (List list : specLists) {
            ArrayList<SpecValueListVo> list2 = new ArrayList<SpecValueListVo>();
            for (SpecValueListVo voList : VoLists) {
                int specKey = 0;
                for (String spec : list) {
                    SpecValueListVo specValueListVo = new SpecValueListVo();
                    specValueListVo.setValue(voList.getValue() + "," + spec);
                    specValueListVo.setIds(voList.getIds() + "," + specKey);
                    list2.add(specValueListVo);
                    ++specKey;
                }
            }
            VoLists = list2;
        }
        ArrayList<GoodsSkuVo> serviceSpecGoods = new ArrayList<GoodsSkuVo>();
        for (SpecValueListVo voList : VoLists) {
            String ids = "";
            for (GoodsSkuVo goodsSku : specValueList) {
                if (!goodsSku.getIds().equals(voList.getIds())) continue;
                ids = goodsSku.getIds();
                serviceSpecGoods.add(goodsSku);
            }
            if (!ids.equals("")) continue;
            throw new ServiceException("\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u9519\u8bef!");
        }
        serviceSpecGoods.stream().forEach(s -> {
            String image = s.getImage();
            s.setImage(StringUtils.substringDate((String)image));
        });
        return serviceSpecGoods;
    }

    public List<GoodsSkuVo> __cartesianSpec(GoodsUpdateValidate goodsUpdateValidate) {
        ArrayList specLists = new ArrayList();
        List specValue = goodsUpdateValidate.getSpecValue();
        List specValueList = goodsUpdateValidate.getSpecValueList();
        if (1 == specValueList.size()) {
            return specValueList;
        }
        for (SpecValueVo specValueVo : specValue) {
            ArrayList<String> specName = new ArrayList<String>();
            Iterator specList = specValueVo.getSpecList();
            Iterator iterator = specList.iterator();
            while (iterator.hasNext()) {
                SpecListVo specListVo = (SpecListVo)iterator.next();
                specName.add(specListVo.getValue());
            }
            specLists.add(specName);
        }
        ArrayList<SpecValueListVo> VoLists = new ArrayList<SpecValueListVo>();
        List firstList = (List)specLists.get(0);
        specLists.remove(0);
        int firstKey = 0;
        for (String string : firstList) {
            SpecValueListVo specValueListVo = new SpecValueListVo();
            specValueListVo.setValue(string);
            specValueListVo.setIds(Integer.toString(firstKey));
            ++firstKey;
            VoLists.add(specValueListVo);
        }
        for (List list : specLists) {
            ArrayList<SpecValueListVo> list2 = new ArrayList<SpecValueListVo>();
            for (SpecValueListVo voList : VoLists) {
                int specKey = 0;
                for (String spec : list) {
                    SpecValueListVo specValueListVo = new SpecValueListVo();
                    specValueListVo.setIds(voList.getIds() + "," + specKey);
                    specValueListVo.setValue(voList.getValue() + "," + spec);
                    list2.add(specValueListVo);
                    ++specKey;
                }
            }
            VoLists = list2;
        }
        ArrayList<GoodsSkuVo> serviceSpecGoods = new ArrayList<GoodsSkuVo>();
        for (SpecValueListVo voList : VoLists) {
            String ids = "";
            for (GoodsSkuVo goodsSku : specValueList) {
                if (!goodsSku.getIds().equals(voList.getIds())) continue;
                ids = goodsSku.getIds();
                serviceSpecGoods.add(goodsSku);
            }
            if (!ids.equals("")) continue;
            throw new ServiceException("\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u9519\u8bef");
        }
        return serviceSpecGoods;
    }

    private Map<String, Object> __addGoodsSpec(Integer goodsId, GoodsCreateValidate goodsCreateValidate) {
        Integer specType = goodsCreateValidate.getSpecType();
        LinkedHashMap<String, Object> goodsSkuData = new LinkedHashMap<String, Object>();
        for (GoodsSkuVo goodSkuVo : goodsCreateValidate.getSpecValueList()) {
            if (goodSkuVo.getPrice().compareTo(BigDecimal.ZERO) <= 0) {
                throw new ServiceException("\u9500\u552e\u4ef7\u683c\u4e0d\u80fd\u5c11\u4e8e\u7b49\u4e8e0");
            }
            if (goodSkuVo.getStock() >= 0) continue;
            throw new ServiceException("\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u5c11\u4e8e0");
        }
        if (1 == specType) {
            GoodsSkuName goodsSkuName = new GoodsSkuName();
            goodsSkuName.setGoodsId(goodsId);
            goodsSkuName.setName("\u9ed8\u8ba4");
            this.goodsSkuNameMapper.insert((Object)goodsSkuName);
            GoodsSkuValue goodsSkuValue = new GoodsSkuValue();
            goodsSkuValue.setGoodsId(goodsId);
            goodsSkuValue.setValue("\u9ed8\u8ba4");
            goodsSkuValue.setSkuNameId(goodsSkuName.getId());
            this.goodsSkuValueMapper.insert((Object)goodsSkuValue);
            GoodsSku goodsSku = new GoodsSku();
            BeanUtils.copyProperties(goodsCreateValidate.getSpecValueList().get(0), (Object)goodsSku);
            goodsSku.setGoodsId(goodsId);
            goodsSku.setSkuValueIds(goodsSkuValue.getId().toString());
            goodsSku.setSkuValueArr("\u9ed8\u8ba4");
            goodsSku.setImage(StringUtils.substringDate((String)goodsSku.getImage()));
            this.goodsSkuMapper.insert((Object)goodsSku);
            goodsSkuData.put("minPrice", goodsSku.getPrice());
            goodsSkuData.put("maxPrice", goodsSku.getPrice());
            goodsSkuData.put("minLineationPrice", goodsSku.getLinePrice());
            goodsSkuData.put("maxLineationPrice", goodsSku.getLinePrice());
        } else {
            List specValue = goodsCreateValidate.getSpecValue();
            LinkedHashMap<String, Integer> specListData = new LinkedHashMap<String, Integer>();
            for (SpecValueVo specValueVo : specValue) {
                GoodsSkuName goodsSkuName = new GoodsSkuName();
                goodsSkuName.setGoodsId(goodsId);
                goodsSkuName.setName(specValueVo.getName());
                goodsSkuName.setHasImage(specValueVo.getHasImage());
                this.goodsSkuNameMapper.insert((Object)goodsSkuName);
                List specList = specValueVo.getSpecList();
                for (SpecListVo specListVo : specList) {
                    GoodsSkuValue goodsSkuValue = new GoodsSkuValue();
                    goodsSkuValue.setGoodsId(goodsId);
                    goodsSkuValue.setSkuNameId(goodsSkuName.getId());
                    goodsSkuValue.setValue(specListVo.getValue());
                    goodsSkuValue.setImage(StringUtils.substringDate((String)specListVo.getImage()));
                    this.goodsSkuValueMapper.insert((Object)goodsSkuValue);
                    specListData.put(specListVo.getValue(), goodsSkuValue.getId());
                }
            }
            List serviceSpecValueList = goodsCreateValidate.getSpecValueList();
            LinkedList<BigDecimal> priceList = new LinkedList<BigDecimal>();
            LinkedList<BigDecimal> lineationPrice = new LinkedList<BigDecimal>();
            Integer totalStock = 0;
            for (GoodsSkuVo goodsSkuVo : serviceSpecValueList) {
                String skuValueArr = goodsSkuVo.getSkuValueArr();
                String[] skuValueArrList = skuValueArr.split(",");
                StringBuilder skuIds = new StringBuilder();
                for (String skuName : skuValueArrList) {
                    Integer skuNameId = (Integer)specListData.get(skuName);
                    if (skuIds.toString().equals("")) {
                        skuIds = new StringBuilder(skuNameId.toString());
                        continue;
                    }
                    skuIds.append(",").append(skuNameId.toString());
                }
                goodsSkuVo.setSkuValueIds(skuIds.toString());
                goodsSkuVo.setGoodsId(goodsId);
                GoodsSku goodsSku = new GoodsSku();
                BeanUtils.copyProperties((Object)goodsSkuVo, (Object)goodsSku);
                this.goodsSkuMapper.insert((Object)goodsSku);
                priceList.add(goodsSkuVo.getPrice());
                lineationPrice.add(StringUtils.isNull((Object)goodsSkuVo.getLinePrice()) ? new BigDecimal(0) : goodsSkuVo.getLinePrice());
                totalStock = totalStock + goodsSkuVo.getStock();
            }
            goodsSkuData.put("minPrice", Collections.min(priceList));
            goodsSkuData.put("maxPrice", Collections.max(priceList));
            goodsSkuData.put("minLineationPrice", Collections.min(lineationPrice));
            goodsSkuData.put("maxLineationPrice", Collections.max(lineationPrice));
            goodsSkuData.put("totalStock", totalStock);
        }
        return goodsSkuData;
    }

    private Map<String, Object> __editGoodsSpec(Integer oldGoodsSpec, GoodsUpdateValidate goodsUpdateValidate) {
        LinkedHashMap<String, Integer> whereMap;
        LinkedHashMap<String, Object> goodsSkuData = new LinkedHashMap<String, Object>();
        LinkedList<BigDecimal> priceList = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> lineationPrice = new LinkedList<BigDecimal>();
        Integer totalStock = 0;
        for (GoodsSkuVo goodSkuVo : goodsUpdateValidate.getSpecValueList()) {
            if (goodSkuVo.getPrice().compareTo(BigDecimal.ZERO) <= 0) {
                throw new ServiceException("\u9500\u552e\u4ef7\u683c\u4e0d\u80fd\u5c11\u4e8e\u7b49\u4e8e0");
            }
            if (ObjectUtils.isEmpty((Object)goodSkuVo.getLinePrice())) {
                goodSkuVo.setLinePrice(BigDecimal.ZERO);
            } else if (goodSkuVo.getLinePrice().compareTo(BigDecimal.ZERO) < 0) {
                throw new ServiceException("\u5212\u7ebf\u4ef7\u683c\u4e0d\u80fd\u5c11\u4e8e0");
            }
            if (ObjectUtils.isEmpty((Object)goodSkuVo.getMarketPrice())) {
                goodSkuVo.setMarketPrice(BigDecimal.ZERO);
            } else if (goodSkuVo.getMarketPrice().compareTo(BigDecimal.ZERO) < 0) {
                throw new ServiceException("\u5e02\u573a\u4ef7\u683c\u4e0d\u80fd\u5c11\u4e8e0");
            }
            if (ObjectUtils.isEmpty((Object)goodSkuVo.getStock()) || goodSkuVo.getStock() < 0) {
                throw new ServiceException("\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u5c11\u4e8e0");
            }
            if (ObjectUtils.isEmpty((Object)goodSkuVo.getWeight())) {
                goodSkuVo.setWeight(Double.valueOf(0.0));
            } else if (goodSkuVo.getWeight() < 0.0) {
                throw new ServiceException("\u91cd\u91cf\u503c\u4e0d\u80fd\u5c11\u4e8e0");
            }
            if (ObjectUtils.isEmpty((Object)goodSkuVo.getVolume())) {
                goodSkuVo.setVolume(Double.valueOf(0.0));
            } else if (goodSkuVo.getVolume() < 0.0) {
                throw new ServiceException("\u4f53\u79ef\u503c\u4e0d\u80fd\u5c11\u4e8e0");
            }
            if (!ObjectUtils.isEmpty((Object)goodSkuVo.getCode())) continue;
            goodSkuVo.setCode("");
        }
        if (1 == goodsUpdateValidate.getSpecType()) {
            if (1 == oldGoodsSpec) {
                GoodsSku goodsSku = (GoodsSku)this.goodsSkuMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)goodsUpdateValidate.getId()));
                BeanUtils.copyProperties(goodsUpdateValidate.getSpecValueList().get(0), (Object)goodsSku);
                goodsSku.setGoodsId(goodsUpdateValidate.getId());
                goodsSku.setSkuValueArr("\u9ed8\u8ba4");
                goodsSku.setImage(goodsSku.getImage());
                this.goodsSkuMapper.updateById((Object)goodsSku);
                priceList.add(goodsSku.getPrice());
                lineationPrice.add(goodsSku.getLinePrice());
                totalStock = goodsSku.getStock();
            } else {
                whereMap = new LinkedHashMap<String, Integer>();
                whereMap.put("goods_id", goodsUpdateValidate.getId());
                this.goodsSkuNameMapper.deleteByMap(whereMap);
                this.goodsSkuValueMapper.deleteByMap(whereMap);
                this.goodsSkuMapper.deleteByMap(whereMap);
                GoodsSkuName goodsSkuName = new GoodsSkuName();
                goodsSkuName.setGoodsId(goodsUpdateValidate.getId());
                goodsSkuName.setName("\u9ed8\u8ba4");
                this.goodsSkuNameMapper.insert((Object)goodsSkuName);
                GoodsSkuValue goodsSkuValue = new GoodsSkuValue();
                goodsSkuValue.setGoodsId(goodsUpdateValidate.getId());
                goodsSkuValue.setValue("\u9ed8\u8ba4");
                goodsSkuValue.setSkuNameId(goodsSkuName.getId());
                this.goodsSkuValueMapper.insert((Object)goodsSkuValue);
                GoodsSku goodsSku = new GoodsSku();
                BeanUtils.copyProperties(goodsUpdateValidate.getSpecValueList().get(0), (Object)goodsSku);
                goodsSku.setGoodsId(goodsUpdateValidate.getId());
                goodsSku.setSkuValueIds(goodsSkuValue.getId().toString());
                goodsSku.setSkuValueArr("\u9ed8\u8ba4");
                goodsSku.setImage(StringUtils.substringDate((String)goodsSku.getImage()));
                this.goodsSkuMapper.insert((Object)goodsSku);
                priceList.add(goodsSku.getPrice());
                lineationPrice.add(goodsSku.getLinePrice());
                totalStock = goodsSku.getStock();
            }
        }
        if (1 != goodsUpdateValidate.getSpecType()) {
            if (1 == oldGoodsSpec) {
                whereMap = new LinkedHashMap();
                whereMap.put("goods_id", goodsUpdateValidate.getId());
                this.goodsSkuNameMapper.deleteByMap(whereMap);
                this.goodsSkuValueMapper.deleteByMap(whereMap);
                this.goodsSkuMapper.deleteByMap(whereMap);
                List specValue = goodsUpdateValidate.getSpecValue();
                LinkedHashMap<String, Integer> specListData = new LinkedHashMap<String, Integer>();
                for (Object specValueVo : specValue) {
                    GoodsSkuName goodsSkuName = new GoodsSkuName();
                    goodsSkuName.setGoodsId(goodsUpdateValidate.getId());
                    goodsSkuName.setName(specValueVo.getName());
                    goodsSkuName.setHasImage(specValueVo.getHasImage());
                    this.goodsSkuNameMapper.insert((Object)goodsSkuName);
                    List specList = specValueVo.getSpecList();
                    for (SpecListVo specListVo : specList) {
                        GoodsSkuValue goodsSkuValue = new GoodsSkuValue();
                        goodsSkuValue.setGoodsId(goodsUpdateValidate.getId());
                        goodsSkuValue.setSkuNameId(goodsSkuName.getId());
                        goodsSkuValue.setValue(specListVo.getValue());
                        goodsSkuValue.setImage(StringUtils.substringDate((String)specListVo.getImage()));
                        this.goodsSkuValueMapper.insert((Object)goodsSkuValue);
                        specListData.put(specListVo.getValue(), goodsSkuValue.getId());
                    }
                }
                List serviceSpecValueList = goodsUpdateValidate.getSpecValueList();
                for (GoodsSkuVo goodsSkuVo : serviceSpecValueList) {
                    String skuValueArr = goodsSkuVo.getSkuValueArr();
                    GoodsSkuValue skuValueArrList = skuValueArr.split(",");
                    StringBuilder skuIds = new StringBuilder();
                    for (String skuName : skuValueArrList) {
                        Integer skuNameId = (Integer)specListData.get(skuName);
                        if (skuIds.toString().equals("")) {
                            skuIds = new StringBuilder(skuNameId.toString());
                            continue;
                        }
                        skuIds.append(",").append(skuNameId.toString());
                    }
                    goodsSkuVo.setSkuValueIds(skuIds.toString());
                    goodsSkuVo.setGoodsId(goodsUpdateValidate.getId());
                    GoodsSku goodsSku = new GoodsSku();
                    BeanUtils.copyProperties((Object)goodsSkuVo, (Object)goodsSku);
                    this.goodsSkuMapper.insert((Object)goodsSku);
                    priceList.add(goodsSkuVo.getPrice());
                    lineationPrice.add(goodsSkuVo.getLinePrice());
                    totalStock = totalStock + goodsSkuVo.getStock();
                }
            } else {
                goodsUpdateValidate.setSpecValueList(this.__cartesianSpec(goodsUpdateValidate));
                List specValueVoLists = goodsUpdateValidate.getSpecValue();
                List specNameLists = this.goodsSkuNameMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)goodsUpdateValidate.getId()));
                List skuValueLists = this.goodsSkuValueMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)goodsUpdateValidate.getId()));
                List goodsSkuLists = this.goodsSkuMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"goods_id", (Object)goodsUpdateValidate.getId()));
                LinkedList<Integer> goodsSkuIds = new LinkedList<Integer>();
                LinkedList<Integer> specValueNameIds = new LinkedList<Integer>();
                LinkedList<Integer> goodsSkuValueIds = new LinkedList<Integer>();
                LinkedHashMap<String, Integer> specListData = new LinkedHashMap<String, Integer>();
                for (GoodsSkuName specNameList : specNameLists) {
                    specValueNameIds.add(specNameList.getId());
                }
                for (GoodsSkuValue skuValueList : skuValueLists) {
                    goodsSkuValueIds.add(skuValueList.getId());
                }
                for (GoodsSku goodsSkuList : goodsSkuLists) {
                    goodsSkuIds.add(goodsSkuList.getId());
                }
                for (SpecValueVo specValueVoList : specValueVoLists) {
                    GoodsSkuName goodsSkuName = new GoodsSkuName();
                    goodsSkuName.setName(specValueVoList.getName());
                    goodsSkuName.setGoodsId(goodsUpdateValidate.getId());
                    goodsSkuName.setHasImage(specValueVoList.getHasImage());
                    goodsSkuName.setId(specValueVoList.getId());
                    Integer specValueNameId = specValueVoList.getId();
                    if (specValueVoList.getId() != null && specValueVoList.getId() > 0) {
                        this.goodsSkuNameMapper.updateById((Object)goodsSkuName);
                    } else {
                        this.goodsSkuNameMapper.insert((Object)goodsSkuName);
                        specValueNameId = goodsSkuName.getId();
                    }
                    specValueNameIds.remove(specValueNameId);
                    List specLists = specValueVoList.getSpecList();
                    for (SpecListVo specList : specLists) {
                        GoodsSkuValue goodsSkuValue = new GoodsSkuValue();
                        goodsSkuValue.setSkuNameId(specValueNameId);
                        goodsSkuValue.setGoodsId(goodsUpdateValidate.getId());
                        goodsSkuValue.setValue(specList.getValue());
                        goodsSkuValue.setImage(StringUtils.substringDate((String)specList.getImage()));
                        goodsSkuValue.setId(specList.getId());
                        Integer specValueId = specList.getId();
                        if (specValueId != null && specValueId > 0) {
                            this.goodsSkuValueMapper.updateById((Object)goodsSkuValue);
                            specListData.put(specList.getValue(), specList.getId());
                            goodsSkuValueIds.remove(specValueId);
                            continue;
                        }
                        specValueId = this.goodsSkuValueMapper.insert((Object)goodsSkuValue);
                        specListData.put(specList.getValue(), goodsSkuValue.getId());
                    }
                }
                List serviceSpecValueList = goodsUpdateValidate.getSpecValueList();
                for (GoodsSkuVo goodsSkuVo : serviceSpecValueList) {
                    Integer goodsSkuId = goodsSkuVo.getId();
                    if (goodsSkuId != null && goodsSkuId > 0) {
                        GoodsSku goodsSku = new GoodsSku();
                        BeanUtils.copyProperties((Object)goodsSkuVo, (Object)goodsSku);
                        this.goodsSkuMapper.updateById((Object)goodsSku);
                    } else {
                        String skuValueArr = goodsSkuVo.getSkuValueArr();
                        GoodsSkuValue skuValueArrList = skuValueArr.split(",");
                        StringBuilder skuIds = new StringBuilder();
                        for (String skuName : skuValueArrList) {
                            Integer skuNameId = (Integer)specListData.get(skuName);
                            if (!skuIds.toString().equals("")) {
                                skuIds.append(",").append(skuNameId.toString());
                                continue;
                            }
                            skuIds = new StringBuilder(skuNameId.toString());
                        }
                        goodsSkuVo.setSkuValueIds(skuIds.toString());
                        goodsSkuVo.setGoodsId(goodsUpdateValidate.getId());
                        GoodsSku goodsSku = new GoodsSku();
                        BeanUtils.copyProperties((Object)goodsSkuVo, (Object)goodsSku);
                        goodsSkuId = this.goodsSkuMapper.insert((Object)goodsSku);
                    }
                    goodsSkuIds.remove(goodsSkuId);
                    priceList.add(goodsSkuVo.getPrice());
                    lineationPrice.add(goodsSkuVo.getLinePrice());
                    totalStock = totalStock + goodsSkuVo.getStock();
                }
                if (specValueNameIds.size() > 0) {
                    this.goodsSkuNameMapper.deleteBatchIds(specValueNameIds);
                }
                if (goodsSkuValueIds.size() > 0) {
                    this.goodsSkuValueMapper.deleteBatchIds(goodsSkuValueIds);
                }
                if (goodsSkuIds.size() > 0) {
                    this.goodsSkuMapper.deleteBatchIds(goodsSkuIds);
                }
            }
        }
        goodsSkuData.put("maxPrice", Collections.max(priceList));
        goodsSkuData.put("minPrice", Collections.min(priceList));
        goodsSkuData.put("minLineationPrice", Collections.min(lineationPrice));
        goodsSkuData.put("maxLineationPrice", Collections.max(lineationPrice));
        return goodsSkuData;
    }

    private void __checkAddGoodsData(GoodsCreateValidate goodsCreateValidate) {
        Goods goodsName = (Goods)this.goodsMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_delete", (Object)0)).eq((Object)"name", (Object)goodsCreateValidate.getName())).last("limit 1"));
        Assert.isNull((Object)goodsName, (String)"\u5546\u54c1\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        Goods goodsCode = (Goods)this.goodsMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_delete", (Object)0)).eq((Object)"code", (Object)goodsCreateValidate.getCode())).last("limit 1"));
        Assert.isNull((Object)goodsCode, (String)"\u5546\u54c1\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        List goodsCategoryList = this.goodsCategoryMapper.selectBatchIds((Collection)goodsCreateValidate.getCategoryId());
        if (goodsCategoryList.size() != goodsCreateValidate.getCategoryId().size()) {
            throw new ServiceException("\u5206\u7c7b\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u5237\u65b0\u5206\u7c7b");
        }
        List serviceSpecValueList = goodsCreateValidate.getSpecValueList();
        for (GoodsSkuVo goodsSkuVo : serviceSpecValueList) {
            if (StringUtils.isNull((Object)goodsSkuVo.getPrice()) || goodsSkuVo.getPrice().compareTo(BigDecimal.ZERO) < 0) {
                throw new ServiceException("\u9500\u552e\u4ef7\u683c\u4e0d\u80fd\u5c11\u4e8e0");
            }
            if (!StringUtils.isNull((Object)goodsSkuVo.getStock()) && goodsSkuVo.getStock() >= 0) continue;
            throw new ServiceException("\u5e93\u5b58\u6570\u4e0d\u80fd\u5c11\u4e8e0");
        }
    }

    public List<GoodsListedVo> getListByIds(Integer[] ids) {
        return this.goodsMapper.selectListByids(ids);
    }

    public List<AddInventoryGoodsVo> getGoodsList() {
        List goods = this.goodsMapper.selectList(null);
        List<AddInventoryGoodsVo> collect = goods.stream().map(good -> {
            AddInventoryGoodsVo vo = new AddInventoryGoodsVo();
            vo.setId(good.getId());
            vo.setName(good.getName());
            return vo;
        }).collect(Collectors.toList());
        return collect;
    }

    public List<RespGetListByIdsAndSkuVo> getListByIdsAndSku(GetStoreGoodsVo vo) {
        if (vo.getGoodsIds().length <= 0) {
            return new ArrayList<RespGetListByIdsAndSkuVo>();
        }
        List listByIdsAndSku = this.goodsMapper.getListByIdsAndSku(vo.getGoodsIds(), vo.getProductName(), null, null);
        ArrayList<RespGetListByIdsAndSkuVo> respData = new ArrayList<RespGetListByIdsAndSkuVo>();
        Map<Integer, List<GetListByIdsAndSkuVo>> collect = listByIdsAndSku.stream().collect(Collectors.groupingBy(GetListByIdsAndSkuVo::getGoodsId));
        collect.forEach((k, v) -> {
            RespGetListByIdsAndSkuVo resp = new RespGetListByIdsAndSkuVo();
            resp.setGoodsId(k);
            resp.setGoodsCode(((GetListByIdsAndSkuVo)v.get(0)).getGoodsCode());
            resp.setGoodsName(((GetListByIdsAndSkuVo)v.get(0)).getGoodsName());
            resp.setDescription(((GetListByIdsAndSkuVo)v.get(0)).getDescription());
            resp.setIsSku(Boolean.valueOf(false));
            if (v.size() > 1) {
                resp.setIsSku(Boolean.valueOf(true));
            }
            ArrayList skuDataList = new ArrayList();
            v.forEach(item -> {
                SkuDataVo skuData = new SkuDataVo();
                skuData.setSkuId(item.getSkuId());
                skuData.setImage(item.getImage());
                skuData.setSkuValueIds(item.getSkuValueIds());
                skuData.setSkuValueArr(item.getSkuValueArr());
                skuData.setPrice(item.getPrice());
                skuData.setLinePrice(item.getLinePrice());
                skuData.setMarketPrice(item.getMarketPrice());
                skuData.setStock(item.getStock());
                skuDataList.add(skuData);
            });
            resp.setSkuData(skuDataList);
            respData.add(resp);
        });
        return respData;
    }

    public List<RespGetListByIdsAndSkuVo> getStoreGoods(GetStoreGoodsVo vo) {
        List list = this.inventoryService.queryIdByStoreId(vo.getStoreId(), vo.getCreatedAt());
        if (list.size() <= 0) {
            return new ArrayList<RespGetListByIdsAndSkuVo>();
        }
        List<Integer> goodsIds = list.stream().map(Inventory::getGoodsId).collect(Collectors.toList());
        vo.setGoodsIds(goodsIds.toArray(new Integer[goodsIds.size()]));
        List listByIdsAndSku = this.getListByIdsAndSku(vo);
        listByIdsAndSku.forEach(item -> item.getSkuData().forEach(skuDataVo -> list.forEach(inventory -> {
            if (inventory.getGoodsId().equals(item.getGoodsId()) && inventory.getSpecId().equals(skuDataVo.getSkuId())) {
                skuDataVo.setInventoryId(inventory.getInventoryId());
                skuDataVo.setAddStock(inventory.getStock());
                skuDataVo.setSafetyStock(inventory.getSafetyStock());
                skuDataVo.setStatus(inventory.getStatus());
            }
        })));
        return listByIdsAndSku;
    }

    public void delRedis() {
        RedisUtil.deleteGoodsKeys((String)"goods:*");
    }
}

