/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.order.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import gz.lp.common.core.api.R;
import gz.lp.mall.order.entity.params.RefundParam;
import gz.lp.mall.order.entity.vo.StoreOrderInfoRespVo;
import gz.lp.mall.order.service.StoreOrderInfoService;
import gz.lp.system.api.domain.param.IdPrams;
import gz.lp.system.api.domain.param.PayOrderInfoPrams;
import gz.lp.system.api.domain.param.StoreOrderInfoListParams;
import gz.lp.system.api.domain.param.TypeParam;
import gz.lp.system.api.domain.vo.AppletOrderInfoDetailVo;
import gz.lp.system.api.param.QueryOrderStatusParam;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/storeOrderInfo"})
public class StoreOrderInfoController {
    @Autowired
    private StoreOrderInfoService storeOrderInfoService;

    @PostMapping(value={"/list"})
    public R<Page<StoreOrderInfoRespVo>> getOrderList(@RequestBody StoreOrderInfoListParams vo) {
        return R.success((Object)this.storeOrderInfoService.getOrderList(vo));
    }

    @PostMapping(value={"/takeOrder"})
    public R takeOrder(@RequestBody IdPrams prams) {
        return this.storeOrderInfoService.takeOrder(prams);
    }

    @PostMapping(value={"/refund"})
    public R refund(@RequestBody RefundParam prams) {
        return this.storeOrderInfoService.refund(prams);
    }

    @PostMapping(value={"/computeRefundPrice"})
    public R computeRefundPrice(@RequestBody RefundParam params) {
        return R.success((Object)this.storeOrderInfoService.computeRefundPrice(params));
    }

    @PostMapping(value={"/getDetail"})
    public R getDetail(@RequestBody IdPrams prams) {
        return R.success((Object)this.storeOrderInfoService.getDetail(prams));
    }

    @PostMapping(value={"/backProduct"})
    public R backProduct(@RequestBody IdPrams prams) {
        return this.storeOrderInfoService.backProduct(prams);
    }

    @PostMapping(value={"/getMyOrderList"})
    public R<Page<AppletOrderInfoDetailVo>> getMyOrderList(@RequestBody TypeParam vo) {
        return R.success((Object)this.storeOrderInfoService.getMyOrderList(vo));
    }

    @PostMapping(value={"/payNotify"})
    public String payNotify(HttpServletRequest xmlData) {
        return this.storeOrderInfoService.payNotify(xmlData);
    }

    @PostMapping(value={"/queryOrderByOutTradeNo"})
    public R queryOrderByOutTradeNo(@RequestBody QueryOrderStatusParam param) {
        return this.storeOrderInfoService.queryOrderByOutTradeNo(param.getOutTradeNo());
    }

    @PostMapping(value={"/payOrderInfo"})
    public R payOrderInfo(@RequestBody PayOrderInfoPrams vo) {
        return this.storeOrderInfoService.payOrderInfo(vo.getId());
    }
}

