/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.member.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import gz.lp.common.core.api.R;
import gz.lp.common.core.enums.enumeration.PointChangeTypeEnum;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.ip.IpUtils;
import gz.lp.common.pay.util.WxUtils;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.mall.member.entity.Member;
import gz.lp.mall.member.entity.PointsLog;
import gz.lp.mall.member.mapper.MemberMapper;
import gz.lp.mall.member.service.MemberJuniorService;
import gz.lp.mall.member.service.MemberService;
import gz.lp.mall.member.service.PointsLogService;
import gz.lp.system.api.domain.LoginBody;
import gz.lp.system.api.domain.MemberInfo;
import gz.lp.system.api.domain.param.AppletEditMemberParams;
import gz.lp.system.api.domain.param.GetMemberJuniorParams;
import gz.lp.system.api.domain.param.IdPrams;
import gz.lp.system.api.domain.vo.EditMemberVo;
import gz.lp.system.api.domain.vo.MemberJuniorRespVo;
import gz.lp.system.api.domain.vo.MemberPageRespVo;
import gz.lp.system.api.domain.vo.MemberPageVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class MemberServiceImpl
extends ServiceImpl<MemberMapper, Member>
implements MemberService {
    private static final Logger log = LoggerFactory.getLogger(MemberServiceImpl.class);
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private PointsLogService pointsLogService;
    @Autowired
    private MemberJuniorService memberJuniorService;

    public Page<MemberPageRespVo> queryByPage(MemberPageVo vo) {
        MPJLambdaWrapper wrapper = ((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper(Member.class).like(StringUtil.isNotBlank((CharSequence)vo.getNickname()), Member::getNickname, (Object)vo.getNickname())).like(StringUtil.isNotBlank((CharSequence)vo.getPhone()), Member::getPhone, (Object)vo.getPhone())).selectAll(Member.class)).select(new SFunction[]{Member::getId, Member::getNickname, Member::getPhone, Member::getGender, Member::getAvatar, Member::getPoints, Member::getCreateTime, Member::getLastTime});
        return (Page)this.memberMapper.selectJoinPage((IPage)new Page((long)vo.getPageNo().intValue(), (long)vo.getPageSize().intValue()), MemberPageRespVo.class, (MPJBaseJoin)wrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public String editMember(EditMemberVo vo) {
        Member member = (Member)this.memberMapper.selectById((Serializable)vo.getId());
        if (!ObjectUtils.isEmpty((Object)member)) {
            if (!ObjectUtils.isEmpty((Object)vo.getPhone())) {
                if (SecurityUtils.isAdmin((Long)SecurityUtils.getUserId())) {
                    member.setPhone(vo.getPhone());
                } else {
                    return "\u8bf7\u8054\u7cfb\u8d85\u7ea7\u7ba1\u7406\u5458\u4fee\u6539\u624b\u673a\u53f7";
                }
            }
            if (!ObjectUtils.isEmpty((Object)vo.getPoints())) {
                int points = vo.getPoints() + member.getPoints();
                int totalPoints = member.getTotalPoints() + vo.getPoints();
                if (points < 0) {
                    throw new ServiceException("\u79ef\u5206\u8c03\u6574\u5931\u8d25\uff0c\u79ef\u5206\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                }
                PointsLog pointsLog = PointsLog.builder().oldPoints(member.getPoints()).newPoints(Integer.valueOf(points)).memberId(member.getId()).changeAmount(vo.getPoints()).changeType(PointChangeTypeEnum.SYSTEM.getCode()).build();
                member.setPoints(Integer.valueOf(points));
                if (ObjectUtils.isEmpty((Object)this.pointsLogService.addPointsLog(pointsLog))) {
                    throw new ServiceException("\u79ef\u5206\u8c03\u6574\u5931\u8d25");
                }
            }
        } else {
            return "\u7f16\u8f91\u5931\u8d25\uff0c\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f";
        }
        this.memberMapper.updateById((Object)member);
        return null;
    }

    public Page<MemberJuniorRespVo> memberJuniorList(GetMemberJuniorParams vo) {
        Page memberJuniorRespVoPage = this.memberMapper.memberJuniorList(new Page((long)vo.getPageNo().intValue(), (long)vo.getPageSize().intValue()), vo);
        List<MemberJuniorRespVo> collect = memberJuniorRespVoPage.getRecords().stream().map(memberJuniorRespVo -> {
            memberJuniorRespVo.setHasChildren(memberJuniorRespVo.getTotalCount() > 0);
            return memberJuniorRespVo;
        }).toList();
        memberJuniorRespVoPage.setRecords(collect);
        return memberJuniorRespVoPage;
    }

    public Page<MemberJuniorRespVo> memberJuniorChildrenList(IdPrams vo) {
        MPJLambdaWrapper wrapper = (MPJLambdaWrapper)new MPJLambdaWrapper(Member.class).select(new SFunction[]{Member::getId, Member::getNickname, Member::getPhone, Member::getCreateTime, Member::getManagerPoints}).eq(Member::getManagerId, (Object)vo.getId());
        return (Page)this.memberMapper.selectJoinPage((IPage)new Page((long)vo.getPageNo().intValue(), (long)vo.getPageSize().intValue()), MemberJuniorRespVo.class, (MPJBaseJoin)wrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public MemberInfo login(LoginBody vo) {
        String openId = this.getOpenId(vo.getOpenIdCode());
        String phone = this.getPhone(vo.getPhoneCode(), openId);
        boolean isRegister = false;
        Member member = this.findMemberByOpenId(openId);
        if (member == null) {
            member = this.registerMember(vo, openId, phone);
            isRegister = true;
        } else {
            this.updateMemberLoginInfo(member);
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getInviteCode())) {
            this.memberJuniorService.bindManageMember(member, vo.getInviteCode(), isRegister);
        }
        return this.buildMemberInfo(member);
    }

    public MemberInfo getMemberInfo() {
        Member member = (Member)this.memberMapper.selectById((Serializable)SecurityUtils.getLoginUser().getMember().getId());
        return this.buildMemberInfo(member);
    }

    @Transactional(rollbackFor={Exception.class})
    public R appletEditMember(AppletEditMemberParams vo) {
        if (vo == null || SecurityUtils.getLoginUser() == null || SecurityUtils.getLoginUser().getMember() == null) {
            log.error("appletEditMember\u53c2\u6570\u6821\u9a8c\u5931\u8d25: vo={}, loginUser={}", (Object)vo, (Object)SecurityUtils.getLoginUser());
            return R.failed((String)"\u53c2\u6570\u6821\u9a8c\u5931\u8d25");
        }
        Integer memberId = SecurityUtils.getLoginUser().getMember().getId();
        if (memberId == null) {
            log.error("appletEditMember\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237ID\u5931\u8d25: memberId={}", (Object)memberId);
            return R.failed((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        Member member = new Member();
        member.setId(memberId);
        member.setAvatar(vo.getAvatar());
        member.setNickname(vo.getNickname());
        member.setGender(vo.getGender());
        int updateResult = this.memberMapper.updateById((Object)member);
        if (updateResult > 0) {
            log.info("appletEditMember\u66f4\u65b0\u4f1a\u5458\u4fe1\u606f\u6210\u529f: memberId={}, avatar={}, nickname={}, gender={}", new Object[]{memberId, vo.getAvatar(), vo.getNickname(), vo.getGender()});
            return R.success((Object)"\u4fee\u6539\u6210\u529f");
        }
        log.error("appletEditMember\u66f4\u65b0\u4f1a\u5458\u4fe1\u606f\u5931\u8d25: memberId={}, avatar={}, nickname={}, gender={}", new Object[]{memberId, vo.getAvatar(), vo.getNickname(), vo.getGender()});
        return R.failed((String)"\u4fee\u6539\u5931\u8d25");
    }

    public void buyGoodsAfter(Integer id, Integer useIntegral, BigDecimal balance, String orederNo) {
        if (useIntegral != null && useIntegral > 0 || balance != null && balance.compareTo(BigDecimal.ZERO) > 0) {
            Member member = this.memberMapper.selectForUpdate(id);
            int points = member.getPoints();
            PointsLog pointsLog = null;
            if (useIntegral != null && useIntegral > 0) {
                if (member.getPoints() < useIntegral) {
                    throw new ServiceException("\u79ef\u5206\u4e0d\u8db3");
                }
                pointsLog = new PointsLog();
                pointsLog.setMemberId(id);
                pointsLog.setOldPoints(Integer.valueOf(points));
                pointsLog.setNewPoints(member.getPoints());
                pointsLog.setChangeAmount(useIntegral);
                pointsLog.setChangeType(PointChangeTypeEnum.EXCHANGE.getCode());
                pointsLog.setReason("\u79ef\u5206\u5151\u6362\u5546\u54c1");
                pointsLog.setBizId(orederNo);
                member.setPoints(Integer.valueOf(member.getPoints() - useIntegral));
            }
            if (balance != null && balance.compareTo(BigDecimal.ZERO) > 0) {
                if (member.getBalance().compareTo(balance) < 0) {
                    throw new ServiceException("\u4f59\u989d\u4e0d\u8db3");
                }
                member.setBalance(member.getBalance().subtract(balance));
            }
            if (this.memberMapper.updateById((Object)member) > 0) {
                if (pointsLog != null) {
                    this.pointsLogService.addPointsLog(pointsLog);
                }
                PointsLog balanceLog = new PointsLog();
                balanceLog.setMemberId(id);
            }
        }
    }

    public R AppletEditMember(AppletEditMemberParams vo) {
        return this.memberMapper.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(Member.class).set(Member::getNickname, (Object)vo.getNickname())).set(Member::getAvatar, (Object)vo.getAvatar())).eq(Member::getId, (Object)SecurityUtils.getLoginUser().getMember().getId())) > 0 ? R.success((Object)"\u4fee\u6539\u6210\u529f") : R.failed((String)"\u4fee\u6539\u5931\u8d25");
    }

    private String getOpenId(String openIdCode) {
        if (StrUtil.isBlank((CharSequence)openIdCode)) {
            throw new ServiceException("\u83b7\u53d6openId\u53c2\u6570\u5931\u6548");
        }
        String openId = WxUtils.getWxOpenid((String)openIdCode);
        log.info("\u5c0f\u7a0b\u5e8f\u767b\u5f55\uff0c\u83b7\u53d6openId: {}", (Object)openId);
        if (StrUtil.isBlank((CharSequence)openId)) {
            throw new ServiceException("\u83b7\u53d6openId\u5931\u8d25");
        }
        return openId;
    }

    private String getPhone(String phoneCode, String openId) {
        String phone = WxUtils.getWxPhone((String)phoneCode, (String)openId);
        if (StrUtil.isBlank((CharSequence)phone)) {
            throw new ServiceException("\u83b7\u53d6\u624b\u673a\u53f7\u5931\u8d25");
        }
        return phone;
    }

    private Member registerMember(LoginBody vo, String openId, String phone) {
        Member regMember = new Member();
        regMember.setPhone(phone);
        regMember.setOpenid(openId);
        regMember.setLoginNum(Integer.valueOf(1));
        String memberId = this.getMemberId();
        while (this.memberMapper.selectOne((Wrapper)new LambdaQueryWrapper(Member.class).eq(Member::getMemberId, (Object)memberId)) != null) {
            memberId = this.getMemberId();
        }
        regMember.setMemberId(memberId);
        regMember.setLoginIp(IpUtils.getIpAddr());
        regMember.setNickname(vo.getNickname());
        regMember.setAvatar(vo.getAvatar());
        if (StrUtil.isNotBlank((CharSequence)vo.getInviteCode())) {
            Member member = (Member)this.memberMapper.selectOne((Wrapper)new LambdaQueryWrapper(Member.class).eq(Member::getMemberId, (Object)vo.getInviteCode()));
            regMember.setManagerId(member.getId());
        }
        regMember.setCreateTime(DateUtils.formatDate((String)DateUtils.getTime()));
        if (this.memberMapper.insert((Object)regMember) <= 0) {
            throw new ServiceException("\u6ce8\u518c\u5931\u8d25");
        }
        return regMember;
    }

    private void updateMemberLoginInfo(Member member) {
        this.memberMapper.updateMemberLoginInfo(member.getId());
    }

    private MemberInfo buildMemberInfo(Member member) {
        MemberInfo tokenMember = new MemberInfo();
        tokenMember.setId(member.getId());
        tokenMember.setPhone(StrUtil.isBlank((CharSequence)member.getPhone()) ? null : member.getPhone().substring(0, 3) + "****" + member.getPhone().substring(7));
        tokenMember.setMemberId(member.getMemberId());
        tokenMember.setAvatar(member.getAvatar());
        tokenMember.setNickname(member.getNickname());
        tokenMember.setOpenId(member.getOpenid());
        tokenMember.setPoints(member.getPoints());
        tokenMember.setIsVip(member.getIsVip());
        return tokenMember;
    }

    private Member findMemberByOpenId(String openId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"openid", (Object)openId)).last(" order by id desc limit 1");
        return (Member)this.memberMapper.selectOne((Wrapper)queryWrapper);
    }

    protected String getMemberId() {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String numericUuid = uuid.replaceAll("[^0-9]", "");
        return numericUuid.substring(0, 10);
    }

    public R getMyStatistics() {
        Integer memberId = SecurityUtils.getLoginUser().getMember().getId();
        return R.success((Object)((MemberMapper)this.baseMapper).getMyStatistics(memberId));
    }
}

