/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.inventory.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.common.core.api.R;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.tools;
import gz.lp.mall.inventory.entity.Inventory;
import gz.lp.mall.inventory.mapper.InventoryMapper;
import gz.lp.mall.inventory.service.InventoryService;
import gz.lp.mall.inventory.vo.EditInventoryInfoVo;
import gz.lp.system.api.domain.dto.ProductSpecStockDto;
import gz.lp.system.api.domain.param.AddInventoryParam;
import gz.lp.system.api.domain.param.DeleteInventoryParam;
import gz.lp.system.api.domain.param.EditInventoryParam;
import gz.lp.system.api.domain.param.QueryInventoryParam;
import gz.lp.system.api.domain.vo.QueryInventoryVo;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InventoryServiceImpl
extends ServiceImpl<InventoryMapper, Inventory>
implements InventoryService {
    @Autowired
    private InventoryMapper InventoryMapper;

    public List<Inventory> insetInventory(AddInventoryParam addAndEditInventoryParam) {
        List inventoryParams = addAndEditInventoryParam.getInventoryParams();
        List collect = null;
        if (inventoryParams.size() > 0) {
            List ids = inventoryParams.stream().map(in -> in.getSpecId()).collect(Collectors.toList());
            List productInventories = this.InventoryMapper.queryIds(ids, "1");
            if (productInventories.size() > 0) {
                throw new ServiceException("\u5f53\u524d\u9009\u62e9\u7684\u89c4\u683c\u5df2\u5b58\u5728\uff01");
            }
            collect = inventoryParams.stream().map(in -> {
                Inventory productInventory = Inventory.builder().build();
                try {
                    tools.structure((Object)productInventory, (Object)in, (Boolean)true);
                    productInventory.setStoreId(addAndEditInventoryParam.getStoreId());
                    productInventory.setCreatedAt(DateUtils.formatDate((String)DateUtils.getTime()));
                    return productInventory;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        return collect;
    }

    public IPage<QueryInventoryVo> queryInventory(QueryInventoryParam queryInventoryParam) {
        Page page = new Page((long)queryInventoryParam.getPageNo().intValue(), (long)queryInventoryParam.getPageSize().intValue());
        return this.InventoryMapper.query((IPage)page, queryInventoryParam);
    }

    public int editInventory(EditInventoryParam editInventoryParam) {
        Inventory productInventory = (Inventory)this.InventoryMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"inventory_id", (Object)editInventoryParam.getInventoryId())).eq((Object)"is_del", (Object)0));
        if (null == editInventoryParam) {
            throw new ServiceException("\u672a\u627e\u5230\u5f53\u524d\u5546\u54c1\u5e93\u5b58\uff01");
        }
        try {
            tools.structure((Object)productInventory, (Object)editInventoryParam, (Boolean)false);
            return this.InventoryMapper.updateById((Object)productInventory);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public int deleteInventory(DeleteInventoryParam deleteInventoryParam) {
        Inventory productInventory = (Inventory)this.InventoryMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"inventory_id", (Object)deleteInventoryParam.getInventoryId())).eq((Object)"is_del", (Object)0));
        productInventory.setUpdatedAt(DateUtils.formatDate((String)DateUtils.getTime()));
        return this.InventoryMapper.updateById((Object)productInventory);
    }

    public ProductSpecStockDto queryProductSpecStock(Integer specId, Integer storeId, Integer productId) {
        return null;
    }

    public List<Integer> getStoreListBySpecId(String specIds) {
        if (StringUtil.isNotBlank((CharSequence)specIds)) {
            List<Integer> storeIdList = this.InventoryMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().select((Object[])new String[]{"distinct store_id"})).in((Object)"spec_id", new Object[]{specIds})).eq((Object)"is_del", (Object)0)).stream().map(Inventory::getStoreId).toList();
            return storeIdList;
        }
        return null;
    }

    public boolean operationStock(Integer inventoryId, Integer num, String type) {
        Inventory inventory = this.InventoryMapper.selectForUpdate(inventoryId);
        if ("sub".equals(type)) {
            if (inventory.getStock() - num < 0) {
                return false;
            }
            inventory.setStock(Integer.valueOf(inventory.getStock() - num));
        } else {
            inventory.setStock(Integer.valueOf(inventory.getStock() + num));
        }
        return this.InventoryMapper.updateById((Object)inventory) > 0;
    }

    public R addInventoryInfo(List<Inventory> list) {
        if (list.get(0).getSpecId() == null || list.get(0).getStoreId() == 0) {
            return R.failed((String)"\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        list.forEach(item -> {
            item.setCreatedAt(new Date());
            item.setUpdatedAt(new Date());
        });
        if (this.saveBatch(list)) {
            return R.success((Object)"\u6dfb\u52a0\u6210\u529f");
        }
        return R.failed((String)"\u6dfb\u52a0\u5931\u8d25\uff01");
    }

    public List<Inventory> queryIdByStoreId(Integer storeId, String date) {
        return ((InventoryMapper)this.baseMapper).queryIdByStoreId(storeId, date);
    }

    public R editInventoryInfo(EditInventoryInfoVo vo) {
        if (vo.getInventoryId() == null || vo.getInventoryId() == 0 || vo.getAddStock() == null || vo.getSafetyStock() == null || vo.getStatus() == null) {
            return R.failed((String)"\u7f16\u8f91\u5931\u8d25\uff01\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        Inventory inventory = Inventory.builder().inventoryId(vo.getInventoryId()).stock(vo.getAddStock()).safetyStock(vo.getSafetyStock()).status(vo.getStatus()).build();
        if (this.updateById((Object)inventory)) {
            return R.success((Object)"\u7f16\u8f91\u6210\u529f");
        }
        return R.failed((String)"\u7f16\u8f91\u5931\u8d25\uff01");
    }

    private R addInfo(Inventory inventory) {
        if (inventory.getSpecId() == null || inventory.getStoreId() == 0) {
            return R.failed((String)"\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        if (inventory.getStock() < 1) {
            return R.failed((String)"\u5e93\u5b58\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        inventory.setCreatedAt(new Date());
        inventory.setUpdatedAt(new Date());
        if (this.InventoryMapper.insert((Object)inventory) > 0) {
            return R.success((Object)"\u6dfb\u52a0\u6210\u529f");
        }
        return R.failed((String)"\u6dfb\u52a0\u5931\u8d25\uff01");
    }
}

