/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.coupon.controller;

import gz.lp.common.core.api.R;
import gz.lp.mall.coupon.param.CouponUsageDeleteParam;
import gz.lp.mall.coupon.param.CouponUsageListParam;
import gz.lp.mall.coupon.service.CouponUsageService;
import gz.lp.system.api.domain.QueryMyCouponsVo;
import gz.lp.system.api.domain.ReceiveCouponsVo;
import gz.lp.system.api.domain.UseCouponVo;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponUsage"})
public class CouponUsageController {
    @Autowired
    private CouponUsageService service;

    @PostMapping(value={"/list"})
    public R list(@RequestBody CouponUsageListParam param) {
        return this.service.getList(param);
    }

    @PostMapping(value={"/receiveCoupons"})
    public R add(@RequestBody ReceiveCouponsVo couponUsage) {
        return this.service.claimCoupon(couponUsage);
    }

    @PostMapping(value={"/delete"})
    public R delete(@RequestBody CouponUsageDeleteParam param) {
        return this.service.removeById((Serializable)param.getId()) ? R.ok() : R.failed();
    }

    @PostMapping(value={"/use"})
    public R use(@RequestBody UseCouponVo vo) {
        return this.service.useCoupon(vo);
    }

    @PostMapping(value={"/useList"})
    public R useList(@RequestBody QueryMyCouponsVo vo) {
        return this.service.getMyUseList(vo);
    }
}

